/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.HeaderSetImpl;
import com.sun.kvem.jsr082.obex.ObexPacketStream;
import com.sun.kvem.jsr082.obex.ObexTransport;
import com.sun.kvem.jsr082.obex.ServerOperation;
import com.sun.kvem.obex.Authenticator;
import com.sun.kvem.obex.ServerRequestHandler;
import java.io.IOException;
import javax.microedition.io.Connection;

class ServerConnectionImpl
extends ObexPacketStream
implements Connection,
Runnable {
    private static final boolean DEBUG = false;
    ServerRequestHandler handler;
    private int maxClientPacketSize;
    private int owner;
    private boolean isConnected;
    private long connId;
    boolean operationHeadersOverflow = false;
    boolean operationClosed;

    void headerTooLarge() throws IOException {
        this.operationHeadersOverflow = true;
        this.operationClosed = true;
    }

    ServerConnectionImpl(ObexTransport obexTransport, ServerRequestHandler serverRequestHandler, Authenticator authenticator) throws IOException {
        super(obexTransport);
        this.handler = serverRequestHandler;
        this.isClient = false;
        this.authenticator = authenticator;
        this.owner = 1;
        new Thread(this).start();
    }

    public void run() {
        try {
            while (this.processRequest() && !this.isClosed()) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.close();
    }

    private int sendResponsePacket(byte[] byArray, HeaderSetImpl headerSetImpl) throws IOException {
        int n = byArray[0] & 0xFF;
        this.packetBegin(byArray);
        this.packetAddConnectionID(this.getConnectionID(), headerSetImpl);
        this.packetAddAuthResponses();
        this.packetAddHeaders(headerSetImpl);
        if (!this.queuedHeaders.isEmpty() || this.operationHeadersOverflow) {
            this.queuedHeaders.removeAllElements();
            this.setPacketType(206);
        }
        this.packetEnd();
        return n;
    }

    private void doConnect() throws IOException {
        byte[] byArray;
        HeaderSetImpl headerSetImpl = new HeaderSetImpl(this.owner);
        HeaderSetImpl headerSetImpl2 = new HeaderSetImpl(this.owner);
        if (this.buffer[3] != 16 || this.packetLength < 7) {
            throw new IOException("unsupported client obex version");
        }
        this.maxSendLength = this.decodeLength16(5);
        if (this.maxSendLength > this.OBEX_MAXIMUM_PACKET_LENGTH) {
            this.maxSendLength = this.OBEX_MAXIMUM_PACKET_LENGTH;
        }
        this.parsePacketHeaders(headerSetImpl, 7);
        int n = 208;
        try {
            n = this.handler.onConnect(headerSetImpl, headerSetImpl2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        n = ServerConnectionImpl.validateStatus(n);
        if (n != 160) {
            this.authResponses.removeAllElements();
        }
        if ((n = this.sendResponsePacket(byArray = new byte[]{(byte)n, 0, 0, 16, 0, (byte)(this.OBEX_MAXIMUM_PACKET_LENGTH / 256), (byte)(this.OBEX_MAXIMUM_PACKET_LENGTH % 256)}, headerSetImpl2)) == 160) {
            this.isConnected = true;
        }
    }

    private boolean notConnected() throws IOException {
        if (!this.isConnected) {
            HeaderSetImpl headerSetImpl = new HeaderSetImpl(this.owner);
            headerSetImpl.setHeader(5, "not connected");
            this.sendPacket(PACKET_BAD_REQUEST, this.getConnectionID(), headerSetImpl, true);
            return true;
        }
        return false;
    }

    void onAuthenticationFailure(byte[] byArray) throws IOException {
        try {
            this.handler.onAuthenticationFailure(byArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.operationClosed = true;
    }

    private void doDisconnect() throws IOException {
        if (this.notConnected()) {
            return;
        }
        HeaderSetImpl headerSetImpl = new HeaderSetImpl(this.owner);
        HeaderSetImpl headerSetImpl2 = new HeaderSetImpl(this.owner);
        this.parsePacketHeaders(headerSetImpl, 3);
        try {
            this.handler.onDisconnect(headerSetImpl, headerSetImpl2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        byte[] byArray = new byte[]{-96, 0, 0};
        int n = this.sendResponsePacket(byArray, headerSetImpl2);
        if (n == 160) {
            this.isConnected = false;
        }
    }

    private void doPut(HeaderSetImpl headerSetImpl) throws IOException {
        int n = 208;
        ServerOperation serverOperation = new ServerOperation(this, headerSetImpl);
        try {
            n = this.handler.onPut(serverOperation);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        n = ServerConnectionImpl.validateStatus(n);
        if (this.operationHeadersOverflow) {
            n = 206;
        }
        serverOperation.destroy(n);
    }

    private void doDelete(HeaderSetImpl headerSetImpl) throws IOException {
        HeaderSetImpl headerSetImpl2 = new HeaderSetImpl(this.owner);
        int n = 208;
        try {
            n = this.handler.onDelete(headerSetImpl, headerSetImpl2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        n = ServerConnectionImpl.validateStatus(n);
        byte[] byArray = new byte[]{(byte)n, 0, 0};
        this.sendResponsePacket(byArray, headerSetImpl2);
    }

    private void doPutOrDelete() throws IOException {
        if (this.notConnected()) {
            return;
        }
        HeaderSetImpl headerSetImpl = new HeaderSetImpl(this.owner);
        int n = ServerOperation.waitForData(this, headerSetImpl, 2);
        switch (n) {
            case 0: {
                this.sendPacket(PACKET_SUCCESS, this.getConnectionID(), null, true);
                return;
            }
            case 1: {
                this.doPut(headerSetImpl);
                return;
            }
            case 2: {
                this.doDelete(headerSetImpl);
                return;
            }
        }
    }

    private void doGet() throws IOException {
        if (this.notConnected()) {
            return;
        }
        int n = 208;
        ServerOperation serverOperation = new ServerOperation(this);
        try {
            n = this.handler.onGet(serverOperation);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        n = ServerConnectionImpl.validateStatus(n);
        if (this.operationHeadersOverflow) {
            n = 206;
        }
        serverOperation.destroy(n);
    }

    private void doSetPath() throws IOException {
        if (this.notConnected()) {
            return;
        }
        HeaderSetImpl headerSetImpl = new HeaderSetImpl(this.owner);
        HeaderSetImpl headerSetImpl2 = new HeaderSetImpl(this.owner);
        boolean bl = (this.buffer[3] & 2) == 0;
        boolean bl2 = (this.buffer[3] & 1) == 1;
        this.parsePacketHeaders(headerSetImpl, 5);
        int n = 208;
        try {
            n = this.handler.onSetPath(headerSetImpl, headerSetImpl2, bl2, bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        n = ServerConnectionImpl.validateStatus(n);
        byte[] byArray = new byte[]{(byte)n, 0, 0};
        this.sendResponsePacket(byArray, headerSetImpl2);
    }

    private boolean processRequest() throws IOException {
        try {
            this.recvPacket();
        }
        catch (IOException iOException) {
            return false;
        }
        HeaderSetImpl headerSetImpl = new HeaderSetImpl(this.owner);
        HeaderSetImpl headerSetImpl2 = new HeaderSetImpl(this.owner);
        this.operationHeadersOverflow = false;
        this.operationClosed = false;
        this.isEof = false;
        switch (this.packetType) {
            case 128: {
                this.doConnect();
                break;
            }
            case 129: {
                this.doDisconnect();
                break;
            }
            case 2: 
            case 130: {
                this.doPutOrDelete();
                break;
            }
            case 3: 
            case 131: {
                this.doGet();
                break;
            }
            case 133: {
                this.doSetPath();
                break;
            }
            case 255: {
                byte[] byArray = new byte[]{-96, 0, 0};
                this.sendResponsePacket(byArray, null);
                break;
            }
            default: {
                this.sendPacket(PACKET_NOT_IMPLEMENTED, this.getConnectionID(), null, true);
            }
        }
        return true;
    }

    public void setConnectionID(long l) {
        try {
            this.connId = l;
            this.handler.setConnectionID(l);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public long getConnectionID() {
        try {
            long l = this.handler.getConnectionID();
            if (this.connId == l) {
                return -1L;
            }
            this.connId = l;
            return l;
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }
}

