/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.HeaderSetImpl;
import com.sun.kvem.jsr082.obex.ObexAuth;
import com.sun.kvem.jsr082.obex.ObexPacketStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Vector;

public class QueuedHeader {
    private static final boolean DEBUG = false;
    private ObexPacketStream stream;
    private int type;
    private Object value;
    byte[] buffer;
    int packetLength;

    QueuedHeader(ObexPacketStream obexPacketStream) {
        this.stream = obexPacketStream;
    }

    void sendOrQueue(int n, Object object) throws IOException {
        if (this.stream.moreHeaders && this.send(n, object)) {
            this.stream.challengesToSend = true;
            return;
        }
        this.queue(n, object);
    }

    void queue(int n, Object object) throws IOException {
        int n2 = this.stream.maxSendLength;
        boolean bl = false;
        switch (HeaderSetImpl.internalType(n)) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (((String)object).length() + 7 <= n2) break;
                bl = true;
                break;
            }
            case 0: {
                if ((((String)object).length() << 1) + 8 <= n2) break;
                bl = true;
                break;
            }
            case 1: {
                if (((byte[])object).length + 6 <= n2) break;
                bl = true;
                break;
            }
            case 8: {
                Vector vector = (Vector)object;
                if (vector.isEmpty()) {
                    return;
                }
                int n3 = 0;
                for (int i = 0; i < vector.size(); ++i) {
                    n3 += ((ObexAuth)vector.elementAt(i)).prepareChallenge();
                }
                if (n3 + 3 <= n2) break;
                bl = true;
            }
        }
        if (bl) {
            this.stream.headerTooLarge();
            return;
        }
        this.type = n;
        this.value = object;
        this.newHeader();
    }

    boolean trySendAgain() throws IOException {
        return this.send(this.type, this.value);
    }

    boolean send(int n, Object object) throws IOException {
        this.buffer = this.stream.buffer;
        this.packetLength = this.stream.packetLength;
        int n2 = this.stream.maxSendLength;
        try {
            this.buffer[this.packetLength++] = (byte)n;
            switch (HeaderSetImpl.internalType(n)) {
                case 5: {
                    this.encodeTime8601((Calendar)object);
                    break;
                }
                case 4: {
                    this.encodeInt(((Calendar)object).getTime().getTime() / 1000L);
                    break;
                }
                case 6: {
                    byte[] byArray = ((String)object).getBytes("ISO-8859-1");
                    this.encodeLength16(byArray.length + 4);
                    System.arraycopy(byArray, 0, this.buffer, this.packetLength, byArray.length);
                    this.packetLength += byArray.length;
                    this.buffer[this.packetLength++] = 0;
                    break;
                }
                case 8: {
                    int n3;
                    --this.packetLength;
                    Vector vector = (Vector)object;
                    this.stream.authFailed = false;
                    for (n3 = 0; n3 < vector.size(); ++n3) {
                        ObexAuth obexAuth = (ObexAuth)vector.elementAt(n3);
                        this.packetLength += obexAuth.addChallenge(this.buffer, this.packetLength);
                    }
                    if (this.packetLength > n2) break;
                    for (n3 = 0; n3 < vector.size(); ++n3) {
                        this.stream.authFailed = true;
                        this.stream.authChallenges.addElement(vector.elementAt(n3));
                    }
                    break;
                }
                case 3: {
                    this.encodeInt((Long)object);
                    break;
                }
                case 0: {
                    byte[] byArray = ((String)object).getBytes("UTF-16BE");
                    this.encodeLength16(byArray.length + 5);
                    System.arraycopy(byArray, 0, this.buffer, this.packetLength, byArray.length);
                    this.packetLength += byArray.length;
                    this.buffer[this.packetLength++] = 0;
                    this.buffer[this.packetLength++] = 0;
                    break;
                }
                case 1: {
                    byte[] byArray = (byte[])object;
                    this.encodeLength16(byArray.length + 3);
                    System.arraycopy(byArray, 0, this.buffer, this.packetLength, byArray.length);
                    this.packetLength += byArray.length;
                    this.stream.containsTargetHeader = this.stream.containsTargetHeader | n == 70;
                    break;
                }
                case 2: {
                    this.buffer[this.packetLength++] = (Byte)object;
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.stream.moreHeaders = false;
            return false;
        }
        if (this.packetLength > n2) {
            this.stream.moreHeaders = false;
            return false;
        }
        if (this.stream.dataOpened) {
            int n4 = this.stream.dataOffset;
            int n5 = this.stream.packetLength - n4;
            this.buffer[n4 + 1] = (byte)(n5 >> 8);
            this.buffer[n4 + 2] = (byte)n5;
            this.stream.dataOpened = false;
            this.stream.dataClosed = true;
        }
        this.stream.packetLength = this.packetLength;
        this.value = null;
        return true;
    }

    private void newHeader() {
        this.stream.queuedHeaders.addElement(this);
        this.stream.newHeader = this.stream.emptyHeadersPool.empty() ? new QueuedHeader(this.stream) : (QueuedHeader)this.stream.emptyHeadersPool.pop();
    }

    private void removeHeader() {
        this.stream.queuedHeaders.removeElement(this);
        this.stream.emptyHeadersPool.push(this);
    }

    boolean sendAllQueued() throws IOException {
        while (this.stream.queuedHeaders.size() > 0 && this.stream.moreHeaders) {
            QueuedHeader queuedHeader = (QueuedHeader)this.stream.queuedHeaders.firstElement();
            boolean bl = queuedHeader.trySendAgain();
            if (!bl) {
                return false;
            }
            this.stream.queuedHeaders.removeElementAt(0);
        }
        return true;
    }

    private final void encodeInt(long l) {
        this.buffer[this.packetLength++] = (byte)(l >> 24);
        this.buffer[this.packetLength++] = (byte)(l >> 16);
        this.buffer[this.packetLength++] = (byte)(l >> 8);
        this.buffer[this.packetLength++] = (byte)l;
    }

    private final void encodeLength16(int n) {
        this.buffer[this.packetLength++] = (byte)(n >> 8);
        this.buffer[this.packetLength++] = (byte)n;
    }

    private final void encodeTime8601(Calendar calendar) {
        this.encodeLength16(19);
        Calendar calendar2 = Calendar.getInstance(ObexPacketStream.utcTimeZone);
        calendar2.setTime(calendar.getTime());
        int n = calendar2.get(1);
        int n2 = calendar2.get(2) + 1;
        int n3 = calendar2.get(5);
        int n4 = calendar2.get(11);
        int n5 = calendar2.get(12);
        int n6 = calendar2.get(13);
        int n7 = 48;
        if (n < 0 || n > 9999) {
            // empty if block
        }
        this.buffer[this.packetLength++] = (byte)(n / 1000 + n7);
        this.buffer[this.packetLength++] = (byte)((n %= 1000) / 100 + n7);
        this.buffer[this.packetLength++] = (byte)((n %= 100) / 10 + n7);
        this.buffer[this.packetLength++] = (byte)((n %= 10) + n7);
        this.buffer[this.packetLength++] = (byte)(n2 / 10 + n7);
        this.buffer[this.packetLength++] = (byte)(n2 % 10 + n7);
        this.buffer[this.packetLength++] = (byte)(n3 / 10 + n7);
        this.buffer[this.packetLength++] = (byte)(n3 % 10 + n7);
        this.buffer[this.packetLength++] = 84;
        this.buffer[this.packetLength++] = (byte)(n4 / 10 + n7);
        this.buffer[this.packetLength++] = (byte)(n4 % 10 + n7);
        this.buffer[this.packetLength++] = (byte)(n5 / 10 + n7);
        this.buffer[this.packetLength++] = (byte)(n5 % 10 + n7);
        this.buffer[this.packetLength++] = (byte)(n6 / 10 + n7);
        this.buffer[this.packetLength++] = (byte)(n6 % 10 + n7);
        this.buffer[this.packetLength++] = 90;
    }
}

