/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.HeaderSetImpl;
import com.sun.kvem.jsr082.obex.ObexAuth;
import com.sun.kvem.jsr082.obex.ObexTransport;
import com.sun.kvem.jsr082.obex.QueuedHeader;
import com.sun.kvem.obex.Authenticator;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.io.Connection;

public abstract class ObexPacketStream
implements Connection {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG2 = false;
    static final int OPCODE_CONNECT = 128;
    static final int OPCODE_DISCONNECT = 129;
    static final int OPCODE_PUT = 2;
    static final int OPCODE_GET = 3;
    static final int OPCODE_SETPATH = 133;
    static final int OPCODE_CONTINUE = 144;
    static final int OPCODE_ABORT = 255;
    static final int OPCODE_FINAL = 128;
    static final int OPCODE_GET_FINAL = 131;
    static final byte[] PACKET_ABORT = new byte[]{-1, 0, 0};
    static final byte[] PACKET_CONTINUE = new byte[]{-112, 0, 0};
    static final byte[] PACKET_DISCONNECT = new byte[]{-127, 0, 0};
    static final byte[] PACKET_SUCCESS = new byte[]{-96, 0, 0};
    static final byte[] PACKET_BAD_REQUEST = new byte[]{-64, 0, 0};
    static final byte[] PACKET_NOT_IMPLEMENTED = new byte[]{-47, 0, 0};
    private static final int HEADER_BODY = 72;
    private static final int HEADER_EOFBODY = 73;
    private static final int HEADER_CONNECTION_ID = 203;
    static final int HEADER_AUTH_CHALLENGE = 77;
    static final int HEADER_AUTH_RESPONSE = 78;
    static TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
    private static final byte[] nullChar = new byte[]{0, 0};
    private ObexTransport transport;
    Authenticator authenticator;
    Vector authResponses = new Vector();
    Vector authChallenges = new Vector();
    boolean moreHeaders = false;
    boolean challengesToSend = false;
    boolean headerOverflow = false;
    boolean containsTargetHeader = false;
    Vector queuedHeaders;
    QueuedHeader newHeader;
    Stack emptyHeadersPool;
    boolean authFailed = false;
    boolean isClient;
    boolean isConnected;
    int OBEX_MAXIMUM_PACKET_LENGTH;
    byte[] buffer;
    int packetLength;
    int packetOffset;
    int packetType;
    int maxSendLength;
    boolean dataOpened;
    boolean dataClosed;
    boolean isEof;
    int dataOffset;

    ObexPacketStream(ObexTransport obexTransport) {
        this.transport = obexTransport;
        this.OBEX_MAXIMUM_PACKET_LENGTH = obexTransport.getMaximumPacketSize();
        this.buffer = new byte[this.OBEX_MAXIMUM_PACKET_LENGTH];
        this.maxSendLength = this.OBEX_MAXIMUM_PACKET_LENGTH;
        this.newHeader = new QueuedHeader(this);
        this.queuedHeaders = new Vector();
        this.emptyHeadersPool = new Stack();
    }

    public void close() {
        try {
            if (this.transport != null) {
                this.transport.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.transport = null;
    }

    public void setAuthenticator(Authenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("null authenticator");
        }
        this.authenticator = authenticator;
    }

    public Connection getTransport() {
        return this.transport.getUnderlyingConnection();
    }

    void brokenLink() {
        this.close();
    }

    boolean isClosed() {
        return this.transport == null;
    }

    void packetBegin(byte[] byArray) {
        this.containsTargetHeader = false;
        this.moreHeaders = true;
        this.challengesToSend = false;
        System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
        this.packetLength = byArray.length;
        this.authChallenges.removeAllElements();
        this.dataOpened = false;
        this.dataClosed = false;
        this.dataOffset = -3;
    }

    int packetAddData(byte[] byArray, int n, int n2) {
        if (this.dataClosed) {
            return 0;
        }
        if (!this.dataOpened) {
            if (this.packetLength + 6 > this.maxSendLength) {
                return 0;
            }
            this.buffer[this.packetLength] = 72;
            this.dataOffset = this.packetLength;
            this.packetLength += 3;
            this.dataOpened = true;
        }
        int n3 = this.packetLength + n2 > this.maxSendLength ? this.maxSendLength - this.packetLength : n2;
        System.arraycopy(byArray, n, this.buffer, this.packetLength, n3);
        this.packetLength += n3;
        return n3;
    }

    int getPacketLength() {
        return this.packetLength;
    }

    void restorePacketLength(int n) {
        this.packetLength = n;
    }

    boolean packetEOFBody() {
        if (this.dataClosed) {
            return false;
        }
        if (this.dataOpened) {
            this.buffer[this.dataOffset + 0] = 73;
            return true;
        }
        if (this.packetLength + 3 > this.maxSendLength) {
            return false;
        }
        this.buffer[this.packetLength++] = 73;
        this.buffer[this.packetLength++] = 0;
        this.buffer[this.packetLength++] = 3;
        return true;
    }

    void packetMarkFinal() {
        this.buffer[0] = (byte)(this.buffer[0] | 0x80);
    }

    void setPacketType(int n) {
        this.buffer[0] = (byte)n;
    }

    void packetEndStripConnID() throws IOException {
        if ((this.buffer[3] & 0xFF) == 70) {
            this.packetLength -= 5;
            for (int i = 3; i < this.packetLength; ++i) {
                this.buffer[i] = this.buffer[i + 5];
            }
        }
        this.packetEnd();
    }

    void packetEnd() throws IOException {
        this.moreHeaders = false;
        if (this.transport == null) {
            throw new IOException("connection error");
        }
        if (this.dataOpened) {
            int n = this.packetLength - this.dataOffset;
            this.buffer[this.dataOffset + 1] = (byte)(n >> 8);
            this.buffer[this.dataOffset + 2] = (byte)n;
            this.dataOpened = false;
            this.dataClosed = true;
        }
        this.buffer[1] = (byte)(this.packetLength / 256);
        this.buffer[2] = (byte)(this.packetLength % 256);
        try {
            this.transport.write(this.buffer, this.packetLength);
        }
        catch (IOException iOException) {
            this.brokenLink();
            throw iOException;
        }
    }

    final void packetAddConnectionID(long l, HeaderSetImpl headerSetImpl) {
        if (headerSetImpl != null && headerSetImpl.getHeader(70) != null) {
            return;
        }
        if (l < 0L || l > 0xFFFFFFFFL) {
            return;
        }
        this.buffer[this.packetLength++] = -53;
        this.encodeInt(l);
    }

    abstract void headerTooLarge() throws IOException;

    final void packetAddHeaders(HeaderSetImpl headerSetImpl) throws IOException {
        this.headerOverflow = false;
        this.newHeader.sendAllQueued();
        if (headerSetImpl == null) {
            return;
        }
        int[] nArray = headerSetImpl.getHeaderList();
        if (!headerSetImpl.challenges.isEmpty()) {
            this.newHeader.sendOrQueue(77, headerSetImpl.challenges);
        }
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            Object object = headerSetImpl.getHeader(n);
            this.newHeader.sendOrQueue(n, object);
        }
    }

    void packetAddAuthResponses() throws IOException {
        try {
            for (int i = 0; i < this.authResponses.size(); ++i) {
                ObexAuth obexAuth = (ObexAuth)this.authResponses.elementAt(i);
                int n = obexAuth.replyAuthChallenge(this.buffer, this.packetLength, this.authenticator);
                this.packetLength += n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("auth response request too large");
        }
        if (this.packetLength > this.maxSendLength) {
            throw new IOException("auth response request too large");
        }
    }

    final void sendPacket(byte[] byArray, long l, HeaderSetImpl headerSetImpl, boolean bl) throws IOException {
        this.packetBegin(byArray);
        this.packetAddConnectionID(l, headerSetImpl);
        this.packetAddAuthResponses();
        this.packetAddHeaders(headerSetImpl);
        if (bl && !this.queuedHeaders.isEmpty()) {
            this.queuedHeaders.removeAllElements();
            throw new IOException("packet too large for peer");
        }
        this.packetEnd();
    }

    private final void encodeInt(long l) {
        this.buffer[this.packetLength++] = (byte)(l >> 24);
        this.buffer[this.packetLength++] = (byte)(l >> 16);
        this.buffer[this.packetLength++] = (byte)(l >> 8);
        this.buffer[this.packetLength++] = (byte)l;
    }

    final void recvPacket() throws IOException {
        this.authResponses.removeAllElements();
        if (this.transport == null) {
            throw new IOException("connection error");
        }
        try {
            this.packetLength = this.transport.read(this.buffer);
            this.packetType = this.buffer[0] & 0xFF;
        }
        catch (IOException iOException) {
            this.brokenLink();
            throw iOException;
        }
    }

    private final void parseHeader(HeaderSetImpl headerSetImpl) throws IOException {
        try {
            int n = this.buffer[this.packetOffset++] & 0xFF;
            int n2 = n >> 6;
            int n3 = HeaderSetImpl.internalType(n);
            if (n3 != 7) {
                n2 = n3;
            }
            Object object = null;
            switch (n2) {
                case 5: {
                    object = this.decodeTime8601();
                    break;
                }
                case 4: {
                    long l = this.decodeInt();
                    Calendar calendar = Calendar.getInstance(utcTimeZone);
                    calendar.setTime(new Date(l * 1000L));
                    object = calendar;
                    this.packetOffset += 4;
                    break;
                }
                case 6: {
                    int n4 = this.decodeLength16(this.packetOffset) - 3;
                    this.packetOffset += 2;
                    if (this.buffer[this.packetOffset + n4 - 1] != 0) {
                        throw new IOException("protocol error, type field not null terminated");
                    }
                    object = new String(this.buffer, this.packetOffset, n4 - 1, "ISO-8859-1");
                    this.packetOffset += n4;
                    break;
                }
                case 3: {
                    object = new Long(this.decodeInt());
                    this.packetOffset += 4;
                    break;
                }
                case 0: {
                    int n5 = this.decodeLength16(this.packetOffset) - 3;
                    this.packetOffset += 2;
                    if (n5 < 2 || this.buffer[this.packetOffset + n5 - 1] != 0 || this.buffer[this.packetOffset + n5 - 2] != 0) {
                        throw new IOException("protocol error, unicode string is not null terminated");
                    }
                    object = new String(this.buffer, this.packetOffset, n5 - 2, "UTF-16BE");
                    this.packetOffset += n5;
                    break;
                }
                case 1: {
                    int n6 = this.decodeLength16(this.packetOffset) - 3;
                    this.packetOffset += 2;
                    object = new byte[n6];
                    System.arraycopy(this.buffer, this.packetOffset, object, 0, n6);
                    this.packetOffset += n6;
                    break;
                }
                case 2: {
                    object = new Byte(this.buffer[this.packetOffset++]);
                    break;
                }
                case 8: {
                    int n7 = this.decodeLength16(this.packetOffset);
                    ObexAuth obexAuth = ObexAuth.parseAuthChallenge(this.buffer, this.packetOffset - 1, n7);
                    if (obexAuth != null) {
                        this.authResponses.addElement(obexAuth);
                    }
                    this.packetOffset += n7 - 1;
                    return;
                }
                case 9: {
                    int n8 = this.decodeLength16(this.packetOffset);
                    boolean bl = ObexAuth.checkAuthResponse(this.buffer, this.packetOffset - 1, n8, this, this.authChallenges);
                    if (bl) {
                        this.authFailed = false;
                    }
                    this.packetOffset += n8 - 1;
                    return;
                }
            }
            if (this.packetOffset > this.packetLength) {
                throw new IOException("protocol error");
            }
            if (n3 != 7) {
                headerSetImpl.setHeader(n, object);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("protocol error");
        }
    }

    abstract void onAuthenticationFailure(byte[] var1) throws IOException;

    void onMissingAuthResponse() throws IOException {
    }

    boolean shouldSendAuthResponse() {
        return this.packetType == 193 && this.authResponses.size() != 0;
    }

    final void parsePacketHeaders(HeaderSetImpl headerSetImpl, int n) throws IOException {
        this.packetOffset = n;
        headerSetImpl.packetType = this.buffer[0] & 0xFF;
        this.parseConnectionID();
        while (this.packetOffset != this.packetLength) {
            this.parseHeader(headerSetImpl);
        }
        this.parseEnd();
    }

    private final void parseConnectionID() {
        int n = this.buffer[this.packetOffset] & 0xFF;
        if (this.packetOffset + 5 > this.packetLength || n != 203) {
            return;
        }
        ++this.packetOffset;
        long l = this.decodeInt();
        this.packetOffset += 4;
        this.setConnectionID(l);
    }

    public abstract void setConnectionID(long var1);

    public abstract long getConnectionID();

    final void parsePacketDataBegin(HeaderSetImpl headerSetImpl, int n) {
        this.packetOffset = n;
        headerSetImpl.packetType = this.buffer[0] & 0xFF;
        this.parseConnectionID();
        this.dataOffset = this.packetOffset;
    }

    final int parsePacketData(HeaderSetImpl headerSetImpl, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = this.packetOffset - this.dataOffset) > 0) {
                if (byArray == null) {
                    return 1;
                }
                if (n4 > n2) {
                    n4 = n2;
                }
                System.arraycopy(this.buffer, this.dataOffset, byArray, n, n4);
                n += n4;
                this.dataOffset += n4;
                n3 += n4;
                if ((n2 -= n4) != 0) continue;
                return n3;
            }
            if (this.packetOffset == this.packetLength) {
                return n3;
            }
            int n5 = this.buffer[this.packetOffset] & 0xFF;
            if (n5 == 72 || n5 == 73) {
                this.isEof = n5 == 73;
                this.dataOffset = this.packetOffset + 3;
                int n6 = this.decodeLength16(this.packetOffset + 1);
                if (this.packetOffset + n6 > this.packetLength) {
                    throw new IOException("protocol error");
                }
                this.packetOffset += n6;
                continue;
            }
            this.parseHeader(headerSetImpl);
            this.dataOffset = this.packetOffset;
        }
    }

    final void parseEnd() throws IOException {
        if (this.authFailed) {
            this.authFailed = false;
            this.onMissingAuthResponse();
        }
    }

    final int decodeLength16(int n) {
        return ((this.buffer[n] & 0xFF) << 8) + (this.buffer[n + 1] & 0xFF);
    }

    private final long decodeInt() {
        return (((long)this.buffer[this.packetOffset + 0] & 0xFFL) << 24) + (((long)this.buffer[this.packetOffset + 1] & 0xFFL) << 16) + (((long)this.buffer[this.packetOffset + 2] & 0xFFL) << 8) + ((long)this.buffer[this.packetOffset + 3] & 0xFFL);
    }

    private final Calendar decodeTime8601() throws IOException {
        int n = this.decodeLength16(this.packetOffset) - 3;
        this.packetOffset += 2;
        if (n < 15 || n > 16 || this.buffer[this.packetOffset + 8] != 84 || n == 16 && this.buffer[this.packetOffset + 15] != 90) {
            throw new IOException("corrupted time header");
        }
        for (int i = 0; i < 14; ++i) {
            int n2;
            if (i == 8 || (n2 = this.buffer[this.packetOffset + i] - 48) >= 0 && n2 <= 9) continue;
            throw new IOException("corrupted time header");
        }
        int n3 = (this.buffer[this.packetOffset + 0] - 48) * 1000 + (this.buffer[this.packetOffset + 1] - 48) * 100 + (this.buffer[this.packetOffset + 2] - 48) * 10 + (this.buffer[this.packetOffset + 3] - 48);
        int n4 = (this.buffer[this.packetOffset + 4] - 48) * 10 + (this.buffer[this.packetOffset + 5] - 48);
        int n5 = (this.buffer[this.packetOffset + 6] - 48) * 10 + (this.buffer[this.packetOffset + 7] - 48);
        int n6 = (this.buffer[this.packetOffset + 9] - 48) * 10 + (this.buffer[this.packetOffset + 10] - 48);
        int n7 = (this.buffer[this.packetOffset + 11] - 48) * 10 + (this.buffer[this.packetOffset + 12] - 48);
        int n8 = (this.buffer[this.packetOffset + 13] - 48) * 10 + (this.buffer[this.packetOffset + 14] - 48);
        Calendar calendar = n == 15 ? Calendar.getInstance(utcTimeZone) : Calendar.getInstance();
        calendar.set(1, n3);
        calendar.set(2, n4 - 1);
        calendar.set(5, n5);
        calendar.set(10, n6);
        calendar.set(12, n7);
        calendar.set(13, n8);
        this.packetOffset += n;
        return calendar;
    }

    static int validateStatus(int n) {
        switch (n) {
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 224: 
            case 225: {
                return n;
            }
        }
        return 208;
    }
}

