/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.ObexPacketStream;
import com.sun.kvem.jsr082.obex.SSLWrapper;
import com.sun.kvem.obex.Authenticator;
import com.sun.kvem.obex.PasswordAuthentication;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

class ObexAuth {
    private static final boolean DEBUG = false;
    private static byte[] column = new byte[]{58};
    String realm;
    boolean userID;
    boolean access;
    byte[] nonce;
    private static int counter = 0;
    private byte[] realm_array;
    private int challengeLength;
    private static byte[] privateKey = null;

    static ObexAuth createChallenge(String string, boolean bl, boolean bl2) {
        return new ObexAuth(string, null, bl, bl2);
    }

    private ObexAuth(String string, byte[] byArray, boolean bl, boolean bl2) {
        this.realm = string;
        this.nonce = byArray;
        this.userID = bl;
        this.access = bl2;
    }

    int prepareChallenge() {
        if (this.challengeLength != 0) {
            return this.challengeLength;
        }
        try {
            int n = 24;
            this.realm_array = null;
            if (this.realm != null) {
                this.realm_array = this.realm.getBytes("UTF-16BE");
                n += 3 + this.realm_array.length;
            }
            this.challengeLength = n;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 0;
        }
        return this.challengeLength;
    }

    int addChallenge(byte[] byArray, int n) throws IOException {
        int n2 = this.prepareChallenge();
        byArray[n] = 77;
        byArray[n + 1] = (byte)(n2 >> 8);
        byArray[n + 2] = (byte)(n2 & 0xFF);
        byArray[n + 3] = 0;
        byArray[n + 4] = 16;
        this.nonce = ObexAuth.makeNonce();
        System.arraycopy(this.nonce, 0, byArray, n + 5, 16);
        byArray[n + 21] = 1;
        byArray[n + 22] = 1;
        byArray[n + 23] = (byte)((this.userID ? 1 : 0) + (this.access ? 0 : 2));
        if (this.realm != null) {
            int n3 = this.realm_array.length;
            byArray[n + 24] = 2;
            byArray[n + 25] = (byte)(n3 + 1);
            byArray[n + 26] = -1;
            System.arraycopy(this.realm_array, 0, byArray, n + 27, n3);
        }
        return n2;
    }

    private static byte[] makeNonce() throws IOException {
        SSLWrapper sSLWrapper = new SSLWrapper();
        byte[] byArray = ObexAuth.createTimestamp();
        sSLWrapper.update(byArray, 0, byArray.length);
        sSLWrapper.update(column, 0, 1);
        byte[] byArray2 = ObexAuth.getPrivateKey();
        byte[] byArray3 = new byte[16];
        sSLWrapper.doFinal(byArray2, 0, byArray2.length, byArray3, 0);
        return byArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] createTimestamp() {
        long l = System.currentTimeMillis();
        byte[] byArray = new byte[9];
        byArray[0] = (byte)(l >> 56);
        byArray[1] = (byte)(l >> 48);
        byArray[2] = (byte)(l >> 40);
        byArray[3] = (byte)(l >> 32);
        byArray[4] = (byte)(l >> 24);
        byArray[5] = (byte)(l >> 16);
        byArray[6] = (byte)(l >> 8);
        byArray[7] = (byte)l;
        Class clazz = ObexAuth.class;
        synchronized (clazz) {
            byArray[8] = (byte)counter++;
        }
        return byArray;
    }

    private static synchronized byte[] getPrivateKey() throws IOException {
        if (privateKey != null) {
            return privateKey;
        }
        SSLWrapper sSLWrapper = new SSLWrapper();
        byte[] byArray = null;
        try {
            byArray = "timestamp = ".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        sSLWrapper.update(byArray, 0, byArray.length);
        byte[] byArray2 = ObexAuth.createTimestamp();
        privateKey = new byte[16];
        sSLWrapper.doFinal(byArray2, 0, byArray2.length, privateKey, 0);
        return privateKey;
    }

    static void makeDigest(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) throws IOException {
        SSLWrapper sSLWrapper = new SSLWrapper();
        sSLWrapper.update(byArray2, 0, 16);
        sSLWrapper.update(column, 0, 1);
        sSLWrapper.doFinal(byArray3, 0, byArray3.length, byArray, n);
    }

    static ObexAuth parseAuthChallenge(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray2 = null;
        String string = null;
        n2 += n;
        block7: for (n3 = n + 3; n3 < n2; n3 += n4) {
            int n5 = byArray[n3] & 0xFF;
            n4 = byArray[n3 + 1] & 0xFF;
            n3 += 2;
            switch (n5) {
                case 0: {
                    if (n4 != 16 || byArray2 != null) {
                        throw new IOException("protocol error");
                    }
                    byArray2 = new byte[16];
                    System.arraycopy(byArray, n3, byArray2, 0, 16);
                    continue block7;
                }
                case 1: {
                    if (n4 != 1) {
                        throw new IOException("protocol error");
                    }
                    byte by = byArray[n3];
                    bl = (by & 2) != 0;
                    bl2 = (by & 1) != 0;
                    continue block7;
                }
                case 2: {
                    try {
                        int n6 = byArray[n3] & 0xFF;
                        String string2 = null;
                        if (n6 == 255) {
                            string2 = "UTF-16BE";
                        } else if (n6 == 0) {
                            string2 = "US-ASCII";
                        } else if (n6 < 10) {
                            string2 = "ISO-8859-" + string2;
                        } else {
                            throw new UnsupportedEncodingException();
                        }
                        string = new String(byArray, 1, n4 - 1, string2);
                        continue block7;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
        }
        if (n3 != n2) {
            throw new IOException("protocol error");
        }
        return new ObexAuth(string, byArray2, bl2, !bl);
    }

    int replyAuthChallenge(byte[] byArray, int n, Authenticator authenticator) throws IOException {
        if (this.realm == null) {
            this.realm = "";
        }
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            PasswordAuthentication passwordAuthentication = authenticator.onAuthenticationChallenge(this.realm, this.userID, this.access);
            byArray2 = passwordAuthentication.getPassword();
            int n2 = 0;
            byArray3 = passwordAuthentication.getUserName();
            if (this.userID || byArray3 != null) {
                if (this.userID && byArray3.length == 0) {
                    throw new Exception();
                }
                n2 = 2 + byArray3.length;
                if (n2 > 22) {
                    n2 = 22;
                }
            }
            int n3 = 39 + n2;
            byArray[n + 0] = 78;
            byArray[n + 1] = (byte)(n3 >> 8);
            byArray[n + 2] = (byte)(n3 & 0xFF);
            byArray[n + 3] = 0;
            byArray[n + 4] = 16;
            ObexAuth.makeDigest(byArray, n + 5, this.nonce, byArray2);
            byArray[n + 21] = 2;
            byArray[n + 22] = 16;
            System.arraycopy(this.nonce, 0, byArray, n + 23, 16);
            if (n2 > 2) {
                byArray[n + 39] = 1;
                byArray[n + 40] = (byte)(n2 - 2);
                System.arraycopy(byArray3, 0, byArray, n + 41, n2 - 2);
            }
            return n3;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private static void print(String string, byte[] byArray) {
    }

    private static boolean compare(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < 16; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    static boolean checkAuthResponse(byte[] byArray, int n, int n2, ObexPacketStream obexPacketStream, Vector vector) throws IOException {
        Object object;
        int n3;
        int n4;
        n2 += n;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        block7: for (n3 = n + 3; n3 < n2; n3 += n4) {
            int n5 = byArray[n3] & 0xFF;
            n4 = byArray[n3 + 1] & 0xFF;
            n3 += 2;
            switch (n5) {
                case 0: {
                    if (n4 != 16 || byArray2 != null) {
                        throw new IOException("protocol error (1)");
                    }
                    byArray2 = new byte[16];
                    System.arraycopy(byArray, n3, byArray2, 0, 16);
                    continue block7;
                }
                case 1: {
                    if (n4 > 20 || n4 == 0 || byArray3 != null) {
                        throw new IOException("protocol error (2)");
                    }
                    byArray3 = new byte[n4];
                    System.arraycopy(byArray, n3, byArray3, 0, n4);
                    continue block7;
                }
                case 2: {
                    if (n4 != 16 || byArray4 != null) {
                        throw new IOException("protocol error (3)");
                    }
                    byArray4 = new byte[16];
                    System.arraycopy(byArray, n3, byArray4, 0, 16);
                    continue block7;
                }
            }
        }
        if (n3 != n2) {
            throw new IOException("protocol error (4)");
        }
        ObexAuth obexAuth = null;
        if (byArray4 == null) {
            if (vector.size() == 0) {
                return false;
            }
            obexAuth = (ObexAuth)vector.elementAt(0);
            byArray4 = obexAuth.nonce;
            vector.removeElementAt(0);
        } else {
            for (n4 = 0; n4 < vector.size(); ++n4) {
                object = (ObexAuth)vector.elementAt(n4);
                if (!ObexAuth.compare(byArray4, ((ObexAuth)object).nonce)) continue;
                obexAuth = object;
                vector.removeElementAt(n4);
                break;
            }
            if (obexAuth == null) {
                return false;
            }
        }
        if (obexAuth.userID && byArray3 == null) {
            obexPacketStream.onAuthenticationFailure(byArray3);
            return false;
        }
        try {
            byte[] byArray5 = obexPacketStream.authenticator.onAuthenticationResponse(byArray3);
            object = new byte[16];
            ObexAuth.makeDigest((byte[])object, 0, byArray4, byArray5);
            boolean bl = ObexAuth.compare((byte[])object, byArray2);
            if (!bl) {
                obexPacketStream.onAuthenticationFailure(byArray3);
            }
            return bl;
        }
        catch (Throwable throwable) {
            obexPacketStream.onAuthenticationFailure(byArray3);
            return false;
        }
    }
}

