/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.ObexAuth;
import com.sun.kvem.obex.HeaderSet;
import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HeaderSetImpl
implements HeaderSet {
    private static final boolean DEBUG = false;
    public static final int OWNER_SERVER = 1;
    public static final int OWNER_CLIENT = 2;
    public static final int OWNER_SERVER_USER = 3;
    public static final int OWNER_CLIENT_USER = 4;
    static final int TYPE_UNICODE = 0;
    static final int TYPE_BYTEARRAY = 1;
    static final int TYPE_BYTE = 2;
    static final int TYPE_LONG = 3;
    static final int TYPE_SPECIAL_TIME_4 = 4;
    static final int TYPE_SPECIAL_TIME_ISO = 5;
    static final int TYPE_SPECIAL_TYPE = 6;
    static final int TYPE_UNSUPPORTED = 7;
    static final int TYPE_AUTH_CHALLENGE = 8;
    static final int TYPE_AUTH_RESPONSE = 9;
    int owner;
    int packetType;
    private Hashtable headers;
    Vector challenges = new Vector();

    public HeaderSetImpl(int n) {
        this.owner = n;
        this.headers = new Hashtable(5);
    }

    void merge(HeaderSetImpl headerSetImpl) {
        int[] nArray = headerSetImpl.getHeaderList();
        if (nArray == null) {
            return;
        }
        block5: for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            Object object = headerSetImpl.getHeader(n);
            int n2 = HeaderSetImpl.internalType(n);
            switch (n2) {
                case 0: 
                case 2: 
                case 3: 
                case 6: {
                    this.setHeader(n, object);
                    continue block5;
                }
                case 1: {
                    byte[] byArray = (byte[])object;
                    byte[] byArray2 = new byte[byArray.length];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    this.setHeader(n, byArray2);
                    continue block5;
                }
                case 4: 
                case 5: {
                    Calendar calendar = (Calendar)object;
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTime(calendar.getTime());
                    this.setHeader(n, calendar2);
                    continue block5;
                }
            }
        }
    }

    HeaderSetImpl(HeaderSetImpl headerSetImpl) {
        this.packetType = headerSetImpl.packetType;
        this.owner = headerSetImpl.owner;
        this.headers = new Hashtable(5);
        this.merge(headerSetImpl);
    }

    boolean isSendable() {
        return this.owner >= 3;
    }

    public void createAuthenticationChallenge(String string, boolean bl, boolean bl2) {
        ObexAuth obexAuth = ObexAuth.createChallenge(string, bl, bl2);
        this.challenges.addElement(obexAuth);
    }

    public Object getHeader(int n) {
        Object v = this.headers.get(new Integer(n));
        if (v != null) {
            return v;
        }
        int n2 = HeaderSetImpl.internalType(n);
        if (n2 >= 7) {
            throw new IllegalArgumentException("bad header id");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getHeaderList() {
        Hashtable hashtable = this.headers;
        synchronized (hashtable) {
            if (this.headers.isEmpty()) {
                return null;
            }
            Enumeration enumeration = this.headers.keys();
            int[] nArray = new int[this.headers.size()];
            int n = 0;
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                nArray[n++] = (Integer)k;
            }
            return nArray;
        }
    }

    public int getResponseCode() throws IOException {
        if (this.owner != 2) {
            throw new IOException("invalid use");
        }
        if (this.packetType == 144) {
            throw new IOException("operation not finished");
        }
        return this.packetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(int n, Object object) {
        int n2 = HeaderSetImpl.internalType(n);
        String string = "incompatible header object";
        if (n2 >= 7) {
            throw new IllegalArgumentException("bad header id");
        }
        if (object == null) {
            Hashtable hashtable = this.headers;
            synchronized (hashtable) {
                this.headers.remove(new Integer(n));
            }
            return;
        }
        boolean bl = false;
        switch (n2) {
            case 0: {
                if (object instanceof String) break;
                bl = true;
                break;
            }
            case 1: {
                if (object instanceof byte[]) break;
                bl = true;
                break;
            }
            case 2: {
                if (object instanceof Byte) break;
                bl = true;
                break;
            }
            case 3: {
                if (!(object instanceof Long)) {
                    bl = true;
                    break;
                }
                long l = (Long)object;
                if (l >= 0L && l <= 0xFFFFFFFFL) break;
                string = "long value out of range 0 .. 0xFFFFFFFF";
                bl = true;
                break;
            }
            case 4: {
                if (object instanceof Calendar) break;
                bl = true;
                break;
            }
            case 5: {
                if (object instanceof Calendar) break;
                bl = true;
                break;
            }
            case 6: {
                if (object instanceof String) break;
                bl = true;
            }
        }
        if (bl) {
            throw new IllegalArgumentException(string);
        }
        Hashtable hashtable = this.headers;
        synchronized (hashtable) {
            this.headers.put(new Integer(n), object);
        }
    }

    static final int internalType(int n) {
        if ((n & 0xFFFFFF00) != 0) {
            return 7;
        }
        if ((n & 0x30) == 48) {
            return n >> 6;
        }
        switch (n) {
            case 68: {
                return 5;
            }
            case 196: {
                return 4;
            }
            case 66: {
                return 6;
            }
            case 192: 
            case 195: {
                return 3;
            }
            case 1: 
            case 5: {
                return 0;
            }
            case 70: 
            case 71: 
            case 74: 
            case 76: 
            case 79: {
                return 1;
            }
            case 77: {
                return 8;
            }
            case 78: {
                return 9;
            }
        }
        return 7;
    }
}

