/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.ClientOperation;
import com.sun.kvem.jsr082.obex.HeaderSetImpl;
import com.sun.kvem.jsr082.obex.ObexPacketStream;
import com.sun.kvem.jsr082.obex.ObexTransport;
import com.sun.kvem.obex.ClientSession;
import com.sun.kvem.obex.HeaderSet;
import com.sun.kvem.obex.Operation;
import java.io.IOException;

public class ClientSessionImpl
extends ObexPacketStream
implements ClientSession {
    private boolean busy;
    private Object lockObject = new Object();
    private int owner = 2;
    Operation operation = null;
    private long connId = -1L;

    public ClientSessionImpl(ObexTransport obexTransport) throws IOException {
        super(obexTransport);
        this.isClient = true;
    }

    public HeaderSet createHeaderSet() {
        return new HeaderSetImpl(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockCheckHeaders(HeaderSet headerSet) throws IOException {
        if (this.isClosed()) {
            throw new IOException("session closed");
        }
        if (this.operation != null) {
            throw new IOException("already in operation");
        }
        if (!(headerSet == null || headerSet instanceof HeaderSetImpl && ((HeaderSetImpl)headerSet).owner != this.owner)) {
            throw new IllegalArgumentException("wrong headerset class");
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.busy) {
                throw new IOException("already in operation");
            }
            this.busy = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() {
        Object object = this.lockObject;
        synchronized (object) {
            this.busy = false;
        }
    }

    void onAuthenticationFailure(byte[] byArray) throws IOException {
        if (this.operation != null) {
            this.operation.abort();
        }
        throw new IOException("server is not authenticated");
    }

    void onMissingAuthResponse() throws IOException {
        if (this.packetType != 193) {
            if (this.operation != null) {
                this.operation.abort();
            }
            throw new IOException("no auth response from server");
        }
    }

    public void setConnectionID(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid id");
        }
        this.connId = l;
    }

    public long getConnectionID() {
        return this.connId;
    }

    void headerTooLarge() throws IOException {
        throw new IOException("header too large");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderSet connect(HeaderSet headerSet) throws IOException {
        this.lockCheckHeaders(headerSet);
        try {
            if (this.isConnected) {
                throw new IOException("already connected");
            }
            byte[] byArray = new byte[]{-128, 0, 0, 16, 0, (byte)(this.OBEX_MAXIMUM_PACKET_LENGTH / 256), (byte)(this.OBEX_MAXIMUM_PACKET_LENGTH % 256)};
            this.sendPacket(byArray, -1L, (HeaderSetImpl)headerSet, true);
            this.recvPacket();
            if (this.packetLength < 7 || this.buffer[3] != 16) {
                throw new IOException("unsupported server obex version");
            }
            HeaderSetImpl headerSetImpl = new HeaderSetImpl(this.owner);
            this.parsePacketHeaders(headerSetImpl, 7);
            if (this.shouldSendAuthResponse()) {
                this.authFailed = false;
                this.sendPacket(byArray, -1L, (HeaderSetImpl)headerSet, true);
                this.recvPacket();
                if (this.packetLength < 7 || this.buffer[3] != 16) {
                    throw new IOException("unsupported server obex version");
                }
                headerSetImpl = new HeaderSetImpl(this.owner);
                this.parsePacketHeaders(headerSetImpl, 7);
            }
            this.maxSendLength = this.decodeLength16(5);
            if (this.maxSendLength > this.OBEX_MAXIMUM_PACKET_LENGTH) {
                this.maxSendLength = this.OBEX_MAXIMUM_PACKET_LENGTH;
            }
            if (this.packetType == 160) {
                if (this.authFailed) {
                    throw new IOException("server is not authenticated");
                }
                this.isConnected = true;
            }
            HeaderSetImpl headerSetImpl2 = headerSetImpl;
            return headerSetImpl2;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderSet disconnect(HeaderSet headerSet) throws IOException {
        this.lockCheckHeaders(headerSet);
        try {
            if (!this.isConnected) {
                throw new IOException("not connected");
            }
            this.sendPacket(PACKET_DISCONNECT, this.connId, (HeaderSetImpl)headerSet, true);
            this.recvPacket();
            HeaderSetImpl headerSetImpl = new HeaderSetImpl(this.owner);
            this.parsePacketHeaders(headerSetImpl, 3);
            if (this.packetType == 160) {
                this.isConnected = false;
            }
            HeaderSetImpl headerSetImpl2 = headerSetImpl;
            return headerSetImpl2;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation put(HeaderSet headerSet) throws IOException {
        this.lockCheckHeaders(headerSet);
        try {
            if (!this.isConnected) {
                throw new IOException("not connected");
            }
            new ClientOperation(this, (HeaderSetImpl)headerSet, false);
            Operation operation = this.operation;
            return operation;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation get(HeaderSet headerSet) throws IOException {
        this.lockCheckHeaders(headerSet);
        try {
            if (!this.isConnected) {
                throw new IOException("not connected");
            }
            new ClientOperation(this, (HeaderSetImpl)headerSet, true);
            Operation operation = this.operation;
            return operation;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderSet setPath(HeaderSet headerSet, boolean bl, boolean bl2) throws IOException {
        this.lockCheckHeaders(headerSet);
        try {
            if (!this.isConnected) {
                throw new IOException("not connected");
            }
            byte[] byArray = new byte[]{-123, 0, 0, (byte)((bl ? 1 : 0) + (bl2 ? 0 : 2)), 0};
            this.sendPacket(byArray, this.connId, (HeaderSetImpl)headerSet, true);
            this.recvPacket();
            HeaderSetImpl headerSetImpl = new HeaderSetImpl(this.owner);
            this.parsePacketHeaders(headerSetImpl, 3);
            HeaderSetImpl headerSetImpl2 = headerSetImpl;
            return headerSetImpl2;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderSet delete(HeaderSet headerSet) throws IOException {
        this.lockCheckHeaders(headerSet);
        try {
            if (!this.isConnected) {
                throw new IOException("not connected");
            }
            ClientOperation clientOperation = new ClientOperation(this, (HeaderSetImpl)headerSet, false);
            int n = clientOperation.getResponseCode();
            HeaderSet headerSet2 = clientOperation.getReceivedHeaders();
            clientOperation.close();
            HeaderSet headerSet3 = headerSet2;
            return headerSet3;
        }
        finally {
            this.unlock();
        }
    }
}

