/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.ClientSessionImpl;
import com.sun.kvem.jsr082.obex.HeaderSetImpl;
import com.sun.kvem.obex.HeaderSet;
import com.sun.kvem.obex.Operation;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class ClientOperation
implements Operation {
    private static final boolean DEBUG = false;
    private ClientSessionImpl stream;
    private HeaderSetImpl recvHeaders;
    private HeaderSetImpl sentHeaders;
    private byte[] head;
    private Object lock = new Object();
    private boolean inputStreamOpened;
    private boolean inputStreamClosed;
    private boolean outputStreamOpened;
    private boolean outputStreamClosed;
    private boolean inputStreamEof;
    private boolean firstDataBlock = true;
    private int openObjects = 1;
    private OperationInputStream is;
    private OperationOutputStream os;
    private boolean isGet;
    private boolean requestEnd;
    private boolean operationEnd;
    private boolean operationClosed;
    private boolean restartable = true;
    private boolean restarting;
    private boolean streamClosing;

    ClientOperation(ClientSessionImpl clientSessionImpl, HeaderSetImpl headerSetImpl, boolean bl) throws IOException {
        this.isGet = bl;
        this.head = new byte[]{bl ? (byte)3 : 2, 0, 0};
        clientSessionImpl.operation = this;
        clientSessionImpl.isEof = false;
        this.stream = clientSessionImpl;
        this.sentHeaders = headerSetImpl == null ? new HeaderSetImpl(2) : headerSetImpl;
        this.recvHeaders = new HeaderSetImpl(2);
        this.is = new OperationInputStream();
        this.os = new OperationOutputStream();
        clientSessionImpl.packetBegin(this.head);
        if (headerSetImpl == null || headerSetImpl.getHeader(70) == null) {
            clientSessionImpl.packetAddConnectionID(clientSessionImpl.getConnectionID(), headerSetImpl);
        }
        clientSessionImpl.packetAddAuthResponses();
        clientSessionImpl.packetAddHeaders(headerSetImpl);
        while (clientSessionImpl.challengesToSend || !clientSessionImpl.queuedHeaders.isEmpty()) {
            if (this.packetExchange()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean packetExchange() throws IOException {
        if (this.operationEnd) {
            return this.requestEnd && this.stream.shouldSendAuthResponse() && this.restartOperation();
        }
        if (!this.requestEnd) {
            this.stream.packetEndStripConnID();
            this.stream.recvPacket();
            this.operationEnd = this.stream.packetType != 144;
            HeaderSetImpl headerSetImpl = this.recvHeaders;
            synchronized (headerSetImpl) {
                this.stream.parsePacketHeaders(this.recvHeaders, 3);
            }
            if (this.operationEnd) {
                if (this.stream.shouldSendAuthResponse() && this.restartOperation()) {
                    return true;
                }
                this.requestEnd = true;
                this.operationEnd = true;
                return false;
            }
            this.stream.packetBegin(this.head);
            this.stream.packetAddAuthResponses();
            this.stream.packetAddHeaders(null);
            return true;
        }
        this.stream.parseEnd();
        this.stream.sendPacket(this.head, -1L, null, false);
        this.stream.recvPacket();
        this.operationEnd = this.stream.packetType != 144;
        this.stream.parsePacketDataBegin(this.recvHeaders, 3);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestEnd() throws IOException {
        int n;
        boolean bl;
        Object object = this.lock;
        synchronized (object) {
            if (this.requestEnd) {
                return;
            }
            this.requestEnd = true;
        }
        this.head[0] = (byte)(this.head[0] | 0x80);
        if (this.operationEnd) {
            return;
        }
        if (this.outputStreamOpened && !(bl = this.stream.packetEOFBody())) {
            if (!this.packetExchange()) {
                return;
            }
            this.stream.packetEOFBody();
        }
        this.stream.packetMarkFinal();
        this.stream.packetEndStripConnID();
        this.stream.recvPacket();
        boolean bl2 = this.operationEnd = this.stream.packetType != 144;
        if (!this.isGet) {
            this.stream.parsePacketHeaders(this.recvHeaders, 3);
            return;
        }
        this.stream.parsePacketDataBegin(this.recvHeaders, 3);
        while ((n = this.stream.parsePacketData(this.recvHeaders, null, 0, 0)) != 1 && !this.stream.isEof) {
            if (this.stream.shouldSendAuthResponse() && this.restartOperation()) {
                return;
            }
            if (this.packetExchange()) continue;
            return;
        }
    }

    private void notRestartable() {
        this.restartable = false;
        this.sentHeaders = null;
    }

    private boolean restartOperation() throws IOException {
        if (!this.restartable) {
            return false;
        }
        HeaderSetImpl headerSetImpl = this.sentHeaders;
        this.notRestartable();
        this.operationEnd = false;
        boolean bl = this.requestEnd;
        this.requestEnd = false;
        this.head[0] = this.isGet ? 3 : 2;
        this.recvHeaders = new HeaderSetImpl(2);
        this.stream.queuedHeaders.removeAllElements();
        this.stream.isEof = false;
        this.stream.packetBegin(this.head);
        this.stream.packetAddConnectionID(this.stream.getConnectionID(), headerSetImpl);
        this.stream.packetAddAuthResponses();
        this.stream.packetAddHeaders(headerSetImpl);
        while (!this.stream.queuedHeaders.isEmpty()) {
            if (this.packetExchange()) continue;
            return true;
        }
        if (bl) {
            this.requestEnd();
        }
        this.restarting = true;
        return true;
    }

    private void sendAbortPacket() throws IOException {
        if (this.operationEnd) {
            return;
        }
        this.inputStreamClosed = true;
        this.outputStreamClosed = true;
        this.operationEnd = true;
        this.requestEnd = true;
        this.stream.queuedHeaders.removeAllElements();
        this.stream.sendPacket(ClientSessionImpl.PACKET_ABORT, -1L, null, true);
        this.stream.recvPacket();
        this.stream.parsePacketHeaders(this.recvHeaders, 3);
        if (this.stream.packetType != 160) {
            this.stream.brokenLink();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() throws IOException {
        this.streamClosing = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.operationClosed) {
                throw new IOException("operation closed");
            }
            try {
                if (this.operationEnd) {
                    throw new IOException("operation already finished");
                }
                this.sendAbortPacket();
                Object var3_2 = null;
                this.operationClosed = true;
                this.openObjects = 0;
                this.stream.operation = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.operationClosed = true;
                this.openObjects = 0;
                this.stream.operation = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderSet getReceivedHeaders() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.operationClosed) {
                throw new IOException("operation closed");
            }
            HeaderSetImpl headerSetImpl = new HeaderSetImpl(this.recvHeaders);
            headerSetImpl.packetType = ClientSessionImpl.validateStatus(headerSetImpl.packetType);
            return headerSetImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResponseCode() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.operationClosed) {
                throw new IOException("operation closed");
            }
            this.requestEnd();
            this.sendAbortPacket();
            return ClientSessionImpl.validateStatus(this.recvHeaders.packetType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeaders(HeaderSet headerSet) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.operationClosed) {
                throw new IOException("operation closed");
            }
            if (headerSet == null) {
                throw new NullPointerException("null headerset");
            }
            if (!(headerSet instanceof HeaderSetImpl)) {
                throw new IllegalArgumentException("wrong headerset class");
            }
            HeaderSetImpl headerSetImpl = (HeaderSetImpl)headerSet;
            if (!headerSetImpl.isSendable()) {
                throw new IllegalArgumentException("not created with createHeaderSet");
            }
            if (this.operationEnd) {
                throw new IOException("operation finished");
            }
            if (this.restartable) {
                this.sentHeaders.merge(headerSetImpl);
            }
            this.stream.packetAddHeaders(headerSetImpl);
            if (this.requestEnd) {
                return;
            }
            if (!this.stream.queuedHeaders.isEmpty() && !this.packetExchange()) {
                throw new IOException("server finished operation, not all headers sent");
            }
        }
    }

    public String getEncoding() {
        return null;
    }

    public long getLength() {
        Long l = (Long)this.recvHeaders.getHeader(195);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public String getType() {
        return (String)this.recvHeaders.getHeader(66);
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream openOutputStream() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.operationClosed) {
                throw new IOException("operation closed");
            }
            if (this.outputStreamOpened) {
                throw new IOException("no more output streams available");
            }
            if (this.requestEnd) {
                throw new IOException("too late to open output stream");
            }
            this.outputStreamOpened = true;
            ++this.openObjects;
            return this.os;
        }
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.operationClosed) {
                throw new IOException("operation closed");
            }
            if (this.inputStreamOpened) {
                throw new IOException("no more input streams available");
            }
            this.inputStreamOpened = true;
            ++this.openObjects;
            if (!this.isGet) {
                return new FakeInputStream();
            }
            this.requestEnd();
            return this.is;
        }
    }

    private void terminate() throws IOException {
        --this.openObjects;
        if (this.openObjects != 0) {
            return;
        }
        this.sendAbortPacket();
        this.stream.operation = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.operationClosed) {
                this.operationClosed = true;
                this.terminate();
            }
        }
    }

    private class FakeInputStream
    extends InputStream {
        FakeInputStream() {
        }

        public int read() throws IOException {
            throw new IOException("not supported");
        }

        public void close() throws IOException {
        }
    }

    private class OperationInputStream
    extends InputStream {
        OperationInputStream() {
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n == -1) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            Object object = ClientOperation.this.lock;
            synchronized (object) {
                if (ClientOperation.this.inputStreamClosed) {
                    throw new IOException("stream closed");
                }
                if (n2 < 0 || n < 0 || n + n2 > byArray.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                if (n2 == 0) {
                    return 0;
                }
                if (ClientOperation.this.inputStreamEof) {
                    ClientOperation.this.notRestartable();
                    return -1;
                }
                int n3 = 0;
                while (true) {
                    if (ClientOperation.this.streamClosing) {
                        throw new IOException("operation aborted");
                    }
                    int n4 = ClientOperation.this.stream.parsePacketData(ClientOperation.this.recvHeaders, byArray, n, n2);
                    if (n4 != 0) {
                        n += n4;
                        n3 += n4;
                        if ((n2 -= n4) == 0) {
                            ClientOperation.this.notRestartable();
                            return n3;
                        }
                    }
                    if (((ClientOperation)ClientOperation.this).stream.isEof) {
                        while (!ClientOperation.this.operationEnd) {
                            ClientOperation.this.stream.parseEnd();
                            ClientOperation.this.stream.sendPacket(ClientOperation.this.head, -1L, null, false);
                            ClientOperation.this.stream.recvPacket();
                            ClientOperation.this.operationEnd = ((ClientOperation)ClientOperation.this).stream.packetType != 144;
                            ClientOperation.this.stream.parsePacketHeaders(ClientOperation.this.recvHeaders, 3);
                        }
                        ClientOperation.this.inputStreamEof = true;
                        ClientOperation.this.notRestartable();
                        return n3 == 0 ? -1 : n3;
                    }
                    if (((ClientOperation)ClientOperation.this).stream.packetType != 144) {
                        throw new IOException("server errorcode received");
                    }
                    ClientOperation.this.packetExchange();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = ClientOperation.this.lock;
            synchronized (object) {
                if (ClientOperation.this.inputStreamClosed) {
                    return;
                }
                ClientOperation.this.inputStreamEof = false;
                try {
                    ClientOperation.this.sendAbortPacket();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ClientOperation.this.inputStreamClosed = true;
                ClientOperation.this.terminate();
            }
        }
    }

    private class OperationOutputStream
    extends OutputStream {
        OperationOutputStream() {
        }

        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n}, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3 = n;
            int n4 = n2;
            boolean bl = true;
            Object object = ClientOperation.this.lock;
            synchronized (object) {
                if (ClientOperation.this.outputStreamClosed || ClientOperation.this.requestEnd) {
                    throw new IOException("stream closed");
                }
                if (n2 < 0 || n < 0 || n + n2 > byArray.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                while (n2 > 0) {
                    if (ClientOperation.this.streamClosing) {
                        throw new IOException("operation aborted");
                    }
                    int n5 = ClientOperation.this.stream.packetAddData(byArray, n, n2);
                    if (n5 != n2 || ClientOperation.this.firstDataBlock && bl) {
                        bl = false;
                        ClientOperation.this.restarting = false;
                        if (!ClientOperation.this.packetExchange()) {
                            throw new IOException("server rejected the data");
                        }
                        if (ClientOperation.this.restarting) {
                            n2 = n4;
                            n = n3;
                        }
                    }
                    n2 -= n5;
                    n += n5;
                }
            }
            ClientOperation.this.firstDataBlock = false;
            ClientOperation.this.notRestartable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            Object object = ClientOperation.this.lock;
            synchronized (object) {
                if (ClientOperation.this.outputStreamClosed || ClientOperation.this.requestEnd) {
                    throw new IOException("stream closed");
                }
                if (((ClientOperation)ClientOperation.this).stream.packetLength != 3) {
                    ClientOperation.this.packetExchange();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = ClientOperation.this.lock;
            synchronized (object) {
                if (!ClientOperation.this.outputStreamClosed) {
                    ClientOperation.this.outputStreamClosed = true;
                    ClientOperation.this.requestEnd();
                    ClientOperation.this.terminate();
                }
            }
        }
    }
}

