/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.io;

import com.sun.kvem.jsr082.impl.io.JSR082TCPWrapper;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public final class JSR082Connection {
    private static final boolean DEBUG = false;
    private static final String cn = "JSR082Connection";
    private boolean isClosed = false;
    private InputStream in;
    private OutputStream out;
    private Object tcpSocket;

    public JSR082Connection(SecurityToken securityToken, int n) throws IOException {
        Object[] objectArray = JSR082TCPWrapper.getSocketStreams(securityToken, n);
        this.in = (InputStream)objectArray[0];
        this.out = (OutputStream)objectArray[1];
        this.tcpSocket = objectArray[2];
    }

    JSR082Connection(Object[] objectArray) {
        this.in = (InputStream)objectArray[0];
        this.out = (OutputStream)objectArray[1];
        this.tcpSocket = objectArray[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Serializable serializable = JSR082Connection.class;
        synchronized (serializable) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        serializable = null;
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            serializable = iOException;
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            serializable = iOException;
        }
        JSR082TCPWrapper.closeConnection(this.tcpSocket);
        if (serializable != null) {
            throw serializable;
        }
    }

    public int read(byte[] byArray) throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        return this.in.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        return this.in.read(byArray, n, n2);
    }

    public void write(byte[] byArray) throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        this.out.write(byArray, 0, byArray.length);
        this.out.flush();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        this.out.write(byArray, n, n2);
        this.out.flush();
    }

    public int ready() throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        return this.in.available();
    }
}

