/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.bluetooth.BluetoothStateException;
import com.sun.kvem.bluetooth.LocalDevice;
import com.sun.kvem.jsr082.bluetooth.BluetoothConnection;
import com.sun.kvem.jsr082.bluetooth.RemoteDeviceImpl;
import com.sun.kvem.jsr082.impl.bluetooth.BluetoothController;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityListener;
import java.io.IOException;
import java.util.Hashtable;

class SecurityState {
    private static final boolean DEBUG = false;
    private int lock;
    private int waitingRequests;
    private RemoteDeviceImpl remoteDevice;
    private int encryptedConn;
    private int numConn;
    private boolean isAuthenticated;
    private boolean isEncrypted;
    private boolean forceMaster;
    private boolean master;
    private static Hashtable table = new Hashtable();
    private static final int STATE_IDLE = 0;
    private static final int STATE_REQUEST = 1;
    private static final int STATE_REQUEST_FAILED = 2;
    private BluetoothController control;

    SecurityState(RemoteDeviceImpl remoteDeviceImpl) {
        String string;
        try {
            string = LocalDevice.getLocalDevice().getBluetoothAddress();
        }
        catch (BluetoothStateException bluetoothStateException) {
            string = "";
        }
        String string2 = remoteDeviceImpl.getBluetoothAddress();
        this.master = string.compareTo(string2) > 0;
        this.remoteDevice = remoteDeviceImpl;
        this.control = BluetoothController.getInstance();
    }

    public static synchronized SecurityState getSecurityState(RemoteDeviceImpl remoteDeviceImpl) {
        SecurityState securityState = (SecurityState)table.get(remoteDeviceImpl);
        if (securityState == null) {
            securityState = new SecurityState(remoteDeviceImpl);
            table.put(remoteDeviceImpl, securityState);
        }
        return securityState;
    }

    public void addConnection(BluetoothConnection bluetoothConnection) {
        ++this.numConn;
    }

    public void removeConnection(BluetoothConnection bluetoothConnection) {
        --this.numConn;
    }

    private synchronized void startRequest() {
        SecurityState.msg("startRequest()");
        ++this.waitingRequests;
        while (this.lock != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.lock = 1;
        --this.waitingRequests;
        SecurityState.msg("startRequest(): started");
    }

    private synchronized boolean resetRequest() {
        SecurityState.msg("resetRequest()");
        if (this.master) {
            if (this.lock == 0) {
                SecurityState.msg("resetRequest(): true");
                return true;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SecurityState.msg("resetRequest(): false");
            return false;
        }
        if (this.lock == 1) {
            this.lock = 2;
            this.notifyAll();
        }
        SecurityState.msg("resetRequest(): true");
        return true;
    }

    private synchronized boolean endRequest() {
        SecurityState.msg("endRequest()");
        if (this.lock == 2) {
            this.lock = 0;
            SecurityState.msg("endRequest(): false");
            return false;
        }
        this.lock = 0;
        this.notifyAll();
        SecurityState.msg("endRequest(): true");
        return true;
    }

    synchronized void waitSecurityExchange() {
        while (this.lock != 0 && this.waitingRequests == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        SecurityState.msg("waitSecurityExchange(): done");
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate() throws IOException {
        while (true) {
            boolean bl;
            if (this.numConn == 0) {
                throw new IOException("no active connections to the device");
            }
            SecurityState securityState = this;
            synchronized (securityState) {
                this.startRequest();
                bl = this.isAuthenticated;
            }
            if (bl) {
                this.endRequest();
                return true;
            }
            try {
                bl = SecurityListener.sendCommand(this.remoteDevice, 2, true);
            }
            catch (BluetoothStateException bluetoothStateException) {
                this.endRequest();
                continue;
            }
            catch (IOException iOException) {
                this.endRequest();
                throw iOException;
            }
            securityState = this;
            synchronized (securityState) {
                if (this.endRequest()) {
                    this.isAuthenticated = bl;
                    return this.isAuthenticated;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean encrypt(BluetoothConnection bluetoothConnection, boolean bl) throws IOException {
        if (this.control.forceNoEncrypt) {
            return !bl;
        }
        if (bl && !this.authenticate()) {
            return false;
        }
        while (true) {
            int n;
            boolean bl2;
            SecurityState securityState = this;
            synchronized (securityState) {
                this.startRequest();
                bl2 = this.isEncrypted;
                n = this.encryptedConn;
            }
            if (bluetoothConnection.isEncrypted() == bl) {
                this.endRequest();
                return true;
            }
            bluetoothConnection.setEncrypted(bl);
            n = bl ? ++n : --n;
            if (bl2 == (n != 0)) {
                securityState = this;
                synchronized (securityState) {
                    if (this.endRequest()) {
                        this.encryptedConn = n;
                        return true;
                    }
                    bluetoothConnection.setEncrypted(!bl);
                }
            }
            try {
                bl2 = SecurityListener.sendCommand(this.remoteDevice, 1, bl);
            }
            catch (BluetoothStateException bluetoothStateException) {
                bluetoothConnection.setEncrypted(!bl);
                this.endRequest();
                continue;
            }
            catch (IOException iOException) {
                bluetoothConnection.setEncrypted(!bl);
                this.endRequest();
                throw iOException;
            }
            if (bl2 == bl) {
                securityState = this;
                synchronized (securityState) {
                    if (this.endRequest()) {
                        this.encryptedConn = n;
                        this.isEncrypted = bl2;
                        return true;
                    }
                    bluetoothConnection.setEncrypted(!bl);
                }
            }
            securityState = this;
            synchronized (securityState) {
                if (this.endRequest()) {
                    if (bl) {
                        bluetoothConnection.setEncrypted(false);
                    } else {
                        this.encryptedConn = n;
                    }
                    return false;
                }
                bluetoothConnection.setEncrypted(!bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestMaster() throws IOException {
        while (true) {
            boolean bl;
            SecurityState securityState = this;
            synchronized (securityState) {
                this.startRequest();
                bl = this.forceMaster;
            }
            if (bl) {
                this.endRequest();
                return true;
            }
            try {
                bl = SecurityListener.sendCommand(this.remoteDevice, 3, true);
            }
            catch (BluetoothStateException bluetoothStateException) {
                this.endRequest();
                continue;
            }
            catch (IOException iOException) {
                this.endRequest();
                throw iOException;
            }
            securityState = this;
            synchronized (securityState) {
                if (this.endRequest()) {
                    this.forceMaster = bl;
                    return bl;
                }
            }
        }
    }

    synchronized boolean remoteRequestForEncrypt(boolean bl) throws BluetoothStateException {
        if (this.resetRequest()) {
            this.isEncrypted = !this.control.forceNoEncrypt && (bl || this.control.forceEncrypt || this.encryptedConn != 0);
            return this.isEncrypted;
        }
        throw new BluetoothStateException("request ignored");
    }

    synchronized boolean remoteRequestForAuthenticate(byte[] byArray) throws BluetoothStateException {
        if (this.resetRequest()) {
            if (this.isAuthenticated) {
                return true;
            }
            byte[] byArray2 = this.control.getDevicePinCode();
            if (byArray2.length != byArray.length) {
                return false;
            }
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] == byArray[i]) continue;
                return false;
            }
            this.isAuthenticated = true;
            return true;
        }
        throw new BluetoothStateException("request ignored");
    }

    synchronized boolean remoteRequestForMaster() throws BluetoothStateException {
        if (this.resetRequest()) {
            return !this.forceMaster;
        }
        throw new BluetoothStateException("request ignored");
    }

    private static final void msg(String string) {
    }
}

