/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.bluetooth.BluetoothStateException;
import com.sun.kvem.jsr082.bluetooth.DiscoveryAgentImpl;
import com.sun.kvem.jsr082.bluetooth.RemoteDeviceImpl;
import com.sun.kvem.jsr082.impl.bluetooth.BluetoothController;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityState;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityTokenHandler;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import com.sun.kvem.jsr082.impl.io.JSR082Notifier;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

class SecurityListener
implements Runnable {
    private static final boolean DEBUG = false;
    private static boolean running = true;
    private static JSR082Notifier notif;
    private static JSR082Connection conn;
    private static BluetoothController control;
    static final int ENCRYPT = 1;
    static final int AUTHENTICATE = 2;
    static final int FORCE_MASTER = 3;
    static final int ERROR = 4;

    private SecurityListener() {
    }

    static void start(BluetoothController bluetoothController) throws IOException {
        try {
            notif = new JSR082Notifier(SecurityTokenHandler.getSecurityToken());
            control = bluetoothController;
            bluetoothController.registerSecurityListener(notif.getServerPort());
        }
        catch (IOException iOException) {
            System.err.println("SecurityListener not created");
            try {
                if (notif != null) {
                    notif.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        new Thread(new SecurityListener()).start();
    }

    private static void stop() {
        running = false;
        try {
            notif.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            conn.close();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void run() {
        while (running) {
            try {
                conn = notif.acceptAndOpen();
                this.processRequest();
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void processRequest() throws IOException {
        String string = SecurityListener.readBTAddress(conn);
        DiscoveryAgentImpl discoveryAgentImpl = control.getDiscoveryAgent();
        RemoteDeviceImpl remoteDeviceImpl = discoveryAgentImpl.getRemoteDevice(string);
        byte[] byArray = new byte[2];
        boolean bl = false;
        if (conn.read(byArray) != 2) {
            throw new IOException("internal error");
        }
        boolean bl2 = byArray[1] != 0;
        byte[] byArray2 = new byte[1];
        try {
            switch (byArray[0]) {
                case 1: {
                    bl = this.processCmdEncrypt(remoteDeviceImpl, bl2);
                    break;
                }
                case 2: {
                    bl = this.processCmdAuthenticate(remoteDeviceImpl);
                    break;
                }
                case 3: {
                    bl = this.processCmdForceMaster(remoteDeviceImpl);
                    break;
                }
                default: {
                    System.err.println("SecurityListener.processRequest(): unknown request " + byArray[0]);
                }
            }
            byArray2[0] = (byte)(bl ? 1 : 0);
        }
        catch (BluetoothStateException bluetoothStateException) {
            byArray2[0] = 4;
        }
        conn.write(byArray2);
    }

    static JSR082Connection createSecurityConnection(RemoteDeviceImpl remoteDeviceImpl) throws IOException {
        int n = control.getSecurityListenerPort(remoteDeviceImpl.getBluetoothAddress());
        JSR082Connection jSR082Connection = new JSR082Connection(SecurityTokenHandler.getSecurityToken(), n);
        SecurityListener.writeBTAddress(jSR082Connection, control.getBluetoothAddress());
        return jSR082Connection;
    }

    static boolean sendCommand(RemoteDeviceImpl remoteDeviceImpl, int n, boolean bl) throws IOException {
        byte[] byArray;
        byte[] byArray2;
        JSR082Connection jSR082Connection = SecurityListener.createSecurityConnection(remoteDeviceImpl);
        if (n == 2) {
            byArray2 = control.getDevicePinCode();
            if (byArray2 == null) {
                byArray2 = new byte[]{};
            }
            byArray = new byte[6 + byArray2.length];
            byArray[0] = (byte)n;
            byArray[1] = (byte)(bl ? 1 : 0);
            byArray[2] = (byte)(byArray2.length >>> 24);
            byArray[3] = (byte)(byArray2.length >>> 16 & 0xFF);
            byArray[4] = (byte)(byArray2.length >>> 8 & 0xFF);
            byArray[5] = (byte)(byArray2.length & 0xFF);
            System.arraycopy(byArray2, 0, byArray, 6, byArray2.length);
        } else {
            byArray = new byte[]{(byte)n, (byte)(bl ? 1 : 0)};
        }
        jSR082Connection.write(byArray);
        byArray2 = new byte[1];
        jSR082Connection.read(byArray2);
        if (byArray2[0] == 4) {
            throw new BluetoothStateException("request ignored");
        }
        return byArray2[0] != 0;
    }

    static String readBTAddress(JSR082Connection jSR082Connection) throws IOException {
        byte[] byArray = new byte[12];
        jSR082Connection.read(byArray);
        try {
            return new String(byArray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException("security parameters error 1");
        }
    }

    static void writeBTAddress(JSR082Connection jSR082Connection, String string) throws IOException {
        if (string.length() != 12) {
            throw new IOException("security parameters error 2");
        }
        try {
            jSR082Connection.write(string.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException("security parameters error 3");
        }
    }

    private boolean processCmdEncrypt(RemoteDeviceImpl remoteDeviceImpl, boolean bl) throws BluetoothStateException {
        SecurityState securityState = SecurityState.getSecurityState(remoteDeviceImpl);
        return securityState.remoteRequestForEncrypt(bl);
    }

    private boolean processCmdAuthenticate(RemoteDeviceImpl remoteDeviceImpl) throws IOException {
        byte[] byArray = new byte[4];
        conn.read(byArray);
        int n = (byArray[0] & 0xFF) << 24;
        n |= (byArray[1] & 0xFF) << 16;
        n |= (byArray[2] & 0xFF) << 8;
        byte[] byArray2 = new byte[n |= byArray[3] & 0xFF];
        conn.read(byArray2);
        SecurityState securityState = SecurityState.getSecurityState(remoteDeviceImpl);
        return securityState.remoteRequestForAuthenticate(byArray2);
    }

    private boolean processCmdForceMaster(RemoteDeviceImpl remoteDeviceImpl) throws IOException {
        SecurityState securityState = SecurityState.getSecurityState(remoteDeviceImpl);
        return securityState.remoteRequestForMaster();
    }
}

