/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.bluetooth.DataElement;
import com.sun.kvem.bluetooth.ServiceRecord;
import com.sun.kvem.bluetooth.UUID;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;

public final class NetmonBluetooth {
    private static native void updateServiceRecord(int var0, byte[] var1, int var2, int var3);

    public static void notifierUpdateServiceRecord(int n, ServiceRecord serviceRecord) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int[] nArray = serviceRecord.getAttributeIDs();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                dataOutputStream.writeInt(n2);
                NetmonBluetooth.write(dataOutputStream, serviceRecord.getAttributeValue(n2));
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            NetmonBluetooth.updateServiceRecord(n, byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void write(DataOutputStream dataOutputStream, DataElement dataElement) throws IOException {
        int n = dataElement.getDataType();
        dataOutputStream.writeInt(n);
        switch (n) {
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                dataOutputStream.writeLong(dataElement.getLong());
                break;
            }
            case 40: {
                dataOutputStream.writeBoolean(dataElement.getBoolean());
                break;
            }
            case 11: 
            case 12: 
            case 20: {
                byte[] byArray = (byte[])dataElement.getValue();
                dataOutputStream.write(byArray);
                break;
            }
            case 0: {
                break;
            }
            case 32: 
            case 64: {
                dataOutputStream.writeUTF((String)dataElement.getValue());
                break;
            }
            case 24: {
                dataOutputStream.writeUTF(((UUID)dataElement.getValue()).toString());
                break;
            }
            case 48: 
            case 56: {
                Enumeration enumeration = (Enumeration)dataElement.getValue();
                while (enumeration.hasMoreElements()) {
                    NetmonBluetooth.write(dataOutputStream, (DataElement)enumeration.nextElement());
                }
                dataOutputStream.writeInt(-1);
            }
        }
    }
}

