/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.bluetooth.BluetoothConnectionException;
import com.sun.kvem.bluetooth.BluetoothStateException;
import com.sun.kvem.bluetooth.LocalDevice;
import com.sun.kvem.bluetooth.UUID;
import com.sun.kvem.jsr082.impl.PermissionsHandler;
import com.sun.kvem.jsr082.impl.Utilites;
import com.sun.kvem.jsr082.impl.bluetooth.BTConnectionBase;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.bluetooth.BluetoothController;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityTokenHandler;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import com.sun.kvem.jsr082.impl.io.JSR082Notifier;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.io.Connection;

public abstract class BluetoothProtocolBase {
    private static final boolean DEBUG = false;
    private final PermissionsHandler clientPH = new PermissionsHandler();
    private final PermissionsHandler serverPH = new PermissionsHandler();
    protected String protocol;
    private static final String cn = "bt<common>.Protocol";
    protected String errorMsg;
    protected String numberStr;
    private boolean encrypt;
    private boolean authenticate;
    private boolean authorize;
    private boolean master;
    private String serverName;
    private int mode;
    protected boolean isSystemUse;
    protected String origName;
    private String btaddress;

    public BluetoothProtocolBase(String string) {
        this.protocol = string;
    }

    public Connection openPrim(String string, int n, boolean bl) throws IOException {
        return this.openPrim(null, string, n, bl);
    }

    public Connection openPrim(Object object, String string, int n, boolean bl) throws IOException {
        this.origName = this.protocol + string;
        this.errorMsg = "Malformed URL: " + this.protocol + string;
        try {
            LocalDevice.getLocalDevice();
        }
        catch (BluetoothStateException bluetoothStateException) {
            throw new IOException("bluetooth support is not initialized.");
        }
        this.checkOpenMode(n);
        this.mode = n;
        String string2 = string;
        string = string.toLowerCase();
        if (string.startsWith("//localhost")) {
            if (object instanceof BluetoothController) {
                this.isSystemUse = true;
            } else {
                this.serverPH.checkForPermission(object, -1, this.origName);
                this.isSystemUse = object != null;
            }
            return this.processServerNotifier(string, string2);
        }
        if (object instanceof BluetoothController) {
            this.isSystemUse = true;
        } else {
            this.clientPH.checkForPermission(object, -1, this.origName);
            this.isSystemUse = object != null;
        }
        return this.processClientConnection(string, string2);
    }

    private Hashtable parseURL(String string, String string2) {
        Hashtable<String, String> hashtable = null;
        int n = 0;
        if (!string.startsWith("//")) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        if (n2 == string.length() - 1) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        this.btaddress = string.substring(2, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf(59, n)) != -1) {
            this.numberStr = string.substring(n, n2);
            hashtable = new Hashtable<String, String>();
        } else {
            this.numberStr = string.substring(n);
        }
        while (n2 != -1) {
            if (n2 == string.length() - 1) {
                throw new IllegalArgumentException(this.errorMsg);
            }
            n = n2 + 1;
            if ((n2 = string.indexOf(61, n)) <= n || n2 == string.length() - 1) {
                throw new IllegalArgumentException(this.errorMsg);
            }
            String string3 = string.substring(n, n2);
            if (hashtable.containsKey(string3)) {
                throw new IllegalArgumentException(this.errorMsg);
            }
            n = n2 + 1;
            n2 = string.indexOf(59, n);
            String string4 = "name".equals(string3) ? (n2 != -1 ? string2.substring(n, n2) : string2.substring(n)) : (n2 != -1 ? string.substring(n, n2) : string.substring(n));
            hashtable.put(string3, string4);
        }
        return hashtable;
    }

    private Connection processClientConnection(String string, String string2) throws IOException {
        BTConnectionBase bTConnectionBase = this.createConnection();
        Hashtable hashtable = this.parseURL(string, string2);
        if (!Utilites.checkBluetoothAddress(this.btaddress)) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        this.btaddress = this.btaddress.toUpperCase();
        bTConnectionBase.setRemoteAddress(this.btaddress);
        int n = this.getChannelOrPSM();
        this.getParameters(hashtable, bTConnectionBase, false);
        if (hashtable != null && !hashtable.isEmpty()) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        int n2 = bTConnectionBase.clientConnectionGetTransportPort(this.btaddress, n);
        if (n2 == 0) {
            throw new IOException("Connection is refused");
        }
        JSR082Connection jSR082Connection = null;
        try {
            jSR082Connection = new JSR082Connection(SecurityTokenHandler.getSecurityToken(), n2);
        }
        catch (IOException iOException) {
            throw new IOException("Connection is refused");
        }
        try {
            bTConnectionBase.initClientConnection(jSR082Connection, this.mode, this.master, this.authenticate, this.encrypt);
        }
        catch (IOException iOException) {
            try {
                jSR082Connection.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        return bTConnectionBase;
    }

    private Connection processServerNotifier(String string, String string2) throws IOException {
        BTNotifierBase bTNotifierBase = this.createNotifier();
        Hashtable hashtable = this.parseURL(string, string2);
        this.setUUID(bTNotifierBase);
        this.getParameters(hashtable, bTNotifierBase, true);
        if (hashtable != null && !hashtable.isEmpty()) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        JSR082Notifier jSR082Notifier = new JSR082Notifier(SecurityTokenHandler.getSecurityToken());
        try {
            bTNotifierBase.initServerNotifier(jSR082Notifier, this.mode, this.serverName, this.master, this.authorize, this.authenticate, this.encrypt);
        }
        catch (IOException iOException) {
            try {
                jSR082Notifier.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        return bTNotifierBase;
    }

    protected void getParameters(Hashtable hashtable, Connection connection, boolean bl) throws BluetoothConnectionException {
        if (hashtable != null) {
            int n;
            if (bl) {
                this.serverName = (String)hashtable.remove("name");
                if (this.serverName != null) {
                    if (this.serverName.length() == 0) {
                        throw new IllegalArgumentException("zero length service name");
                    }
                    for (n = 0; n < this.serverName.length(); ++n) {
                        char c = this.serverName.charAt(n);
                        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == ' ' || c == '-' || c == '_') continue;
                        throw new IllegalArgumentException("wrong character in service name");
                    }
                }
                this.authorize = BluetoothProtocolBase.extractBoolean("authorize", hashtable, false);
            }
            this.encrypt = BluetoothProtocolBase.extractBoolean("encrypt", hashtable, false);
            n = this.encrypt || this.authorize ? 1 : 0;
            this.authenticate = BluetoothProtocolBase.extractBoolean("authenticate", hashtable, n != 0);
            if (n != 0 && !this.authenticate) {
                throw new BluetoothConnectionException(6, "invalid security parameters");
            }
            this.master = BluetoothProtocolBase.extractBoolean("master", hashtable, false);
        }
    }

    protected void setUUID(BTNotifierBase bTNotifierBase) {
        try {
            bTNotifierBase.serverUUID = new UUID(this.numberStr, false);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(this.errorMsg);
        }
    }

    protected static boolean extractBoolean(String string, Hashtable hashtable, boolean bl) {
        String string2 = (String)hashtable.remove(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException(string + " should be 'true' of 'false': " + string2);
    }

    protected void checkOpenMode(int n) {
        if (n != 3) {
            throw new IllegalArgumentException("Unsupported mode: " + n);
        }
    }

    protected abstract int getChannelOrPSM();

    protected abstract BTConnectionBase createConnection() throws IOException;

    protected abstract BTNotifierBase createNotifier() throws IOException;
}

