/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.j2se.io.gcf.btl2cap.Protocol;
import com.sun.kvem.bluetooth.BluetoothStateException;
import com.sun.kvem.bluetooth.DeviceClass;
import com.sun.kvem.bluetooth.DiscoveryListener;
import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.BluetoothConnection;
import com.sun.kvem.jsr082.bluetooth.DiscoveryAgentImpl;
import com.sun.kvem.jsr082.bluetooth.RemoteDeviceImpl;
import com.sun.kvem.jsr082.impl.JSR082Controller;
import com.sun.kvem.jsr082.impl.PermissionsHandler;
import com.sun.kvem.jsr082.impl.Utilites;
import com.sun.kvem.jsr082.impl.bluetooth.BTDeviceDiscoverer;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityListener;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityState;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.io.Connection;

public final class BluetoothController
implements BCC {
    private static final String cn = "BluetoothController";
    private static final boolean DEBUG = false;
    private static final String BLUETOOTH_DEVICE_ADDRESS = "bluetooth.device.address";
    private static final String BLUETOOTH_DEVICE_FRIENDLY_NAME = "bluetooth.device.friendlyName";
    private static final String BLUETOOTH_DEVICE_RECORD = "bluetooth.device.classRecord";
    private static final String BLUETOOTH_DEVICE_DISCOVERABLE = "bluetooth.device.discoverable";
    private static final String BLUETOOTH_DEVICE_DISCOVERY_TIMEOUT = "bluetooth.device.discovery.timeout";
    private static final String BLUETOOTH_ENABLE = "bluetooth.enable";
    private static final String BLUETOOTH_DEVICE_DISCOVERY_ENABLE = "bluetooth.device.discovery.enable";
    private static final String BLUETOOTH_DEVICE_ENCRYPTION = "bluetooth.device.encryption";
    private static final String BLUETOOTH_DEVICE_AUTHORIZATION = "bluetooth.device.authorization";
    private static final String BLUETOOTH_DEVICE_AUTHENTCATION = "bluetooth.device.authentication";
    private static final String UNDEFINED_FRIENDLY_NAME = "-u-n-d-e-f-i-n-e-d-";
    private DiscoveryAgentImpl agent;
    private JSR082Controller finalizerObj;
    static final String COMMAND_DISCOVER_DEVICES = "discoverBTDevices";
    static final String COMMAND_GET_DEVICE_ATTRIBUTES = "getBTDeviceAttributes";
    private static final String COMMAND_REGISTER_BTDEVICE = "registerBTDevice";
    private static final String COMMAND_UPDATE_DEVICE_CLASS = "updateDeviceClass";
    private static final String COMMAND_GET_FRIENDLY_NAME = "getFriendlyName";
    private static final String COMMAND_REGISTER_L2CAP_NOTIFIER = "registerBTL2CAPNotifier";
    private static final String COMMAND_UNREGISTER_L2CAP_NOTIFIER = "unregisterBTL2CAPNotifier";
    private static final String COMMAND_GET_L2CAP_NOTIFIER_PORT = "getBTL2CAPNotifierPort";
    private static final String COMMAND_SET_BTDEVICE_ACCESS_CODE = "setBTDeviceAccessCode";
    private static final String COMMAND_REGISTER_SPP_NOTIFIER = "registerBTSPPNotifier";
    private static final String COMMAND_UNREGISTER_SPP_NOTIFIER = "unregisterBTSPPNotifier";
    private static final String COMMAND_GET_SPP_NOTIFIER_PORT = "getBTSPPNotifierPort";
    private static final String COMMAND_REGISTER_SECURITY_LISTENER = "registerSecurityListener";
    private static final String COMMAND_GET_SECURITY_LISTENER_PORT = "getSecurityListenerPort";
    private static BluetoothController instance;
    private static final byte[] pinCode;
    private static final int DEFAULT_DEVICE_CLASS = 516;
    private static boolean isInitialized;
    private String bluetoothAddress;
    private String friendlyName;
    private int baseDeviceClass;
    private int deviceClass;
    private DeviceClass deviceClassObj;
    private int discoverable;
    private int discoveryTimeout;
    private Hashtable ldProperties = new Hashtable();
    private BTDeviceDiscoverer deviceDiscoverer;
    private boolean bluetoothEnable = true;
    private boolean discoveringEnable = true;
    boolean forceNoEncrypt = false;
    boolean forceEncrypt = false;
    boolean forceAuthenticate = false;
    boolean forceAuthorize = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothController() {
        Class clazz = BluetoothController.class;
        synchronized (clazz) {
            if (instance != null) {
                throw new RuntimeException("BluetoothController is created already.");
            }
            instance = this;
        }
        this.deviceDiscoverer = new BTDeviceDiscoverer();
    }

    static BluetoothController getInstance() {
        if (instance == null || !isInitialized) {
            throw new RuntimeException("Not initialized...");
        }
        return instance;
    }

    public void registerBTL2CAPNotifier(int n, int n2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(COMMAND_REGISTER_L2CAP_NOTIFIER);
        stringBuffer.append('\n').append(this.bluetoothAddress).append('\n');
        stringBuffer.append(Integer.toString(n)).append('\n');
        stringBuffer.append(Integer.toString(n2)).append('\n');
        JSR082Controller.processCommand(2, stringBuffer.toString());
    }

    public void unregisterBTL2CAPNotifier(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(COMMAND_UNREGISTER_L2CAP_NOTIFIER);
        stringBuffer.append('\n').append(this.bluetoothAddress).append('\n');
        stringBuffer.append(Integer.toString(n)).append('\n');
        JSR082Controller.processCommand(2, stringBuffer.toString());
    }

    public int getBTL2CAPNotifierPort(String string, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(COMMAND_GET_L2CAP_NOTIFIER_PORT);
        stringBuffer.append('\n').append(string).append('\n');
        stringBuffer.append(Integer.toString(n)).append('\n');
        String string2 = JSR082Controller.processCommand(2, stringBuffer.toString());
        if (string2 == null) {
            throw new IOException("Can't connect");
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Internal error: wrong tcp port format: " + string2);
            throw new IOException("Can't connect");
        }
        return n2;
    }

    public boolean isDeviceConnectable() {
        return true;
    }

    public boolean setBTDeviceAccessCode(int n) throws BluetoothStateException {
        if (!this.discoveringEnable) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(COMMAND_SET_BTDEVICE_ACCESS_CODE);
        stringBuffer.append('\n').append(this.bluetoothAddress).append('\n');
        stringBuffer.append(Integer.toString(n)).append('\n');
        try {
            JSR082Controller.processCommand(2, stringBuffer.toString());
        }
        catch (IOException iOException) {
            return false;
        }
        this.discoverable = n;
        return true;
    }

    public void registerBTSPPNotifier(int n, int n2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(COMMAND_REGISTER_SPP_NOTIFIER);
        stringBuffer.append('\n').append(this.bluetoothAddress).append('\n');
        stringBuffer.append(Integer.toString(n)).append('\n');
        stringBuffer.append(Integer.toString(n2)).append('\n');
        JSR082Controller.processCommand(2, stringBuffer.toString());
    }

    public void unregisterBTSPPNotifier(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(COMMAND_UNREGISTER_SPP_NOTIFIER);
        stringBuffer.append('\n').append(this.bluetoothAddress).append('\n');
        stringBuffer.append(Integer.toString(n)).append('\n');
        JSR082Controller.processCommand(2, stringBuffer.toString());
    }

    public int getBTSPPNotifierPort(String string, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(COMMAND_GET_SPP_NOTIFIER_PORT);
        stringBuffer.append('\n').append(string).append('\n');
        stringBuffer.append(Integer.toString(n)).append('\n');
        String string2 = JSR082Controller.processCommand(2, stringBuffer.toString());
        if (string2 == null) {
            throw new IOException("Can't connect");
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Internal error: wrong tcp port format: " + string2);
            throw new IOException("Can't connect");
        }
        return n2;
    }

    public void registerSecurityListener(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(COMMAND_REGISTER_SECURITY_LISTENER);
        stringBuffer.append('\n').append(this.bluetoothAddress).append('\n');
        stringBuffer.append(Integer.toString(n)).append('\n');
        JSR082Controller.processCommand(2, stringBuffer.toString());
    }

    public int getSecurityListenerPort(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(COMMAND_GET_SECURITY_LISTENER_PORT);
        stringBuffer.append('\n').append(string).append('\n');
        String string2 = JSR082Controller.processCommand(2, stringBuffer.toString());
        if (string2 == null) {
            throw new IOException("Can't connect");
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Internal error: wrong tcp port format: " + string2);
            throw new IOException("Can't connect");
        }
        return n;
    }

    public void startInquiry(DiscoveryAgentImpl discoveryAgentImpl, DiscoveryListener discoveryListener, int n) {
        this.deviceDiscoverer.startDiscover(discoveryAgentImpl, discoveryListener, n);
    }

    public void cancelInquiry() {
        this.deviceDiscoverer.cancelDiscover();
    }

    public synchronized void initialize() throws Exception {
        if (isInitialized) {
            throw new RuntimeException("BluetoothController is initialized already.");
        }
        try {
            String string = JSR082Controller.getDeviceInfo(2, 17);
            Hashtable hashtable = new Hashtable();
            Utilites.parseInfo(string, hashtable);
            this.extractFromProperties(hashtable);
            if (!this.bluetoothEnable) {
                throw new Exception("Bluetooth disabled");
            }
            string = JSR082Controller.getDeviceInfo(2, 18);
            Utilites.parseInfo(string, this.ldProperties);
            this.checkSystemProperties();
            this.registerBTDevice();
            this.updateDeviceClass(0);
            this.deviceDiscoverer.initialize(this.discoveryTimeout);
            this.finalizerObj = JSR082Controller.getInstance();
            SecurityListener.start(this);
        }
        catch (Throwable throwable) {
            throw new Exception(throwable.getMessage());
        }
        isInitialized = true;
    }

    public String getBluetoothAddress() {
        return this.bluetoothAddress;
    }

    public String getFriendlyName() {
        return this.friendlyName.equals(UNDEFINED_FRIENDLY_NAME) ? null : this.friendlyName;
    }

    public DeviceClass getDeviceClass() {
        return this.deviceClassObj;
    }

    public void updateDeviceClass(int n) {
        this.deviceClass = this.baseDeviceClass | n;
        this.deviceClassObj = new DeviceClass(this.deviceClass);
        StringBuffer stringBuffer = new StringBuffer(COMMAND_UPDATE_DEVICE_CLASS);
        stringBuffer.append('\n').append(this.bluetoothAddress).append('\n');
        stringBuffer.append(Integer.toString(this.deviceClass)).append('\n');
        try {
            JSR082Controller.processCommand(2, stringBuffer.toString());
        }
        catch (IOException iOException) {
            System.err.println("JSR082 engine is unreachable.");
            throw new RuntimeException("JSR082 engine is unreachable.");
        }
    }

    public String getFriendlyName(RemoteDeviceImpl remoteDeviceImpl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(COMMAND_GET_FRIENDLY_NAME);
        stringBuffer.append('\n').append(remoteDeviceImpl.getBluetoothAddress()).append('\n');
        String string = JSR082Controller.processCommand(2, stringBuffer.toString());
        if (string == null) {
            throw new IOException("device is not available");
        }
        if (string.equals(UNDEFINED_FRIENDLY_NAME)) {
            string = "";
        }
        return string;
    }

    public int getDiscoverable() {
        return this.discoverable;
    }

    public Hashtable getProperties() {
        return this.ldProperties;
    }

    public boolean isTrustedDevice(RemoteDeviceImpl remoteDeviceImpl) {
        return false;
    }

    public boolean authorize(RemoteDeviceImpl remoteDeviceImpl, BluetoothConnection bluetoothConnection) {
        PermissionsHandler permissionsHandler = new PermissionsHandler();
        String string = null;
        try {
            string = remoteDeviceImpl.getFriendlyName(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string2 = remoteDeviceImpl.getBluetoothAddress();
        if (string != null) {
            string2 = string + "(" + string2 + ")";
        }
        try {
            permissionsHandler.checkForPermission(null, -1, string2);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public boolean authenticate(RemoteDeviceImpl remoteDeviceImpl) throws IOException {
        SecurityState securityState = SecurityState.getSecurityState(remoteDeviceImpl);
        return securityState.authenticate();
    }

    public boolean encrypt(RemoteDeviceImpl remoteDeviceImpl, BluetoothConnection bluetoothConnection, boolean bl) throws IOException {
        SecurityState securityState = SecurityState.getSecurityState(remoteDeviceImpl);
        return securityState.encrypt(bluetoothConnection, bl);
    }

    public boolean isEncrypted(RemoteDeviceImpl remoteDeviceImpl) {
        SecurityState securityState = SecurityState.getSecurityState(remoteDeviceImpl);
        return securityState.isEncrypted();
    }

    public boolean isAuthenticated(RemoteDeviceImpl remoteDeviceImpl) {
        SecurityState securityState = SecurityState.getSecurityState(remoteDeviceImpl);
        return securityState.isAuthenticated();
    }

    byte[] getDevicePinCode() {
        return pinCode;
    }

    DiscoveryAgentImpl getDiscoveryAgent() {
        return this.agent;
    }

    public void setDiscoveryAgent(DiscoveryAgentImpl discoveryAgentImpl) {
        this.agent = discoveryAgentImpl;
    }

    public Connection getL2CAPConnection(String string) throws IOException {
        Protocol protocol = new Protocol();
        return protocol.openPrim(this, string, 3, false);
    }

    private void registerBTDevice() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(COMMAND_REGISTER_BTDEVICE);
        stringBuffer.append('\n').append(this.bluetoothAddress).append('\n');
        stringBuffer.append(Integer.toString(this.deviceClass)).append('\n');
        stringBuffer.append(this.friendlyName).append('\n');
        String string = JSR082Controller.processCommand(2, stringBuffer.toString());
        if (string == null) {
            throw new IOException("null server respose");
        }
        if (string.equals("OK")) {
            return;
        }
        if (!Utilites.checkBluetoothAddress(string)) {
            throw new RuntimeException("Internal error: unexpected address response: " + string);
        }
        this.bluetoothAddress = string;
    }

    private void extractFromProperties(Hashtable hashtable) {
        this.bluetoothAddress = (String)hashtable.get(BLUETOOTH_DEVICE_ADDRESS);
        this.friendlyName = (String)hashtable.get(BLUETOOTH_DEVICE_FRIENDLY_NAME);
        this.baseDeviceClass = Utilites.getIntProperty(cn, hashtable, BLUETOOTH_DEVICE_RECORD, 16, 516);
        this.deviceClassObj = new DeviceClass(this.baseDeviceClass);
        this.discoverable = Utilites.getIntProperty(cn, hashtable, BLUETOOTH_DEVICE_DISCOVERABLE, 16, 0);
        this.discoveryTimeout = Utilites.getIntProperty(cn, hashtable, BLUETOOTH_DEVICE_DISCOVERY_TIMEOUT, 10000);
        this.bluetoothEnable = Utilites.getBooleanProperty(cn, hashtable, BLUETOOTH_ENABLE, true);
        this.discoveringEnable = Utilites.getBooleanProperty(cn, hashtable, BLUETOOTH_DEVICE_DISCOVERY_ENABLE, true);
        String string = (String)hashtable.get(BLUETOOTH_DEVICE_ENCRYPTION);
        if (string == null) {
            System.err.println("BluetoothController: Internal error: Can't get property: bluetooth.device.encryption");
        } else if (string.equals("off")) {
            this.forceNoEncrypt = true;
            this.forceEncrypt = false;
        } else if (string.equals("on")) {
            this.forceNoEncrypt = false;
            this.forceEncrypt = false;
        } else if (string.equals("force")) {
            this.forceNoEncrypt = false;
            this.forceEncrypt = true;
        } else {
            System.err.println("BluetoothController: Internal error: wrong value: bluetooth.device.encryption=" + string);
        }
        String string2 = (String)hashtable.get(BLUETOOTH_DEVICE_AUTHENTCATION);
        if (string2 == null) {
            System.err.println("BluetoothController: Internal error: Can't get property: bluetooth.device.authentication");
        } else if (string2.equals("on")) {
            this.forceAuthenticate = false;
        } else if (string2.equals("force")) {
            this.forceAuthenticate = true;
        } else {
            System.err.println("BluetoothController: Internal error: wrong value: bluetooth.device.encryption=" + string);
        }
        String string3 = (String)hashtable.get(BLUETOOTH_DEVICE_AUTHORIZATION);
        if (string3 == null) {
            System.err.println("BluetoothController: Internal error: Can't get property: bluetooth.device.authorization");
        } else if (string3.equals("on")) {
            this.forceAuthorize = false;
        } else if (string3.equals("force")) {
            this.forceAuthorize = true;
        } else {
            System.err.println("BluetoothController: Internal error: wrong value: bluetooth.device.encryption=" + string);
        }
    }

    private void checkSystemProperties() {
    }

    static {
        pinCode = new byte[]{1, 2, 3, 4, 5, 6};
    }
}

