/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.bluetooth.BluetoothConnectionException;
import com.sun.kvem.bluetooth.DataElement;
import com.sun.kvem.bluetooth.UUID;
import com.sun.kvem.jsr082.bluetooth.BluetoothNotifier;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import com.sun.kvem.jsr082.impl.bluetooth.BTHandlerBase;
import com.sun.kvem.jsr082.impl.io.JSR082Notifier;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class BTNotifierBase
extends BTHandlerBase
implements BluetoothNotifier {
    protected static final DataElement DE_L2CAP_UUID = new DataElement(24, new UUID(256L));
    protected static final DataElement DE_RFCOMM_UUID = new DataElement(24, new UUID(3L));
    protected static final DataElement DE_OBEX_UUID = new DataElement(24, new UUID(8L));
    protected static final DataElement DE_SERIAL_PORT_UUID = new DataElement(24, new UUID(4353L));
    protected static final int SERVICE_HANDLE_ATTR_ID = 0;
    protected static final int SERVICE_CLASS_ATTR_ID = 1;
    protected static final int PROTOCOL_ATTR_ID = 4;
    protected static final int NAME_ATTR_ID = 256;
    protected UUID serverUUID;
    protected ServiceRecordImpl serRec;
    protected Object serRecLock = new Object();
    protected DataElement protocolListMC;
    protected JSR082Notifier notif;
    protected boolean master;
    protected boolean authorize;
    protected boolean authenticate;
    protected boolean encrypt;
    protected boolean isSystemUse;

    protected static void checkRecord(ServiceRecordImpl serviceRecordImpl, DataElement dataElement) {
        String string = null;
        if (serviceRecordImpl.getAttributeValue(0) == null) {
            string = "missed service handle attribue";
            throw new IllegalArgumentException(string);
        }
        if (serviceRecordImpl.getAttributeValue(1) == null) {
            string = "missed service class attribue";
            throw new IllegalArgumentException(string);
        }
        DataElement dataElement2 = serviceRecordImpl.getAttributeValue(4);
        if (dataElement2 == null) {
            string = "missed protocol description list attribue";
            throw new IllegalArgumentException(string);
        }
        string = "wrong protocol description list attribue";
        if (dataElement2.getDataType() != 48) {
            throw new IllegalArgumentException(string);
        }
        Vector vector = BTNotifierBase.enum2vector(null, (Enumeration)dataElement2.getValue());
        Enumeration enumeration = (Enumeration)dataElement.getValue();
        while (enumeration.hasMoreElements()) {
            DataElement dataElement3 = (DataElement)enumeration.nextElement();
            if (BTNotifierBase.checkContains(dataElement3, vector)) continue;
            string = "wrong protocol description list attribue";
            throw new IllegalArgumentException(string);
        }
    }

    protected static ServiceRecordImpl copyRecord(BTNotifierBase bTNotifierBase, ServiceRecordImpl serviceRecordImpl) {
        ServiceRecordImpl serviceRecordImpl2 = new ServiceRecordImpl(bTNotifierBase, serviceRecordImpl.getHandle());
        serviceRecordImpl2.setDeviceServiceClasses(serviceRecordImpl.getDeviceServiceClasses());
        int[] nArray = serviceRecordImpl.getAttributeIDs();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            DataElement dataElement = serviceRecordImpl.getAttributeValue(nArray[i]);
            serviceRecordImpl2.setAttributeValue(nArray[i], dataElement);
        }
        return serviceRecordImpl2;
    }

    private static boolean checkContains(DataElement dataElement, Vector vector) {
        if (dataElement.getDataType() != 48) {
            return vector.removeElement(dataElement);
        }
        Enumeration enumeration = (Enumeration)dataElement.getValue();
        Vector vector2 = new Vector();
        while (enumeration.hasMoreElements()) {
            boolean bl = false;
            DataElement dataElement2 = (DataElement)enumeration.nextElement();
            for (int i = 0; i < vector.size(); ++i) {
                DataElement dataElement3 = (DataElement)vector.elementAt(i);
                if (dataElement3.getDataType() != 48) continue;
                BTNotifierBase.enum2vector(vector2, (Enumeration)dataElement3.getValue());
                if (!BTNotifierBase.checkContains(dataElement2, vector2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static Vector enum2vector(Vector vector, Enumeration enumeration) {
        if (vector == null) {
            vector = new Vector();
        } else {
            vector.removeAllElements();
        }
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    protected abstract void initServerNotifier(JSR082Notifier var1, int var2, String var3, boolean var4, boolean var5, boolean var6, boolean var7) throws IOException, BluetoothConnectionException;
}

