/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.bluetooth.DeviceClass;
import com.sun.kvem.bluetooth.DiscoveryListener;
import com.sun.kvem.jsr082.bluetooth.DiscoveryAgentImpl;
import com.sun.kvem.jsr082.bluetooth.RemoteDeviceImpl;
import com.sun.kvem.jsr082.impl.JSR082Controller;
import com.sun.kvem.jsr082.impl.Utilites;
import java.io.IOException;

class BTDeviceDiscoverer
implements Runnable {
    private static final boolean DEBUG = false;
    private static final String cn = "BTDeviceDiscoverer";
    private static final int DISCOVERING_RETRY_TIME = 50;
    private static final int STATE_READY = 1;
    private static final int STATE_RUNNING = 2;
    private static final int STATE_CANCELED = 4;
    private int state = 1;
    private DiscoveryAgentImpl agent;
    private DiscoveryListener listener;
    private int accessCode;
    private int discoveryTimeout;

    BTDeviceDiscoverer() {
    }

    public void run() {
        String string;
        block12: {
            long l = System.currentTimeMillis();
            StringBuffer stringBuffer = new StringBuffer("discoverBTDevices");
            stringBuffer.append('\n').append(Integer.toString(this.accessCode)).append('\n');
            string = null;
            do {
                try {
                    string = JSR082Controller.processCommand(2, stringBuffer.toString());
                }
                catch (IOException iOException) {
                    this.notifyDone(7);
                    return;
                }
                if (this.checkCanceled()) {
                    return;
                }
                if (string != null) break block12;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (System.currentTimeMillis() - l < (long)this.discoveryTimeout);
            this.notifyDone(0);
            return;
        }
        String[] stringArray = Utilites.splitString(string, ',');
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.checkCanceled()) {
                return;
            }
            RemoteDeviceImpl remoteDeviceImpl = null;
            DeviceClass deviceClass = null;
            try {
                int n = stringArray[i].indexOf(58);
                String string2 = stringArray[i].substring(0, n);
                remoteDeviceImpl = this.agent.getRemoteDevice(string2);
                int n2 = Integer.parseInt(stringArray[i].substring(n + 1));
                deviceClass = new DeviceClass(n2);
            }
            catch (Throwable throwable) {
                System.err.println("Internal Error: wrong dev disc information: " + stringArray[i]);
                this.notifyDone(7);
                return;
            }
            try {
                this.listener.deviceDiscovered(remoteDeviceImpl, deviceClass);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.notifyDone(0);
    }

    void initialize(int n) {
        this.discoveryTimeout = n;
    }

    synchronized void startDiscover(DiscoveryAgentImpl discoveryAgentImpl, DiscoveryListener discoveryListener, int n) {
        if (this.state != 1) {
            throw new RuntimeException("Internal error: wrong device discoverer state: " + this.state);
        }
        this.agent = discoveryAgentImpl;
        this.listener = discoveryListener;
        this.accessCode = n;
        this.state = 2;
        new Thread(this).start();
    }

    synchronized void cancelDiscover() {
        if (this.state != 2) {
            throw new RuntimeException("Internal error: wrong device discoverer state: " + this.state);
        }
        this.state = 4;
    }

    private synchronized boolean checkCanceled() {
        if (this.state != 4) {
            return false;
        }
        this.notifyDone(5);
        return true;
    }

    private synchronized void notifyDone(int n) {
        this.state = 1;
        try {
            this.listener.inquiryCompleted(n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.agent.inquiryCompleted();
    }
}

