/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.bluetooth.BluetoothConnectionException;
import com.sun.kvem.jsr082.bluetooth.BluetoothConnection;
import com.sun.kvem.jsr082.bluetooth.DiscoveryAgentImpl;
import com.sun.kvem.jsr082.bluetooth.RemoteDeviceImpl;
import com.sun.kvem.jsr082.impl.bluetooth.BTHandlerBase;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityListener;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityState;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import java.io.IOException;

public abstract class BTConnectionBase
extends BTHandlerBase
implements BluetoothConnection {
    private static final boolean DEBUG = false;
    private RemoteDeviceImpl remoteDevice;
    private SecurityState securityState;
    private boolean isAuthorized;
    private boolean isEncrypted;
    private boolean isServerSide;
    private boolean isFinished;
    protected JSR082Connection conn;

    protected BTConnectionBase() {
    }

    public RemoteDeviceImpl getRemoteDevice() throws IOException {
        if (this.isFinished) {
            throw new IOException("connection closed");
        }
        if (this.remoteDevice == null) {
            throw new IllegalArgumentException("is notifier");
        }
        return this.remoteDevice;
    }

    public boolean isAuthorized() {
        return this.isAuthorized;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean isServerSide() {
        return this.isServerSide;
    }

    public void setEncrypted(boolean bl) {
        this.isEncrypted = bl;
    }

    public void setAuthorized() {
        this.isAuthorized = true;
    }

    protected void waitSecurityExchange() {
        this.securityState.waitSecurityExchange();
    }

    void setRemoteAddress(String string) {
        DiscoveryAgentImpl discoveryAgentImpl = this.control.getDiscoveryAgent();
        this.remoteDevice = discoveryAgentImpl.getRemoteDevice(string);
        this.securityState = SecurityState.getSecurityState(this.remoteDevice);
        this.securityState.addConnection(this);
    }

    protected void initClientConnection(JSR082Connection jSR082Connection, int n, boolean bl, boolean bl2, boolean bl3) throws BluetoothConnectionException, IOException {
        this.conn = jSR082Connection;
        this.mode = n;
        SecurityListener.writeBTAddress(jSR082Connection, this.control.getBluetoothAddress());
        boolean bl4 = true;
        int n2 = 0;
        byte[] byArray = new byte[1];
        jSR082Connection.read(byArray);
        if (byArray[0] != 0) {
            bl4 = false;
            n2 = byArray[0];
        }
        if (bl4 && bl) {
            n2 = 4;
            bl4 = this.securityState.requestMaster();
        }
        if ((bl2 || this.control.forceAuthenticate) && bl4) {
            n2 = 2;
            bl4 = this.remoteDevice.authenticate();
        }
        if ((bl3 || this.control.forceEncrypt) && bl4) {
            n2 = 3;
            bl4 = this.remoteDevice.encrypt(this, bl3);
        }
        byArray[0] = bl4 ? (byte)0 : (byte)n2;
        jSR082Connection.write(byArray);
        if (!bl4) {
            this.securityState.removeConnection(this);
            throw new BluetoothConnectionException(2, this.getErrorMessage(n2));
        }
    }

    protected void initServerConnection(JSR082Connection jSR082Connection, BTNotifierBase bTNotifierBase, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws BluetoothConnectionException, IOException {
        this.conn = jSR082Connection;
        this.mode = n;
        this.isServerSide = true;
        String string = SecurityListener.readBTAddress(jSR082Connection);
        this.setRemoteAddress(string);
        int n2 = 0;
        boolean bl5 = true;
        byte[] byArray = new byte[1];
        if (bl) {
            n2 = 4;
            bl5 = this.securityState.requestMaster();
        }
        if ((bl2 || this.control.forceAuthorize) && bl5) {
            n2 = 1;
            bl5 = this.remoteDevice.authorize(this);
            bl3 = true;
        }
        if ((bl3 || this.control.forceAuthenticate) && bl5) {
            n2 = 2;
            bl5 = this.remoteDevice.authenticate();
        }
        if ((bl4 || this.control.forceEncrypt) && bl5) {
            n2 = 3;
            bl5 = this.remoteDevice.encrypt(this, true);
        }
        byArray[0] = bl5 ? (byte)0 : (byte)n2;
        jSR082Connection.write(byArray);
        jSR082Connection.read(byArray);
        if (bl5 && byArray[0] != 0) {
            n2 = byArray[0];
            bl5 = false;
        }
        if (!bl5) {
            this.securityState.removeConnection(this);
            throw new BluetoothConnectionException(2, this.getErrorMessage(n2));
        }
    }

    protected final void finish() throws IOException {
        this.securityState.encrypt(this, false);
        this.securityState.removeConnection(this);
        this.isFinished = true;
        this.conn.close();
    }

    private final String getErrorMessage(int n) {
        switch (n) {
            case 1: {
                return "not authorized";
            }
            case 2: {
                return "not authenticated";
            }
            case 3: {
                return "not encrypted";
            }
            case 4: {
                return "unable to switch master";
            }
        }
        return null;
    }

    protected abstract int clientConnectionGetTransportPort(String var1, int var2) throws IOException;
}

