/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.bluetooth.RemoteDevice;
import com.sun.kvem.bluetooth.UUID;
import com.sun.kvem.jsr082.bluetooth.SDPResponseListener;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import java.util.Enumeration;
import java.util.Hashtable;

abstract class ServiceSearcherBase
implements SDPResponseListener {
    private static final int MASK_OVERFLOW = -65536;
    RemoteDevice btDev;
    UUID[] uuidSet;
    int[] attrSet;

    ServiceSearcherBase(int[] nArray, UUID[] uUIDArray, RemoteDevice remoteDevice) {
        int n;
        Object object = new Object();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        if (uUIDArray == null) {
            throw new NullPointerException("null instance of UUID set");
        }
        if (remoteDevice == null) {
            throw new NullPointerException("null instance of RemoteDevice");
        }
        if (uUIDArray.length == 0) {
            throw new IllegalArgumentException("zero UUID set size");
        }
        if (nArray != null) {
            if (nArray.length == 0) {
                throw new IllegalArgumentException("zero attrSet size");
            }
            if (nArray.length > ServiceRecordImpl.RETRIEVABLE_MAX) {
                throw new IllegalArgumentException("attrSet size exceeding");
            }
            for (n = 0; n < nArray.length; ++n) {
                if ((nArray[n] & 0xFFFF0000) != 0) {
                    throw new IllegalArgumentException("illegal attrSet");
                }
                if (hashtable.put(new Integer(nArray[n]), object) == null) continue;
                throw new IllegalArgumentException("duplicated attribute ID");
            }
        }
        for (n = 0; n <= 4; ++n) {
            hashtable.put(new Integer(n), object);
        }
        this.attrSet = new int[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        n = 0;
        while (enumeration.hasMoreElements()) {
            this.attrSet[n] = (Integer)enumeration.nextElement();
            ++n;
        }
        hashtable.clear();
        for (n = 0; n < uUIDArray.length; ++n) {
            if (uUIDArray[n] == null) {
                throw new NullPointerException("null instance of UUID");
            }
            if (hashtable.put(uUIDArray[n], object) == null) continue;
            throw new IllegalArgumentException("duplicated UUID");
        }
        this.uuidSet = new UUID[hashtable.size()];
        enumeration = hashtable.keys();
        n = 0;
        while (enumeration.hasMoreElements()) {
            this.uuidSet[n] = (UUID)enumeration.nextElement();
            ++n;
        }
        this.btDev = remoteDevice;
    }
}

