/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.bluetooth.BluetoothStateException;
import com.sun.kvem.bluetooth.DataElement;
import com.sun.kvem.bluetooth.DiscoveryListener;
import com.sun.kvem.bluetooth.RemoteDevice;
import com.sun.kvem.bluetooth.ServiceRecord;
import com.sun.kvem.bluetooth.UUID;
import com.sun.kvem.jsr082.bluetooth.SDPClient;
import com.sun.kvem.jsr082.bluetooth.SDPResponseListener;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceSearcherBase;
import java.io.IOException;
import java.util.Hashtable;

class ServiceSearcher
extends ServiceSearcherBase {
    private static final boolean DEBUG = false;
    private static final String cn = "ServiceSearcher";
    private short transactionID;
    private DiscoveryListener discListener;
    private SDPClient sdp;
    private int[] handles;
    private int processedHandle;
    private boolean inactive = false;
    private static int requestCounter = 0;
    private static Hashtable searchers = new Hashtable();

    ServiceSearcher(int[] nArray, UUID[] uUIDArray, RemoteDevice remoteDevice, DiscoveryListener discoveryListener) {
        super(nArray, uUIDArray, remoteDevice);
        if (discoveryListener == null) {
            throw new NullPointerException("null instance of DiscoveryListener");
        }
        this.discListener = discoveryListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int start() throws BluetoothStateException {
        Class clazz = ServiceSearcher.class;
        synchronized (clazz) {
            if (requestCounter == ServiceRecordImpl.TRANS_MAX) {
                throw new BluetoothStateException("too mach concurent requests");
            }
            ++requestCounter;
        }
        this.transactionID = SDPClient.newTransactionID();
        ServiceSearcher.cancel(this.transactionID);
        searchers.put(new Integer(this.transactionID), this);
        try {
            this.sdp = new SDPClient(this.btDev.getBluetoothAddress());
            this.sdp.serviceSearchRequest(this.uuidSet, this.transactionID, this);
        }
        catch (IOException iOException) {
            ServiceSearcher serviceSearcher = this;
            synchronized (serviceSearcher) {
                this.stop();
                new NotifyListenerRunner(6);
                return this.transactionID;
            }
        }
        return this.transactionID;
    }

    public void errorResponse(int n, String string, int n2) {
        this.stop();
        if (n == 1 || n == 3 || n == 4 || n == 5 || n == 6) {
            this.notifyListener(3);
            System.err.println(string);
        } else if (n == 2) {
            this.notifyListener(4);
            System.err.println(string);
        } else if (n == 65536) {
            this.notifyListener(6);
        } else if (n == 65537) {
            new NotifyListenerRunner(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchResponse(int[] nArray, int n) {
        if (nArray == null || nArray.length == 0) {
            this.stop();
            this.notifyListener(4);
            return;
        }
        ServiceSearcher serviceSearcher = this;
        synchronized (serviceSearcher) {
            this.handles = nArray;
            this.processedHandle = 0;
        }
        try {
            this.sdp.serviceAttributeRequest(this.handles[this.processedHandle], this.attrSet, n, this);
        }
        catch (IOException iOException) {
            this.stop();
            this.notifyListener(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceAttributeResponse(int[] nArray, DataElement[] dataElementArray, int n) {
        ServiceRecord[] serviceRecordArray = this;
        synchronized (this) {
            ++this.processedHandle;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (dataElementArray != null) {
                serviceRecordArray = new ServiceRecordImpl[]{new ServiceRecordImpl(this.btDev, nArray, dataElementArray)};
                try {
                    this.discListener.servicesDiscovered(this.transactionID, serviceRecordArray);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (this.processedHandle == this.handles.length) {
                this.stop();
                super.notifyListener(1);
                return;
            }
            try {
                this.sdp.serviceAttributeRequest(this.handles[this.processedHandle], this.attrSet, n, (SDPResponseListener)this);
            }
            catch (IOException iOException) {
                this.stop();
                super.notifyListener(6);
            }
            return;
        }
    }

    public void serviceSearchAttributeResponse(int[] nArray, DataElement[] dataElementArray, int n) {
        throw new RuntimeException("unexpected call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        SDPClient sDPClient;
        SDPClient.freeTransactionID(this.transactionID);
        searchers.remove(new Integer(this.transactionID));
        Object object = this;
        synchronized (object) {
            if (this.sdp == null) {
                return;
            }
            this.inactive = true;
            sDPClient = this.sdp;
            this.sdp = null;
        }
        object = ServiceSearcher.class;
        synchronized (object) {
            --requestCounter;
        }
        try {
            sDPClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancel() {
        ServiceSearcher serviceSearcher = this;
        synchronized (serviceSearcher) {
            if (this.inactive) {
                return false;
            }
            this.inactive = true;
            if (this.sdp == null) {
                return false;
            }
        }
        return this.sdp.cancelServiceSearch(this.transactionID);
    }

    static boolean cancel(int n) {
        ServiceSearcher serviceSearcher = (ServiceSearcher)searchers.get(new Integer(n));
        if (serviceSearcher == null) {
            return false;
        }
        return serviceSearcher.cancel();
    }

    private void notifyListener(int n) {
        try {
            this.discListener.serviceSearchCompleted(this.transactionID, n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    class NotifyListenerRunner
    implements Runnable {
        int respCode;

        NotifyListenerRunner(int n) {
            this.respCode = n;
            new Thread(this).start();
        }

        public void run() {
            ServiceSearcher.this.notifyListener(this.respCode);
        }
    }
}

