/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.bluetooth.BluetoothStateException;
import com.sun.kvem.bluetooth.DataElement;
import com.sun.kvem.bluetooth.LocalDevice;
import com.sun.kvem.bluetooth.RemoteDevice;
import com.sun.kvem.bluetooth.ServiceRecord;
import com.sun.kvem.bluetooth.UUID;
import com.sun.kvem.jsr082.bluetooth.BluetoothNotifier;
import com.sun.kvem.jsr082.bluetooth.SDPClient;
import com.sun.kvem.jsr082.bluetooth.SDPResponseListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ServiceRecordImpl
implements ServiceRecord {
    static final int RETRIEVABLE_MAX = Integer.valueOf(LocalDevice.getProperty("bluetooth.sd.attr.retrievable.max"));
    static final int TRANS_MAX = Integer.valueOf(LocalDevice.getProperty("bluetooth.sd.trans.max"));
    private RemoteDevice remoteDevice = null;
    private BluetoothNotifier notifier = null;
    private Hashtable attributesTable = null;
    private int serviceClasses = 0;
    private String urlPrefix = null;
    private static final int MASK_OVERFLOW = -65536;
    private static final int MASK_INCORRECT_CLASS = -16760833;
    static final int ServiceRecordHandle = 0;
    static final int ServiceClassIDList = 1;
    static final int ServiceRecordState = 2;
    static final int ServiceID = 3;
    static final int PROTOCOL_DESCRIPTOR_LIST = 4;
    static final int BrowseGroupList = 5;
    static final int LanguageBasedAttributeIDList = 6;
    static final int ServiceInfoTimeToLive = 7;
    static final int ServiceAvailability = 8;
    static final int BluetoothProfileDescriptorList = 9;
    static final int DocumentationURL = 10;
    static final int ClientExecutableURL = 11;
    static final int IconURL = 12;
    static final int VersionNumberList = 512;
    static final int ServiceDatabaseState = 513;

    protected ServiceRecordImpl(RemoteDevice remoteDevice, int[] nArray, DataElement[] dataElementArray) {
        this.init(nArray, dataElementArray);
        this.remoteDevice = remoteDevice;
    }

    public ServiceRecordImpl(BluetoothNotifier bluetoothNotifier, int[] nArray, DataElement[] dataElementArray) {
        this.init(nArray, dataElementArray);
        this.notifier = bluetoothNotifier;
    }

    public ServiceRecordImpl(BluetoothNotifier bluetoothNotifier, int n) {
        this.notifier = bluetoothNotifier;
        this.attributesTable = new Hashtable(5);
        this.setHandle(n);
    }

    public int getHandle() {
        DataElement dataElement = (DataElement)this.attributesTable.get(new Integer(0));
        if (dataElement == null) {
            return -1;
        }
        return (int)dataElement.getLong();
    }

    public void removeHandle() {
        this.attributesTable.remove(new Integer(0));
    }

    public void setHandle(int n) {
        this.attributesTable.put(new Integer(0), new DataElement(10, (long)n & 0xFFFFFFFFL));
    }

    public BluetoothNotifier getNotifier() {
        return this.notifier;
    }

    private void init(int[] nArray, DataElement[] dataElementArray) {
        this.attributesTable = new Hashtable(nArray.length + 1);
        this.attrsInit(nArray, dataElementArray);
    }

    private void attrsInit(int[] nArray, DataElement[] dataElementArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.attributesTable.put(new Integer(nArray[i]), this.dataElementCopy(dataElementArray[i]));
        }
    }

    private DataElement dataElementCopy(DataElement dataElement) {
        if (dataElement.getDataType() == 48 || dataElement.getDataType() == 56) {
            DataElement dataElement2 = new DataElement(dataElement.getDataType());
            Enumeration enumeration = (Enumeration)dataElement.getValue();
            while (enumeration.hasMoreElements()) {
                dataElement2.addElement(this.dataElementCopy((DataElement)enumeration.nextElement()));
            }
            return dataElement2;
        }
        return dataElement;
    }

    public DataElement getAttributeValue(int n) {
        if ((n & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("attrID isn't a 16-bit unsigned integer");
        }
        DataElement dataElement = (DataElement)this.attributesTable.get(new Integer(n));
        if (dataElement == null) {
            return null;
        }
        return this.dataElementCopy(dataElement);
    }

    public RemoteDevice getHostDevice() {
        return this.remoteDevice;
    }

    public int[] getAttributeIDs() {
        int[] nArray = new int[this.attributesTable.size()];
        Enumeration enumeration = this.attributesTable.keys();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)enumeration.nextElement();
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populateRecord(int[] nArray) throws IOException {
        short s;
        Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
        Object object = new Object();
        if (this.remoteDevice == null) {
            throw new RuntimeException("local ServiceRecord");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("attrIDs size is zero");
        }
        if (nArray.length > RETRIEVABLE_MAX) {
            throw new IllegalArgumentException("attrIDs size exceeds retrievable.max");
        }
        for (s = 0; s < nArray.length; ++s) {
            if ((nArray[s] & 0xFFFF0000) != 0) {
                throw new IllegalArgumentException("attrID does not represent a 16-bit unsigned integer");
            }
            if (hashtable.put(new Integer(nArray[s]), object) == null) continue;
            throw new IllegalArgumentException("duplicated attribute ID");
        }
        s = SDPClient.newTransactionID();
        SDPClient sDPClient = null;
        SRSDPListener sRSDPListener = null;
        try {
            DataElement dataElement = (DataElement)this.attributesTable.get(new Integer(0));
            int n = (int)dataElement.getLong();
            sRSDPListener = new SRSDPListener();
            sDPClient = new SDPClient(this.remoteDevice.getBluetoothAddress());
            sDPClient.serviceAttributeRequest(n, nArray, s, sRSDPListener);
            SRSDPListener sRSDPListener2 = sRSDPListener;
            synchronized (sRSDPListener2) {
                if (sRSDPListener.ioExcpt == null && sRSDPListener.attrValues == null) {
                    try {
                        sRSDPListener.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            SDPClient.freeTransactionID(s);
            if (sDPClient != null) {
                try {
                    sDPClient.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        SDPClient.freeTransactionID(s);
        if (sDPClient != null) {
            try {
                sDPClient.close();
            }
            catch (IOException iOException) {}
        }
        if (sRSDPListener.ioExcpt != null) {
            throw sRSDPListener.ioExcpt;
        }
        if (sRSDPListener.attrValues == null) {
            return false;
        }
        if (sRSDPListener.attrValues.length == 0) {
            return false;
        }
        this.attrsInit(sRSDPListener.attrIDs, sRSDPListener.attrValues);
        return true;
    }

    public String getConnectionURL(int n, boolean bl) {
        int n2;
        Object object;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(";master=true");
        } else {
            stringBuffer.append(";master=false");
        }
        switch (n) {
            case 0: {
                stringBuffer.append(";encrypt=false;authenticate=false");
                break;
            }
            case 1: {
                stringBuffer.append(";encrypt=false;authenticate=true");
                break;
            }
            case 2: {
                stringBuffer.append(";encrypt=true;authenticate=true");
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported security type: " + n);
            }
        }
        String string2 = stringBuffer.toString();
        if (this.urlPrefix != null) {
            return this.urlPrefix + string2;
        }
        if (this.remoteDevice != null) {
            string = this.remoteDevice.getBluetoothAddress();
        } else {
            try {
                string = LocalDevice.getLocalDevice().getBluetoothAddress();
            }
            catch (BluetoothStateException bluetoothStateException) {
                return null;
            }
        }
        DataElement dataElement = this.getAttributeValue(4);
        Enumeration enumeration = (Enumeration)dataElement.getValue();
        int n3 = -1;
        int n4 = -1;
        UUID uUID = new UUID(256L);
        UUID uUID2 = new UUID(3L);
        UUID uUID3 = new UUID(8L);
        while (enumeration.hasMoreElements()) {
            DataElement dataElement2 = (DataElement)enumeration.nextElement();
            if (dataElement2.getDataType() != 48) continue;
            object = (Enumeration)dataElement2.getValue();
            n2 = -1;
            int n5 = -1;
            while (object.hasMoreElements()) {
                DataElement dataElement3 = (DataElement)object.nextElement();
                if (dataElement3.getDataType() == 8 || dataElement3.getDataType() == 9) {
                    n2 = (int)dataElement3.getLong();
                    continue;
                }
                if (dataElement3.getDataType() != 24) continue;
                UUID uUID4 = (UUID)dataElement3.getValue();
                if (uUID4.equals(uUID)) {
                    n5 = 0;
                    continue;
                }
                if (uUID4.equals(uUID2)) {
                    n5 = 1;
                    continue;
                }
                if (!uUID4.equals(uUID3)) continue;
                n5 = 2;
            }
            if (n5 > n3) {
                n3 = n5;
                if (n5 == 2) continue;
                n4 = n2;
                continue;
            }
            if (n5 != 1) continue;
            n4 = n2;
        }
        switch (n3) {
            case 0: {
                stringBuffer = new StringBuffer("btl2cap://");
                break;
            }
            case 1: {
                stringBuffer = new StringBuffer("btspp://");
                break;
            }
            case 2: {
                stringBuffer = new StringBuffer("btgoep://");
                break;
            }
            default: {
                System.err.println("Error: wrong protocol list");
                return null;
            }
        }
        if (n3 == 0 && (n4 < 4097 || n4 > 65535)) {
            System.err.println("Error: wrong protocol list");
            return null;
        }
        if (!(n3 != 1 && n3 != 2 || n4 > 0 && n4 <= 30)) {
            System.err.println("Error: wrong protocol list");
            return null;
        }
        stringBuffer.append(string).append(':');
        if (n3 == 0) {
            object = Integer.toHexString(n4);
            for (n2 = 4 - ((String)object).length(); n2 != 0; --n2) {
                stringBuffer.append('0');
            }
        } else {
            object = Integer.toString(n4);
        }
        stringBuffer.append((String)object);
        this.urlPrefix = stringBuffer.toString();
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public int getDeviceServiceClasses() {
        if (this.remoteDevice != null) {
            throw new RuntimeException("This ServiceRecord was created by a call to DiscoveryAgent.searchServices()");
        }
        return this.serviceClasses;
    }

    public void setDeviceServiceClasses(int n) {
        if (this.remoteDevice != null) {
            throw new RuntimeException("This ServiceRecord was created by a call to DiscoveryAgent.searchServices()");
        }
        if ((n & 0xFF003FFF) != 0) {
            throw new IllegalArgumentException("attempt to set incorrect bits");
        }
        this.serviceClasses = n;
    }

    public boolean setAttributeValue(int n, DataElement dataElement) {
        if ((n & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("attrID does not represent a 16-bit unsigned integer");
        }
        if (n == 0) {
            throw new IllegalArgumentException("attrID is the value of ServiceRecordHandle (0x0000)");
        }
        if (this.remoteDevice != null) {
            throw new RuntimeException("can't update ServiceRecord of the RemoteDevice");
        }
        Integer n2 = new Integer(n);
        if (dataElement == null) {
            return this.attributesTable.remove(n2) != null;
        }
        this.attributesTable.put(n2, this.dataElementCopy(dataElement));
        return true;
    }

    class SRSDPListener
    implements SDPResponseListener {
        DataElement[] attrValues = null;
        IOException ioExcpt = null;
        int[] attrIDs = null;

        SRSDPListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void errorResponse(int n, String string, int n2) {
            SRSDPListener sRSDPListener = this;
            synchronized (sRSDPListener) {
                this.ioExcpt = new IOException(string);
                this.notify();
            }
        }

        public void serviceSearchResponse(int[] nArray, int n) {
            throw new RuntimeException("unexpected call");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceAttributeResponse(int[] nArray, DataElement[] dataElementArray, int n) {
            SRSDPListener sRSDPListener = this;
            synchronized (sRSDPListener) {
                this.attrIDs = nArray;
                this.attrValues = dataElementArray;
                this.notify();
            }
        }

        public void serviceSearchAttributeResponse(int[] nArray, DataElement[] dataElementArray, int n) {
            throw new RuntimeException("unexpected call");
        }
    }
}

