/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.bluetooth.BluetoothStateException;
import com.sun.kvem.bluetooth.DeviceClass;
import com.sun.kvem.bluetooth.DiscoveryListener;
import com.sun.kvem.bluetooth.RemoteDevice;
import com.sun.kvem.bluetooth.ServiceRecord;
import com.sun.kvem.bluetooth.UUID;
import com.sun.kvem.jsr082.bluetooth.DiscoveryAgentImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceSelector;
import java.util.Hashtable;
import java.util.Vector;

final class SelectServiceHandler
implements DiscoveryListener {
    private static final boolean DEBUG = false;
    private Vector btDevs;
    private Hashtable btDevsHash;
    private Object btDevsLock = new Object();
    private boolean selectDevDisStarted;
    private boolean selectDevDisStopped;
    private DiscoveryAgentImpl agent;

    SelectServiceHandler(DiscoveryAgentImpl discoveryAgentImpl) {
        this.agent = discoveryAgentImpl;
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        if (this.btDevsHash.put(remoteDevice, remoteDevice) == null) {
            this.btDevs.addElement(remoteDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int n) {
        Object object = this.btDevsLock;
        synchronized (object) {
            this.selectDevDisStopped = true;
            this.btDevsLock.notify();
        }
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
        throw new RuntimeException("unexpected call");
    }

    public void serviceSearchCompleted(int n, int n2) {
        throw new RuntimeException("unexpected call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String selectService(UUID uUID, int n, boolean bl) throws BluetoothStateException {
        Vector vector = null;
        Hashtable hashtable = new Hashtable();
        if (uUID == null) {
            throw new NullPointerException("uuid is null");
        }
        String string = this.selectFromDevicesList(this.agent.retrieveDevices(1), uUID, n, bl, hashtable);
        if (string != null) {
            return string;
        }
        string = this.selectFromDevicesList(this.agent.retrieveDevices(0), uUID, n, bl, hashtable);
        if (string != null) {
            return string;
        }
        Object object = this.btDevsLock;
        synchronized (object) {
            if (this.selectDevDisStarted) {
                throw new BluetoothStateException("The previous device discovery is running...");
            }
            this.selectDevDisStarted = true;
            this.btDevs = new Vector();
            this.btDevsHash = hashtable;
        }
        try {
            this.agent.startInquiry(10390323, this);
        }
        catch (BluetoothStateException bluetoothStateException) {
            Object object2 = this.btDevsLock;
            synchronized (object2) {
                this.selectDevDisStarted = false;
                this.btDevs = null;
                this.btDevsHash = null;
            }
            throw bluetoothStateException;
        }
        object = this.btDevsLock;
        synchronized (object) {
            if (!this.selectDevDisStopped) {
                try {
                    this.btDevsLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                vector = this.btDevs;
                this.btDevs = null;
                this.btDevsHash = null;
                this.selectDevDisStarted = false;
                this.selectDevDisStopped = false;
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            RemoteDevice remoteDevice = (RemoteDevice)vector.elementAt(i);
            string = this.selectService(remoteDevice, uUID, n, bl);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    private String selectFromDevicesList(RemoteDevice[] remoteDeviceArray, UUID uUID, int n, boolean bl, Hashtable hashtable) {
        if (remoteDeviceArray == null) {
            return null;
        }
        for (int i = 0; i < remoteDeviceArray.length; ++i) {
            String string;
            if (hashtable.put(remoteDeviceArray[i], remoteDeviceArray[i]) != null || (string = this.selectService(remoteDeviceArray[i], uUID, n, bl)) == null) continue;
            return string;
        }
        return null;
    }

    private String selectService(RemoteDevice remoteDevice, UUID uUID, int n, boolean bl) {
        UUID[] uUIDArray = new UUID[]{uUID};
        ServiceSelector serviceSelector = new ServiceSelector(null, uUIDArray, remoteDevice);
        ServiceRecord serviceRecord = serviceSelector.getServiceRecord();
        if (serviceRecord == null) {
            return null;
        }
        return serviceRecord.getConnectionURL(n, bl);
    }
}

