/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.bluetooth.DataElement;
import com.sun.kvem.bluetooth.L2CAPConnection;
import com.sun.kvem.bluetooth.L2CAPConnectionNotifier;
import com.sun.kvem.bluetooth.UUID;
import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.DataL2CAPReaderWriter;
import com.sun.kvem.jsr082.bluetooth.LocalDeviceImpl;
import com.sun.kvem.jsr082.bluetooth.SDDBImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

class SDPServer {
    private static final boolean DEBUG = false;
    private SDDBImpl sddb;
    private L2CAPConnectionNotifier conNotifier = null;
    private Vector connections;
    private Acceptor acceptor;
    private boolean acceptorStarted = false;
    private static final int SDP_UUID = 1;
    private static final int SDP_ERROR_RESPONSE = 1;
    private static final int SDP_SERVICE_SEARCH_REQUEST = 2;
    private static final int SDP_SERVICE_SEARCH_RESPONSE = 3;
    private static final int SDP_SERVICE_ATTRIBUTE_REQUEST = 4;
    private static final int SDP_SERVICE_ATTRIBUTE_RESPONSE = 5;
    private static final int SDP_SERVICE_SEARCH_ATTRIBUTE_REQUEST = 6;
    private static final int SDP_SERVICE_SEARCH_ATTRIBUTE_RESPONSE = 7;
    private static final int SDP_INVALID_VERSION = 1;
    private static final int SDP_INVALID_SR_HANDLE = 2;
    private static final int SDP_INVALID_SYNTAX = 3;

    SDPServer(SDDBImpl sDDBImpl) {
        this.sddb = sDDBImpl;
        this.connections = new Vector();
        this.acceptor = new Acceptor();
    }

    synchronized void start() {
        if (this.acceptorStarted) {
            return;
        }
        UUID uUID = new UUID(1L);
        try {
            BCC bCC = LocalDeviceImpl.getBCC();
            this.conNotifier = (L2CAPConnectionNotifier)bCC.getL2CAPConnection("//localhost:" + uUID.toString() + ";name=SDPServer");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.conNotifier != null) {
            this.acceptorStarted = true;
            new Thread(this.acceptor).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stop() {
        try {
            this.conNotifier.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = this.connections.size(); i >= 0; --i) {
            L2CAPConnection l2CAPConnection = (L2CAPConnection)this.connections.elementAt(i);
            try {
                L2CAPConnection l2CAPConnection2 = l2CAPConnection;
                synchronized (l2CAPConnection2) {
                    l2CAPConnection.close();
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.connections.removeAllElements();
    }

    private void processRequest(DataL2CAPReaderWriter dataL2CAPReaderWriter) throws IOException {
        byte by = dataL2CAPReaderWriter.readByte();
        short s = dataL2CAPReaderWriter.readShort();
        short s2 = dataL2CAPReaderWriter.readShort();
        if (by == 2) {
            this.processServiceSearch(dataL2CAPReaderWriter, s);
        } else if (by == 4) {
            this.processServiceAttribute(dataL2CAPReaderWriter, s);
        } else if (by == 6) {
            this.processServiceSearchAttribute(dataL2CAPReaderWriter, s);
        } else {
            this.writeErrorResponce(dataL2CAPReaderWriter, s, 3, "Invalid Type of Request");
            System.err.println("WARNING: Unsupported SDP request");
        }
    }

    private void processServiceSearch(DataL2CAPReaderWriter dataL2CAPReaderWriter, short s) throws IOException {
        int n;
        DataElement dataElement = dataL2CAPReaderWriter.readDataElement();
        short s2 = dataL2CAPReaderWriter.readShort();
        byte by = dataL2CAPReaderWriter.readByte();
        if (by != 0) {
            this.writeErrorResponce(dataL2CAPReaderWriter, s, 1, "Current implementation don't support continuation state");
            return;
        }
        Vector<Integer> vector = new Vector<Integer>();
        int[] nArray = this.sddb.getHandles();
        for (n = 0; n < nArray.length; ++n) {
            ServiceRecordImpl serviceRecordImpl = this.sddb.getServiceRecord(nArray[n]);
            if (!this.findUUIDs(serviceRecordImpl, dataElement)) continue;
            vector.addElement(new Integer(nArray[n]));
        }
        dataL2CAPReaderWriter.writeByte(3L);
        dataL2CAPReaderWriter.writeShort(s);
        dataL2CAPReaderWriter.writeShort((short)(vector.size() + 5));
        dataL2CAPReaderWriter.writeShort((short)nArray.length);
        dataL2CAPReaderWriter.writeShort((short)vector.size());
        for (n = 0; n < vector.size() && n <= s2; ++n) {
            int n2 = (Integer)vector.elementAt(n);
            dataL2CAPReaderWriter.writeInteger(n2);
        }
        dataL2CAPReaderWriter.writeByte(0L);
        dataL2CAPReaderWriter.flush();
    }

    private void processServiceAttribute(DataL2CAPReaderWriter dataL2CAPReaderWriter, short s) throws IOException {
        int n = dataL2CAPReaderWriter.readInteger();
        short s2 = dataL2CAPReaderWriter.readShort();
        DataElement dataElement = dataL2CAPReaderWriter.readDataElement();
        byte by = dataL2CAPReaderWriter.readByte();
        if (by != 0) {
            this.writeErrorResponce(dataL2CAPReaderWriter, s, 1, "Current implementation don't support continuation state");
            return;
        }
        ServiceRecordImpl serviceRecordImpl = this.sddb.getServiceRecord(n);
        if (serviceRecordImpl == null) {
            this.writeErrorResponce(dataL2CAPReaderWriter, s, 2, "Servicce Record with specified ID not found");
            return;
        }
        DataElement dataElement2 = new DataElement(48);
        Enumeration enumeration = (Enumeration)dataElement.getValue();
        while (enumeration.hasMoreElements()) {
            DataElement dataElement3 = (DataElement)enumeration.nextElement();
            int n2 = (int)dataElement3.getLong();
            DataElement dataElement4 = serviceRecordImpl.getAttributeValue(n2);
            if (dataElement4 == null) continue;
            dataElement2.addElement(dataElement3);
            dataElement2.addElement(dataElement4);
        }
        int n3 = (int)dataL2CAPReaderWriter.getDataSize(dataElement2);
        dataL2CAPReaderWriter.writeByte(5L);
        dataL2CAPReaderWriter.writeShort(s);
        dataL2CAPReaderWriter.writeShort((short)(n3 + 3));
        dataL2CAPReaderWriter.writeShort((short)n3);
        dataL2CAPReaderWriter.writeDataElement(dataElement2);
        dataL2CAPReaderWriter.writeByte(0L);
        dataL2CAPReaderWriter.flush();
    }

    private void processServiceSearchAttribute(DataL2CAPReaderWriter dataL2CAPReaderWriter, short s) throws IOException {
        Object object;
        DataElement dataElement = dataL2CAPReaderWriter.readDataElement();
        short s2 = dataL2CAPReaderWriter.readShort();
        DataElement dataElement2 = dataL2CAPReaderWriter.readDataElement();
        byte by = dataL2CAPReaderWriter.readByte();
        if (by != 0) {
            this.writeErrorResponce(dataL2CAPReaderWriter, s, 1, "Current implementation don't support continuation state");
            return;
        }
        int[] nArray = this.sddb.getHandles();
        int n = -1;
        for (int i = 0; i < nArray.length; ++i) {
            object = this.sddb.getServiceRecord(nArray[i]);
            if (!this.findUUIDs((ServiceRecordImpl)object, dataElement)) continue;
            n = nArray[i];
        }
        ServiceRecordImpl serviceRecordImpl = this.sddb.getServiceRecord(n);
        if (serviceRecordImpl == null) {
            this.writeErrorResponce(dataL2CAPReaderWriter, s, 2, "Servicce Record with specified ID not found");
            return;
        }
        object = new DataElement(48);
        Enumeration enumeration = (Enumeration)dataElement2.getValue();
        while (enumeration.hasMoreElements()) {
            DataElement dataElement3 = (DataElement)enumeration.nextElement();
            int n2 = (int)dataElement3.getLong();
            DataElement dataElement4 = serviceRecordImpl.getAttributeValue(n2);
            if (dataElement4 == null) continue;
            ((DataElement)object).addElement(dataElement3);
            ((DataElement)object).addElement(dataElement4);
        }
        int n3 = (int)dataL2CAPReaderWriter.getDataSize((DataElement)object);
        dataL2CAPReaderWriter.writeByte(7L);
        dataL2CAPReaderWriter.writeShort(s);
        dataL2CAPReaderWriter.writeShort((short)(n3 + 3));
        dataL2CAPReaderWriter.writeShort((short)n3);
        dataL2CAPReaderWriter.writeDataElement((DataElement)object);
        dataL2CAPReaderWriter.writeByte(0L);
        dataL2CAPReaderWriter.flush();
    }

    private void writeErrorResponce(DataL2CAPReaderWriter dataL2CAPReaderWriter, short s, int n, String string) throws IOException {
        byte[] byArray = string.getBytes();
        int n2 = byArray.length + 2;
        dataL2CAPReaderWriter.writeByte(1L);
        dataL2CAPReaderWriter.writeShort(s);
        dataL2CAPReaderWriter.writeShort((short)n2);
        dataL2CAPReaderWriter.writeShort((short)n);
        dataL2CAPReaderWriter.writeBytes(byArray);
        dataL2CAPReaderWriter.flush();
    }

    private boolean findUUIDs(ServiceRecordImpl serviceRecordImpl, DataElement dataElement) {
        int[] nArray = serviceRecordImpl.getAttributeIDs();
        Enumeration enumeration = (Enumeration)dataElement.getValue();
        block0: while (enumeration.hasMoreElements()) {
            UUID uUID = (UUID)((DataElement)enumeration.nextElement()).getValue();
            for (int i = 0; i < nArray.length; ++i) {
                DataElement dataElement2 = serviceRecordImpl.getAttributeValue(nArray[i]);
                if (this.containsUUID(dataElement2, uUID)) continue block0;
            }
            return false;
        }
        return true;
    }

    private boolean containsUUID(DataElement dataElement, UUID uUID) {
        if (dataElement.getDataType() == 24) {
            return uUID.equals((UUID)dataElement.getValue());
        }
        if (dataElement.getDataType() != 48) {
            return false;
        }
        Enumeration enumeration = (Enumeration)dataElement.getValue();
        while (enumeration.hasMoreElements()) {
            DataElement dataElement2 = (DataElement)enumeration.nextElement();
            if (!this.containsUUID(dataElement2, uUID)) continue;
            return true;
        }
        return false;
    }

    class Sender
    implements Runnable {
        L2CAPConnection connection;
        DataL2CAPReaderWriter readerWriter;

        Sender(L2CAPConnection l2CAPConnection, DataL2CAPReaderWriter dataL2CAPReaderWriter) {
            this.connection = l2CAPConnection;
            this.readerWriter = dataL2CAPReaderWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    SDPServer.this.processRequest(this.readerWriter);
                }
            }
            catch (IOException iOException) {
                SDPServer sDPServer = SDPServer.this;
                synchronized (sDPServer) {
                    SDPServer.this.connections.removeElement(this.connection);
                }
                try {
                    this.connection.close();
                }
                catch (IOException iOException2) {}
                return;
            }
        }
    }

    class Acceptor
    implements Runnable {
        Acceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    L2CAPConnection l2CAPConnection = SDPServer.this.conNotifier.acceptAndOpen();
                    DataL2CAPReaderWriter dataL2CAPReaderWriter = new DataL2CAPReaderWriter(l2CAPConnection);
                    Object object = SDPServer.this;
                    synchronized (object) {
                        SDPServer.this.connections.addElement(l2CAPConnection);
                    }
                    object = new Sender(l2CAPConnection, dataL2CAPReaderWriter);
                    new Thread((Runnable)object).start();
                }
            }
            catch (IOException iOException) {
                SDPServer sDPServer = SDPServer.this;
                synchronized (sDPServer) {
                    SDPServer.this.acceptorStarted = false;
                    SDPServer.this.conNotifier = null;
                }
                return;
            }
        }
    }
}

