/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.bluetooth.DataElement;
import com.sun.kvem.bluetooth.L2CAPConnection;
import com.sun.kvem.bluetooth.UUID;
import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.DataL2CAPReaderWriter;
import com.sun.kvem.jsr082.bluetooth.LocalDeviceImpl;
import com.sun.kvem.jsr082.bluetooth.SDPResponseListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

class SDPClient {
    private static final int MAX_SERVICE_RECORD_COUNT = 4095;
    private static final int MAX_ATTRIBUTE_BYTE_COUNT = 65535;
    private static final int firstTransactionID = 16;
    private static final int maxTransactionID = 65535;
    private static int currentTransactionID = 16;
    private static Hashtable transportsStorage = new Hashtable();
    private static Hashtable counters = new Hashtable();
    private SDPTransport transport;
    private String bluetoothAddress;

    SDPClient() {
    }

    SDPClient(String string) throws IOException {
        this.open(string);
    }

    static synchronized short newTransactionID() {
        int n = currentTransactionID++;
        if (currentTransactionID > 65535) {
            currentTransactionID = 16;
        }
        return (short)n;
    }

    static synchronized void freeTransactionID(short s) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SDPTransport openTransport(String string) throws IOException {
        SDPTransport sDPTransport;
        Hashtable hashtable = transportsStorage;
        synchronized (hashtable) {
            sDPTransport = (SDPTransport)transportsStorage.get(string);
            Counter counter = (Counter)counters.get(string);
            if (sDPTransport == null) {
                sDPTransport = new SDPTransport(string);
                transportsStorage.put(string, sDPTransport);
                counter = new Counter();
                counters.put(string, counter);
            }
            ++counter.counter;
        }
        sDPTransport.start();
        return sDPTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startTransport(String string) throws IOException {
        Hashtable hashtable = transportsStorage;
        synchronized (hashtable) {
            SDPTransport sDPTransport = (SDPTransport)transportsStorage.get(string);
            Counter counter = (Counter)counters.get(string);
            if (sDPTransport == null) {
                throw new IOException("transport is closed");
            }
            ++counter.counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopTransport(String string) throws IOException {
        Hashtable hashtable = transportsStorage;
        synchronized (hashtable) {
            SDPTransport sDPTransport = (SDPTransport)transportsStorage.get(string);
            Counter counter = (Counter)counters.get(string);
            if (sDPTransport == null) {
                throw new IOException("transport is closed");
            }
            --counter.counter;
            if (counter.counter == 0) {
                transportsStorage.remove(string);
                counters.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeTransport(String string) throws IOException {
        SDPTransport sDPTransport;
        Hashtable hashtable = transportsStorage;
        synchronized (hashtable) {
            sDPTransport = (SDPTransport)transportsStorage.get(string);
            Counter counter = (Counter)counters.get(string);
            if (sDPTransport == null) {
                throw new IOException("transport is closed");
            }
            --counter.counter;
            if (counter.counter == 0) {
                transportsStorage.remove(string);
                counters.remove(string);
            }
        }
        sDPTransport.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTransport(String string) {
        Hashtable hashtable = transportsStorage;
        synchronized (hashtable) {
            SDPTransport sDPTransport = (SDPTransport)transportsStorage.remove(string);
            counters.remove(string);
        }
    }

    synchronized void open(String string) throws IOException {
        if (this.bluetoothAddress == null) {
            this.bluetoothAddress = string;
        } else if (!this.bluetoothAddress.equals(string)) {
            throw new IOException("The SDP Connection has been opened with the other bluetooth address");
        }
        this.transport = SDPClient.openTransport(string);
    }

    synchronized void close() throws IOException {
        SDPClient.closeTransport(this.bluetoothAddress);
        this.transport = null;
        this.bluetoothAddress = null;
    }

    void serviceSearchRequest(UUID[] uUIDArray, int n, SDPResponseListener sDPResponseListener) throws IOException {
        try {
            this.transport.serviceSearchRequest(uUIDArray, n, sDPResponseListener);
        }
        catch (IOException iOException) {
            this.transport.cancelAll(65536);
            throw iOException;
        }
    }

    void serviceAttributeRequest(int n, int[] nArray, int n2, SDPResponseListener sDPResponseListener) throws IOException {
        try {
            this.transport.serviceAttributeRequest(n, nArray, n2, sDPResponseListener);
        }
        catch (IOException iOException) {
            this.transport.cancelAll(65536);
            throw iOException;
        }
    }

    void serviceSearchAttributeRequest(int[] nArray, UUID[] uUIDArray, int n, SDPResponseListener sDPResponseListener) throws IOException {
        try {
            this.transport.serviceSearchAttributeRequest(nArray, uUIDArray, n, sDPResponseListener);
        }
        catch (IOException iOException) {
            this.transport.cancelAll(65536);
            throw iOException;
        }
    }

    boolean cancelServiceSearch(int n) {
        return this.transport.cancelServiceSearch(n);
    }

    private static class SDPTransport {
        private String bluetoothAddress;
        private int counter;
        private L2CAPConnection connection;
        private DataL2CAPReaderWriter rw;
        private Hashtable requestListeners;
        private Receiver receiver = new Receiver();
        private Object readLock = new Object();
        private Object writeLock = new Object();
        private static final int SDP_ERROR_RESPONSE = 1;
        private static final int SDP_SERVICE_SEARCH_REQUEST = 2;
        private static final int SDP_SERVICE_SEARCH_RESPONSE = 3;
        private static final int SDP_SERVICE_ATTRIBUTE_REQUEST = 4;
        private static final int SDP_SERVICE_ATTRIBUTE_RESPONSE = 5;
        private static final int SDP_SERVICE_SEARCH_ATTRIBUTE_REQUEST = 6;
        private static final int SDP_SERVICE_SEARCH_ATTRIBUTE_RESPONSE = 7;
        private static final String SDP_L2CAP_URL_BEGIN = "//";
        private static final String SDP_L2CAP_URL_END = ":0001";

        SDPTransport(String string) {
            this.bluetoothAddress = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() throws IOException {
            boolean bl = false;
            SDPTransport sDPTransport = this;
            synchronized (sDPTransport) {
                if (this.counter == 0) {
                    BCC bCC = LocalDeviceImpl.getBCC();
                    this.connection = (L2CAPConnection)bCC.getL2CAPConnection(SDP_L2CAP_URL_BEGIN + this.bluetoothAddress + SDP_L2CAP_URL_END);
                    this.rw = new DataL2CAPReaderWriter(this.connection);
                    this.requestListeners = new Hashtable();
                    this.receiver = new Receiver();
                    bl = true;
                } else if (this.counter < 0) {
                    throw new RuntimeException("Illegal state of SDPTransport");
                }
                ++this.counter;
            }
            if (bl) {
                SDPClient.startTransport(this.bluetoothAddress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws IOException {
            boolean bl = false;
            SDPTransport sDPTransport = this;
            synchronized (sDPTransport) {
                --this.counter;
                if (this.counter == 0) {
                    bl = true;
                    try {
                        this.connection.close();
                        Object var4_3 = null;
                        this.connection = null;
                        this.rw = null;
                        this.requestListeners = null;
                        this.receiver = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        this.connection = null;
                        this.rw = null;
                        this.requestListeners = null;
                        this.receiver = null;
                        throw throwable;
                    }
                } else if (this.counter < 0) {
                    throw new RuntimeException("Illegal state of SDPTransport");
                }
            }
            if (bl) {
                SDPClient.stopTransport(this.bluetoothAddress);
            }
        }

        void startTransaction(int n, SDPResponseListener sDPResponseListener) throws IOException {
            this.start();
            this.receiver.start();
            this.requestListeners.put(new Integer(n), sDPResponseListener);
        }

        void stopTransaction(int n) throws IOException {
            this.requestListeners.remove(new Integer(n));
            this.receiver.stop();
            this.stop();
        }

        boolean cancelTransaction(int n, int n2) {
            SDPResponseListener sDPResponseListener = (SDPResponseListener)this.requestListeners.remove(new Integer(n));
            if (sDPResponseListener == null) {
                return false;
            }
            try {
                this.stopTransaction(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            sDPResponseListener.errorResponse(n2, "", n);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelAll(int n) {
            SDPClient.removeTransport(this.bluetoothAddress);
            Object object = this;
            synchronized (object) {
                if (this.counter == 0) {
                    return;
                }
                this.receiver.cancel();
                try {
                    this.connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Hashtable hashtable = this.requestListeners;
                this.counter = 0;
                this.connection = null;
                this.rw = null;
                this.requestListeners = null;
                this.receiver = null;
            }
            object = this.requestListeners.keys();
            while (object.hasMoreElements()) {
                Object e = object.nextElement();
                int n2 = (Integer)e;
                SDPResponseListener sDPResponseListener = (SDPResponseListener)this.requestListeners.get(e);
                sDPResponseListener.errorResponse(n, "", n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void serviceSearchRequest(UUID[] uUIDArray, int n, SDPResponseListener sDPResponseListener) throws IOException {
            this.startTransaction(n, sDPResponseListener);
            DataElement dataElement = new DataElement(48);
            for (int i = 0; i < uUIDArray.length; ++i) {
                dataElement.addElement(new DataElement(24, uUIDArray[i]));
            }
            long l = this.rw.getDataSize(dataElement) + 3L;
            Object object = this.writeLock;
            synchronized (object) {
                this.rw.writeByte(2L);
                this.rw.writeShort((short)n);
                this.rw.writeShort((short)l);
                this.rw.writeDataElement(dataElement);
                this.rw.writeShort((short)4095);
                this.rw.writeByte(0L);
                this.rw.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void serviceAttributeRequest(int n, int[] nArray, int n2, SDPResponseListener sDPResponseListener) throws IOException {
            this.startTransaction(n2, sDPResponseListener);
            DataElement dataElement = new DataElement(48);
            for (int i = 0; i < nArray.length; ++i) {
                dataElement.addElement(new DataElement(9, nArray[i]));
            }
            long l = this.rw.getDataSize(dataElement) + 7L;
            Object object = this.writeLock;
            synchronized (object) {
                this.rw.writeByte(4L);
                this.rw.writeShort((short)n2);
                this.rw.writeShort((short)l);
                this.rw.writeInteger(n);
                this.rw.writeShort((short)-1);
                this.rw.writeDataElement(dataElement);
                this.rw.writeByte(0L);
                this.rw.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void serviceSearchAttributeRequest(int[] nArray, UUID[] uUIDArray, int n, SDPResponseListener sDPResponseListener) throws IOException {
            int n2;
            this.startTransaction(n, sDPResponseListener);
            DataElement dataElement = new DataElement(48);
            DataElement dataElement2 = new DataElement(48);
            for (n2 = 0; n2 < nArray.length; ++n2) {
                dataElement.addElement(new DataElement(9, nArray[n2]));
            }
            for (n2 = 0; n2 < uUIDArray.length; ++n2) {
                dataElement2.addElement(new DataElement(24, uUIDArray[n2]));
            }
            long l = this.rw.getDataSize(dataElement) + this.rw.getDataSize(dataElement2) + 3L;
            Object object = this.writeLock;
            synchronized (object) {
                this.rw.writeByte(6L);
                this.rw.writeShort((short)n);
                this.rw.writeShort((short)l);
                this.rw.writeDataElement(dataElement2);
                this.rw.writeShort((short)-1);
                this.rw.writeDataElement(dataElement);
                this.rw.writeByte(0L);
                this.rw.flush();
            }
        }

        boolean cancelServiceSearch(int n) {
            return this.cancelTransaction(n, 65537);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processResponse() throws IOException {
            SDPResponseListener sDPResponseListener;
            short s;
            byte by;
            if (this.connection == null || this.rw == null) {
                return;
            }
            if (this.requestListeners == null || this.requestListeners.isEmpty()) {
                return;
            }
            if (!this.connection.ready()) {
                return;
            }
            int[] nArray = null;
            DataElement dataElement = null;
            short s2 = 0;
            byte[] byArray = null;
            Object object = this.readLock;
            synchronized (object) {
                by = this.rw.readByte();
                s = this.rw.readShort();
                short s3 = this.rw.readShort();
                sDPResponseListener = (SDPResponseListener)this.requestListeners.remove(new Integer(s));
                if (sDPResponseListener != null) {
                    this.stopTransaction(s);
                }
                if (by == 3) {
                    nArray = this.readServiceSearchResponse();
                } else if (by == 5) {
                    dataElement = this.readServiceAttributeResponse();
                } else if (by == 7) {
                    dataElement = this.readServiceAttributeResponse();
                } else if (by == 1) {
                    s2 = this.rw.readShort();
                    byArray = this.rw.readBytes(s3 - 2);
                }
            }
            if (by == 3) {
                this.processServiceSearchResponse(nArray, sDPResponseListener, s);
            } else if (by == 5) {
                this.processServiceAttributeResponse(dataElement, sDPResponseListener, s);
            } else if (by == 7) {
                this.processServiceSearchAttributeResponse(dataElement, sDPResponseListener, s);
            } else if (by == 1) {
                this.processErrorResponse(s2, byArray, sDPResponseListener, s);
            } else {
                System.err.println("Unsupported SDP response code (PDU)");
            }
        }

        private void processServiceSearchResponse(int[] nArray, SDPResponseListener sDPResponseListener, short s) throws IOException {
            if (sDPResponseListener != null) {
                sDPResponseListener.serviceSearchResponse(nArray, s);
            }
        }

        private int[] readServiceSearchResponse() throws IOException {
            short s = this.rw.readShort();
            int n = this.rw.readShort();
            int[] nArray = null;
            if (n > 0) {
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = this.rw.readInteger();
                }
            }
            this.rw.readByte();
            return nArray;
        }

        private void processServiceAttributeResponse(DataElement dataElement, SDPResponseListener sDPResponseListener, short s) throws IOException {
            if (sDPResponseListener != null) {
                if (dataElement == null) {
                    sDPResponseListener.serviceAttributeResponse(null, null, s);
                    return;
                }
                int n = dataElement.getSize() / 2;
                if (n == 0) {
                    sDPResponseListener.serviceAttributeResponse(null, null, s);
                    return;
                }
                Enumeration enumeration = (Enumeration)dataElement.getValue();
                int[] nArray = new int[n];
                DataElement[] dataElementArray = new DataElement[n];
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    nArray[n2] = (int)((DataElement)enumeration.nextElement()).getLong();
                    dataElementArray[n2] = (DataElement)enumeration.nextElement();
                    ++n2;
                }
                sDPResponseListener.serviceAttributeResponse(nArray, dataElementArray, s);
            }
        }

        private void processServiceSearchAttributeResponse(DataElement dataElement, SDPResponseListener sDPResponseListener, short s) throws IOException {
            if (sDPResponseListener != null) {
                if (dataElement == null) {
                    sDPResponseListener.serviceSearchAttributeResponse(null, null, s);
                    return;
                }
                int n = dataElement.getSize() / 2;
                if (n == 0) {
                    sDPResponseListener.serviceSearchAttributeResponse(null, null, s);
                    return;
                }
                Enumeration enumeration = (Enumeration)dataElement.getValue();
                int[] nArray = new int[n];
                DataElement[] dataElementArray = new DataElement[n];
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    nArray[n2] = (int)((DataElement)enumeration.nextElement()).getLong();
                    dataElementArray[n2] = (DataElement)enumeration.nextElement();
                    ++n2;
                }
                sDPResponseListener.serviceSearchAttributeResponse(nArray, dataElementArray, s);
            }
        }

        private DataElement readServiceAttributeResponse() throws IOException {
            short s = this.rw.readShort();
            if (s < 2) {
                return null;
            }
            DataElement dataElement = this.rw.readDataElement();
            this.rw.readByte();
            return dataElement;
        }

        private void processErrorResponse(short s, byte[] byArray, SDPResponseListener sDPResponseListener, short s2) throws IOException {
            if (sDPResponseListener != null) {
                String string = new String(byArray);
                sDPResponseListener.errorResponse(s, string, s2);
            }
        }

        private class Receiver
        implements Runnable {
            private int startCounter = 0;
            private boolean canceled = false;
            private boolean stoped = true;

            private Receiver() {
            }

            synchronized void start() {
                if (this.startCounter == 0 && this.stoped) {
                    this.stoped = false;
                    new Thread(this).start();
                }
                ++this.startCounter;
            }

            synchronized void stop() {
                --this.startCounter;
            }

            synchronized void cancel() {
                this.canceled = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Object var1_1 = null;
                    Receiver receiver = this;
                    synchronized (receiver) {
                        if (this.startCounter <= 0 || this.canceled) {
                            this.startCounter = 0;
                            this.stoped = true;
                            break;
                        }
                    }
                    try {
                        SDPTransport.this.processResponse();
                    }
                    catch (IOException iOException) {
                        Receiver receiver2 = this;
                        synchronized (receiver2) {
                            if (this.startCounter <= 0 || this.canceled) {
                                this.startCounter = 0;
                                this.stoped = true;
                                break;
                            }
                        }
                        SDPTransport.this.cancelAll(65536);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    private static class Counter {
        int counter;

        private Counter() {
        }
    }
}

