/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.SDPServer;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import java.util.Enumeration;
import java.util.Hashtable;

public final class SDDBImpl {
    private static final boolean DEBUG = false;
    private static SDDBImpl sddbInstance;
    private static int freeHandle;
    private Hashtable recordStorage;
    private SDPServer server;
    private BCC control;
    private boolean isInitialized;

    public static synchronized SDDBImpl getSDDBInstance() {
        if (!SDDBImpl.sddbInstance.isInitialized) {
            sddbInstance.init();
            SDDBImpl.sddbInstance.isInitialized = true;
        }
        return sddbInstance;
    }

    SDDBImpl(BCC bCC) {
        this.control = bCC;
        sddbInstance = this;
    }

    private void init() {
        this.recordStorage = new Hashtable();
        this.server = new SDPServer(this);
        this.server.start();
    }

    public static synchronized int getFreeID() {
        return freeHandle++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceRecord(ServiceRecordImpl serviceRecordImpl) {
        int n = serviceRecordImpl.getHandle();
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            this.recordStorage.put(new Integer(n), serviceRecordImpl);
        }
        this.control.updateDeviceClass(this.getDeviceClasses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceRecord(ServiceRecordImpl serviceRecordImpl) {
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            int n = serviceRecordImpl.getHandle();
            this.recordStorage.remove(new Integer(n));
        }
        this.control.updateDeviceClass(this.getDeviceClasses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getHandles() {
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            int n = 0;
            int n2 = this.recordStorage.size();
            int[] nArray = new int[n2];
            Enumeration enumeration = this.recordStorage.elements();
            while (enumeration.hasMoreElements()) {
                ServiceRecordImpl serviceRecordImpl = (ServiceRecordImpl)enumeration.nextElement();
                nArray[n] = serviceRecordImpl.getHandle();
                ++n;
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceRecordImpl getServiceRecord(int n) {
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            return (ServiceRecordImpl)this.recordStorage.get(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDeviceClasses() {
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            int n = 0;
            Enumeration enumeration = this.recordStorage.elements();
            while (enumeration.hasMoreElements()) {
                ServiceRecordImpl serviceRecordImpl = (ServiceRecordImpl)enumeration.nextElement();
                n |= serviceRecordImpl.getDeviceServiceClasses();
            }
            return n;
        }
    }
}

