/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.bluetooth.RemoteDevice;
import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.BluetoothConnection;
import com.sun.kvem.jsr082.bluetooth.LocalDeviceImpl;
import com.sun.kvem.jsr082.obex.ObexPacketStream;
import java.io.IOException;
import javax.microedition.io.Connection;

public final class RemoteDeviceImpl
extends RemoteDevice {
    private BCC bcc = LocalDeviceImpl.getBCC();
    private String friendlyName;

    RemoteDeviceImpl(String string) {
        super(string);
    }

    public static RemoteDevice getRemoteDevice(Connection connection) throws IOException {
        if (connection == null) {
            throw new NullPointerException("null connection");
        }
        BluetoothConnection bluetoothConnection = RemoteDeviceImpl.getBluetoothConnection(connection);
        return bluetoothConnection.getRemoteDevice();
    }

    public String getFriendlyName(boolean bl) throws IOException {
        if (this.friendlyName == null || bl) {
            this.friendlyName = this.bcc.getFriendlyName(this);
        }
        return this.friendlyName;
    }

    public boolean isTrustedDevice() {
        return this.bcc.isTrustedDevice(this);
    }

    public boolean authenticate() throws IOException {
        return this.bcc.authenticate(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorize(Connection connection) throws IOException {
        BluetoothConnection bluetoothConnection = RemoteDeviceImpl.getBluetoothConnection(connection);
        RemoteDeviceImpl remoteDeviceImpl = bluetoothConnection.getRemoteDevice();
        if (!this.equals(remoteDeviceImpl)) {
            throw new IllegalArgumentException("connection to other device");
        }
        if (!bluetoothConnection.isServerSide()) {
            throw new IllegalArgumentException("not server side");
        }
        Connection connection2 = connection;
        synchronized (connection2) {
            boolean bl;
            boolean bl2 = bluetoothConnection.isAuthorized();
            if (bl2) {
                return true;
            }
            bl2 = this.isTrustedDevice() ? true : this.bcc.authorize(this, bluetoothConnection);
            if (bl2 && !this.isAuthenticated() && !(bl = this.authenticate())) {
                return false;
            }
            if (bl2) {
                bluetoothConnection.setAuthorized();
            }
            return bl2;
        }
    }

    public boolean encrypt(Connection connection, boolean bl) throws IOException {
        BluetoothConnection bluetoothConnection = RemoteDeviceImpl.getBluetoothConnection(connection);
        RemoteDeviceImpl remoteDeviceImpl = bluetoothConnection.getRemoteDevice();
        if (!this.equals(remoteDeviceImpl)) {
            throw new IllegalArgumentException("connection to other device");
        }
        return this.bcc.encrypt(this, bluetoothConnection, bl);
    }

    public boolean isAuthorized(Connection connection) throws IOException {
        RemoteDeviceImpl remoteDeviceImpl;
        BluetoothConnection bluetoothConnection = RemoteDeviceImpl.getBluetoothConnection(connection);
        try {
            remoteDeviceImpl = bluetoothConnection.getRemoteDevice();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (!this.equals(remoteDeviceImpl)) {
            throw new IllegalArgumentException("connection to other device");
        }
        return bluetoothConnection.isAuthorized();
    }

    public boolean isAuthenticated() {
        return this.bcc.isAuthenticated(this);
    }

    public boolean isEncrypted() {
        return this.bcc.isEncrypted(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("RemoteDevice[");
        stringBuffer.append("address=").append(this.getBluetoothAddress());
        stringBuffer.append(", name=").append((String)null);
        stringBuffer.append(", encrypted=").append(this.isEncrypted());
        stringBuffer.append(", authenticated=").append(this.isAuthenticated());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static BluetoothConnection getBluetoothConnection(Connection connection) {
        if (!(connection instanceof BluetoothConnection)) {
            if (!(connection instanceof ObexPacketStream)) {
                if (connection == null) {
                    throw new NullPointerException("null connection");
                }
                throw new IllegalArgumentException("not bluetooth connection");
            }
            Connection connection2 = ((ObexPacketStream)connection).getTransport();
            if (!(connection2 instanceof BluetoothConnection)) {
                throw new IllegalArgumentException("not bluetooth connection");
            }
            return (BluetoothConnection)connection2;
        }
        return (BluetoothConnection)connection;
    }
}

