/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.bluetooth.BluetoothStateException;
import com.sun.kvem.bluetooth.DeviceClass;
import com.sun.kvem.bluetooth.LocalDevice;
import com.sun.kvem.bluetooth.ServiceRecord;
import com.sun.kvem.bluetooth.ServiceRegistrationException;
import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.BCCNameWrapper;
import com.sun.kvem.jsr082.bluetooth.BluetoothNotifier;
import com.sun.kvem.jsr082.bluetooth.DiscoveryAgentImpl;
import com.sun.kvem.jsr082.bluetooth.SDDBImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import com.sun.kvem.jsr082.obex.SessionNotifierImpl;
import java.util.Hashtable;
import javax.microedition.io.Connection;

public final class LocalDeviceImpl {
    private static BCC bcc;
    private static final boolean DEBUG = false;
    private static boolean isInitialized;
    private DiscoveryAgentImpl discoveryAgentImpl;
    private String bluetoothAddress;
    private Hashtable ldProperties;
    private CancelerOfLIAC cancelerOfLIAC = new CancelerOfLIAC();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDeviceImpl(LocalDevice localDevice) throws BluetoothStateException {
        Class clazz = LocalDeviceImpl.class;
        synchronized (clazz) {
            if (isInitialized) {
                throw new RuntimeException("Already initialized");
            }
            if (localDevice == null || localDevice.getClass() != LocalDevice.class) {
                throw new RuntimeException("Can't call to this <init>");
            }
            try {
                String string = BCCNameWrapper.getBBCImplClassName();
                Class<?> clazz2 = Class.forName(string);
                bcc = (BCC)clazz2.newInstance();
                bcc.initialize();
                this.bluetoothAddress = bcc.getBluetoothAddress();
                this.ldProperties = bcc.getProperties();
                bcc.getFriendlyName();
                bcc.getDeviceClass();
                bcc.getDiscoverable();
                this.discoveryAgentImpl = DiscoveryAgentImpl.getInstance(bcc);
                bcc.setDiscoveryAgent(this.discoveryAgentImpl);
                new SDDBImpl(bcc);
            }
            catch (Throwable throwable) {
                bcc = null;
                throw new BluetoothStateException(throwable.getMessage());
            }
            isInitialized = true;
        }
    }

    public String getFriendlyName() {
        return bcc.getFriendlyName();
    }

    public DeviceClass getDeviceClass() {
        return bcc.getDeviceClass();
    }

    public String getProperty(String string) {
        return this.ldProperties != null ? (String)this.ldProperties.get(string) : null;
    }

    public int getDiscoverable() {
        return bcc.getDiscoverable();
    }

    static BCC getBCC() {
        return bcc;
    }

    public String getBluetoothAddress() {
        return this.bluetoothAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDiscoverable(int n) throws BluetoothStateException {
        if (n != 10390323 && n != 10390272 && n != 0 && (n < 10390272 || n > 10390335)) {
            throw new IllegalArgumentException("Access code is out of range: " + n);
        }
        boolean bl = false;
        CancelerOfLIAC cancelerOfLIAC = this.cancelerOfLIAC;
        synchronized (cancelerOfLIAC) {
            bl = bcc.setBTDeviceAccessCode(n);
            if (bl) {
                this.cancelerOfLIAC.notifyNewAccessCode(n);
            }
        }
        if (bl && n != 0) {
            SDDBImpl.getSDDBInstance();
        }
        return bl;
    }

    public ServiceRecord getRecord(Connection connection) {
        if (connection == null) {
            throw new NullPointerException("notifier is null");
        }
        if (!(connection instanceof BluetoothNotifier)) {
            if (!(connection instanceof SessionNotifierImpl)) {
                throw new IllegalArgumentException("not bluetooth notifier");
            }
            Connection connection2 = ((SessionNotifierImpl)connection).getTransport();
            if (!(connection2 instanceof BluetoothNotifier)) {
                throw new IllegalArgumentException("not bluetooth notifier");
            }
            return ((BluetoothNotifier)connection2).getServiceRecord();
        }
        BluetoothNotifier bluetoothNotifier = (BluetoothNotifier)connection;
        return bluetoothNotifier.getServiceRecord();
    }

    public void updateRecord(ServiceRecord serviceRecord) throws ServiceRegistrationException {
        if (serviceRecord == null) {
            throw new NullPointerException("notifier is null");
        }
        if (!(serviceRecord instanceof ServiceRecordImpl)) {
            throw new IllegalArgumentException("wrong service record");
        }
        ServiceRecordImpl serviceRecordImpl = (ServiceRecordImpl)serviceRecord;
        BluetoothNotifier bluetoothNotifier = serviceRecordImpl.getNotifier();
        if (bluetoothNotifier == null) {
            throw new IllegalArgumentException("remote device service record");
        }
        bluetoothNotifier.updateServiceRecord();
    }

    private class CancelerOfLIAC
    implements Runnable {
        private long MINUTE = 60000L;
        private int RETRY_DELAY = 100;
        private int currentCode = 10390323;
        private int savedCode;
        private long start_time = -1L;
        private boolean isCanceledFromOutside = true;

        private CancelerOfLIAC() {
        }

        synchronized void notifyNewAccessCode(int n) {
            if (n == this.currentCode) {
                return;
            }
            this.savedCode = this.currentCode;
            this.currentCode = n;
            if (n == 10390272) {
                this.start_time = System.currentTimeMillis();
                new Thread(this).start();
            } else {
                boolean bl = this.start_time != -1L && this.isCanceledFromOutside;
                this.start_time = -1L;
                this.isCanceledFromOutside = false;
                if (bl) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.RETRY_DELAY);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CancelerOfLIAC cancelerOfLIAC = this;
                synchronized (cancelerOfLIAC) {
                    if (this.start_time == -1L) {
                        this.notify();
                        return;
                    }
                    if (System.currentTimeMillis() - this.start_time < this.MINUTE) {
                        continue;
                    }
                    this.isCanceledFromOutside = false;
                    boolean bl = false;
                    try {
                        bl = LocalDeviceImpl.this.setDiscoverable(this.savedCode);
                    }
                    catch (BluetoothStateException bluetoothStateException) {
                        // empty catch block
                    }
                    if (bl) {
                        return;
                    }
                    this.isCanceledFromOutside = true;
                }
            }
        }
    }
}

