/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.bluetooth.BluetoothStateException;
import com.sun.kvem.bluetooth.DiscoveryAgent;
import com.sun.kvem.bluetooth.DiscoveryListener;
import com.sun.kvem.bluetooth.RemoteDevice;
import com.sun.kvem.bluetooth.UUID;
import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.RemoteDeviceImpl;
import com.sun.kvem.jsr082.bluetooth.SelectServiceHandler;
import com.sun.kvem.jsr082.bluetooth.ServiceSearcher;
import java.util.Enumeration;
import java.util.Hashtable;

public final class DiscoveryAgentImpl {
    private static final boolean DEBUG = false;
    private static DiscoveryAgentImpl instance;
    private static BCC bcc;
    private Hashtable cachedDevices = new Hashtable();
    private DiscoveryListener d_listener;
    private Object d_lock = new Object();
    private SelectServiceHandler selectServiceHandler = new SelectServiceHandler(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryAgentImpl(DiscoveryAgent discoveryAgent) {
        Class clazz = DiscoveryAgentImpl.class;
        synchronized (clazz) {
            if (instance != null) {
                throw new RuntimeException("Already initialized");
            }
            if (discoveryAgent == null || discoveryAgent.getClass() != DiscoveryAgent.class) {
                throw new IllegalArgumentException("Illegal 'parent'");
            }
            instance = this;
        }
    }

    public RemoteDevice[] retrieveDevices(int n) {
        RemoteDevice[] remoteDeviceArray = null;
        switch (n) {
            case 0: {
                if (this.cachedDevices.size() == 0) break;
                remoteDeviceArray = new RemoteDevice[this.cachedDevices.size()];
                int n2 = 0;
                Enumeration enumeration = this.cachedDevices.elements();
                while (enumeration.hasMoreElements()) {
                    remoteDeviceArray[n2] = (RemoteDevice)enumeration.nextElement();
                    ++n2;
                }
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid 'option' value: " + n);
            }
        }
        return remoteDeviceArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startInquiry(int n, DiscoveryListener discoveryListener) throws BluetoothStateException {
        if (n != 10390323 && n != 10390272 && (n < 10390272 || n > 10390335)) {
            throw new IllegalArgumentException("Access code is out of range: " + n);
        }
        if (discoveryListener == null) {
            throw new NullPointerException("null listener");
        }
        Object object = this.d_lock;
        synchronized (object) {
            if (this.d_listener != null) {
                throw new BluetoothStateException("The previous device discovery is running...");
            }
            this.d_listener = discoveryListener;
            bcc.startInquiry(this, discoveryListener, n);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelInquiry(DiscoveryListener discoveryListener) {
        if (discoveryListener == null) {
            throw new NullPointerException("null listener");
        }
        Object object = this.d_lock;
        synchronized (object) {
            if (this.d_listener == null) {
                return false;
            }
            if (this.d_listener != discoveryListener) {
                return false;
            }
            bcc.cancelInquiry();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted() {
        Object object = this.d_lock;
        synchronized (object) {
            this.d_listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteDeviceImpl getRemoteDevice(String string) {
        Hashtable hashtable = this.cachedDevices;
        synchronized (hashtable) {
            RemoteDeviceImpl remoteDeviceImpl = (RemoteDeviceImpl)this.cachedDevices.get(string);
            if (remoteDeviceImpl == null) {
                remoteDeviceImpl = new RemoteDeviceImpl(string);
                this.cachedDevices.put(string, remoteDeviceImpl);
            }
            return remoteDeviceImpl;
        }
    }

    public int searchServices(int[] nArray, UUID[] uUIDArray, RemoteDevice remoteDevice, DiscoveryListener discoveryListener) throws BluetoothStateException {
        ServiceSearcher serviceSearcher = new ServiceSearcher(nArray, uUIDArray, remoteDevice, discoveryListener);
        int n = serviceSearcher.start();
        return n;
    }

    public boolean cancelServiceSearch(int n) {
        return ServiceSearcher.cancel(n);
    }

    public String selectService(UUID uUID, int n, boolean bl) throws BluetoothStateException {
        return this.selectServiceHandler.selectService(uUID, n, bl);
    }

    static DiscoveryAgentImpl getInstance(BCC bCC) {
        bcc = bCC;
        return instance;
    }
}

