/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.bluetooth.DataElement;
import com.sun.kvem.bluetooth.L2CAPConnection;
import com.sun.kvem.bluetooth.UUID;
import java.io.IOException;
import java.util.Enumeration;

class DataL2CAPReaderWriter {
    private static final byte NULL_DATA = 0;
    private static final byte BOOLEAN_DATA = 40;
    private static final byte INT1_SIGNED = 16;
    private static final byte INT2_SIGNED = 17;
    private static final byte INT4_SIGNED = 18;
    private static final byte INT8_SIGNED = 19;
    private static final byte INT16_SIGNED = 20;
    private static final byte INT1_UNSIGNED = 8;
    private static final byte INT2_UNSIGNED = 9;
    private static final byte INT4_UNSIGNED = 10;
    private static final byte INT8_UNSIGNED = 11;
    private static final byte INT16_UNSIGNED = 12;
    private static final byte UUID_2 = 25;
    private static final byte UUID_4 = 26;
    private static final byte UUID_16 = 28;
    private static final byte TYPE_MASK = -8;
    private static final byte SIZE_MASK = 7;
    private static final byte SEQUENCE_TYPE = 48;
    private static final byte ALTERNATIVE_TYPE = 56;
    private static final byte STRING_TYPE = 64;
    private static final byte SHORT_SIZE = 5;
    private static final byte NORMAL_SIZE = 6;
    private static final byte LONG_SIZE = 7;
    private L2CAPConnection con = null;
    private byte[] writeBuffer = null;
    private long writePos = 0L;
    private byte[] readBuffer = null;
    private long readSize = 0L;
    private long readPos = 0L;

    DataL2CAPReaderWriter(L2CAPConnection l2CAPConnection) throws IOException {
        this.con = l2CAPConnection;
        this.writeBuffer = new byte[l2CAPConnection.getTransmitMTU()];
        this.readBuffer = new byte[l2CAPConnection.getReceiveMTU()];
    }

    long getDataSize(DataElement dataElement) {
        int n = dataElement.getDataType();
        long l = this.getPureDataSize(dataElement);
        if (n == 0 || n == 40 || n == 16 || n == 8 || n == 17 || n == 9 || n == 18 || n == 10 || n == 19 || n == 11 || n == 20 || n == 12) {
            return l + 1L;
        }
        if (n == 48 || n == 56 || n == 32 || n == 64 || n == 24) {
            if (l <= 255L) {
                return l + 2L;
            }
            if (l <= 65535L) {
                return l + 3L;
            }
            if (l <= 0xFFFFFFFFL) {
                return l + 5L;
            }
            throw new RuntimeException("Unexpected too large size.");
        }
        throw new RuntimeException("Unexpected Data Type");
    }

    long getPureDataSize(DataElement dataElement) {
        switch (dataElement.getDataType()) {
            case 0: {
                return 0L;
            }
            case 8: 
            case 16: 
            case 40: {
                return 1L;
            }
            case 9: 
            case 17: {
                return 2L;
            }
            case 10: 
            case 18: {
                return 4L;
            }
            case 11: 
            case 19: {
                return 8L;
            }
            case 12: 
            case 20: {
                return 16L;
            }
            case 48: 
            case 56: {
                long l = 0L;
                Enumeration enumeration = (Enumeration)dataElement.getValue();
                while (enumeration.hasMoreElements()) {
                    l += this.getDataSize((DataElement)enumeration.nextElement());
                }
                return l;
            }
            case 32: 
            case 64: {
                return ((String)dataElement.getValue()).length();
            }
            case 24: {
                return ((UUID)dataElement.getValue()).toString().length();
            }
        }
        throw new RuntimeException("Unexpected Data Type");
    }

    void writeDataElement(DataElement dataElement) throws IOException {
        long l = this.getPureDataSize(dataElement);
        int n = dataElement.getDataType();
        int n2 = 0;
        if (n == 0 || n == 40 || n == 16 || n == 8 || n == 17 || n == 9 || n == 18 || n == 10 || n == 19 || n == 11 || n == 20 || n == 12) {
            switch (n) {
                case 0: {
                    this.writeByte(0L);
                    break;
                }
                case 40: {
                    this.writeByte(40L);
                    this.writeBoolean(dataElement.getBoolean());
                    break;
                }
                case 16: {
                    this.writeByte(16L);
                    this.writeByte((byte)dataElement.getLong());
                    break;
                }
                case 8: {
                    this.writeByte(8L);
                    this.writeByte((byte)dataElement.getLong());
                    break;
                }
                case 17: {
                    this.writeByte(17L);
                    this.writeShort((short)dataElement.getLong());
                    break;
                }
                case 9: {
                    this.writeByte(9L);
                    this.writeShort((short)dataElement.getLong());
                    break;
                }
                case 18: {
                    this.writeByte(18L);
                    this.writeInteger((int)dataElement.getLong());
                    break;
                }
                case 10: {
                    this.writeByte(10L);
                    this.writeInteger((int)dataElement.getLong());
                    break;
                }
                case 19: {
                    this.writeByte(19L);
                    this.writeLong(dataElement.getLong());
                    break;
                }
                case 11: {
                    this.writeByte(11L);
                    this.writeBytes((byte[])dataElement.getValue());
                    break;
                }
                case 20: {
                    this.writeByte(20L);
                    this.writeBytes((byte[])dataElement.getValue());
                    break;
                }
                case 12: {
                    this.writeByte(12L);
                    this.writeBytes((byte[])dataElement.getValue());
                }
            }
        } else if (n == 48 || n == 56 || n == 32 || n == 64) {
            switch (n) {
                case 48: {
                    n2 = 48;
                    break;
                }
                case 56: {
                    n2 = 56;
                    break;
                }
                case 32: 
                case 64: {
                    n2 = 64;
                    break;
                }
            }
            if (l <= 255L) {
                this.writeByte(n2 | 5);
                this.writeByte((byte)l);
            } else if (l <= 65535L) {
                this.writeByte(n2 | 6);
                this.writeShort((short)l);
            } else {
                this.writeByte(n2 | 7);
                this.writeInteger((int)l);
            }
            if (n == 48 || n == 56) {
                Enumeration enumeration = (Enumeration)dataElement.getValue();
                while (enumeration.hasMoreElements()) {
                    this.writeDataElement((DataElement)enumeration.nextElement());
                }
            } else {
                this.writeBytes(((String)dataElement.getValue()).getBytes());
            }
        } else if (n == 24) {
            this.writeByte(28L);
            this.writeByte(l);
            this.writeBytes(dataElement.getValue().toString().getBytes());
        } else {
            throw new RuntimeException("Unexpected Data Type");
        }
    }

    void writeBoolean(boolean bl) throws IOException {
        this.writeByte(bl ? 1L : 0L);
    }

    void writeByte(long l) throws IOException {
        if (this.writePos < 0L || this.writePos >= (long)this.writeBuffer.length) {
            throw new IndexOutOfBoundsException();
        }
        this.writeBuffer[(int)this.writePos] = (byte)l;
        ++this.writePos;
        if (this.writePos == (long)this.writeBuffer.length) {
            this.con.send(this.writeBuffer);
            this.writePos = 0L;
        }
    }

    void writeShort(short s) throws IOException {
        this.writeByte((byte)(s >>> 8 & 0xFF));
        this.writeByte((byte)(s >>> 0 & 0xFF));
    }

    void writeInteger(int n) throws IOException {
        this.writeShort((short)(n >>> 16 & 0xFFFF));
        this.writeShort((short)(n >>> 0 & 0xFFFF));
    }

    void writeLong(long l) throws IOException {
        this.writeInteger((int)(l >>> 32 & 0xFFFFFFFFFFFFFFFFL));
        this.writeInteger((int)(l >>> 0 & 0xFFFFFFFFFFFFFFFFL));
    }

    void writeBytes(byte[] byArray) throws IOException {
        int n;
        if (this.writePos < 0L || this.writePos >= (long)this.writeBuffer.length) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = 0;
        while ((long)(byArray.length - n2) >= (long)this.writeBuffer.length - this.writePos) {
            n = this.writeBuffer.length - (int)this.writePos;
            System.arraycopy(byArray, n2, this.writeBuffer, (int)this.writePos, n);
            this.con.send(this.writeBuffer);
            this.writePos = 0L;
            n2 += n;
        }
        n = byArray.length - n2;
        if (n > 0) {
            System.arraycopy(byArray, n2, this.writeBuffer, (int)this.writePos, n);
        }
        this.writePos += (long)n;
    }

    void flush() throws IOException {
        if (this.writePos < 0L || this.writePos >= (long)this.writeBuffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.writePos == 0L) {
            return;
        }
        byte[] byArray = new byte[(int)this.writePos];
        System.arraycopy(this.writeBuffer, 0, byArray, 0, (int)this.writePos);
        this.con.send(byArray);
        this.writePos = 0L;
    }

    DataElement readDataElement() throws IOException {
        byte by = this.readByte();
        if (by == 0 || by == 40 || by == 16 || by == 8 || by == 17 || by == 9 || by == 18 || by == 10 || by == 19 || by == 11 || by == 20 || by == 12) {
            switch (by) {
                case 0: {
                    return new DataElement(0);
                }
                case 40: {
                    return new DataElement(this.readBoolean());
                }
                case 16: {
                    return new DataElement(16, this.readByte());
                }
                case 8: {
                    return new DataElement(8, (long)this.readByte() & 0xFFL);
                }
                case 17: {
                    return new DataElement(17, this.readShort());
                }
                case 9: {
                    return new DataElement(9, (long)this.readShort() & 0xFFFFL);
                }
                case 18: {
                    return new DataElement(18, this.readInteger());
                }
                case 10: {
                    return new DataElement(10, (long)this.readInteger() & 0xFFFFFFFFL);
                }
                case 19: {
                    return new DataElement(19, this.readLong());
                }
                case 11: {
                    return new DataElement(11, this.readBytes(8));
                }
                case 20: {
                    return new DataElement(20, this.readBytes(16));
                }
                case 12: {
                    return new DataElement(12, this.readBytes(16));
                }
            }
        } else {
            if ((by & 0xFFFFFFF8) == 64 || (by & 0xFFFFFFF8) == 48 || (by & 0xFFFFFFF8) == 56) {
                long l = 0L;
                if ((by & 7) == 5) {
                    l = (long)this.readByte() & 0xFFL;
                } else if ((by & 7) == 6) {
                    l = (long)this.readShort() & 0xFFFFL;
                } else if ((by & 7) == 7) {
                    l = (long)this.readInteger() & 0xFFFFFFFFL;
                } else {
                    System.err.println("Unknown Size Mask");
                }
                if ((by & 0xFFFFFFF8) == 64) {
                    return new DataElement(32, new String(this.readBytes((int)l)));
                }
                DataElement dataElement = null;
                DataElement dataElement2 = null;
                dataElement = (by & 0xFFFFFFF8) == 48 ? new DataElement(48) : new DataElement(56);
                for (long i = 0L; i < l; i += this.getDataSize(dataElement2)) {
                    dataElement2 = this.readDataElement();
                    dataElement.addElement(dataElement2);
                }
                return dataElement;
            }
            if (by == 28) {
                int n = this.readByte() & 0xFF;
                String string = new String(this.readBytes(n));
                UUID uUID = new UUID(string, false);
                return new DataElement(24, uUID);
            }
            throw new RuntimeException("Unknown Data Type");
        }
        return null;
    }

    boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    byte readByte() throws IOException {
        if (this.readPos == 0L || this.readPos == this.readSize) {
            this.readSize = this.con.receive(this.readBuffer);
            this.readPos = 0L;
        } else if (this.readPos < 0L || this.readPos > this.readSize) {
            throw new IndexOutOfBoundsException();
        }
        byte by = this.readBuffer[(int)this.readPos];
        ++this.readPos;
        return by;
    }

    short readShort() throws IOException {
        int n = this.readByte() & 0xFF;
        int n2 = this.readByte() & 0xFF;
        return (short)((n << 8) + (n2 << 0));
    }

    int readInteger() throws IOException {
        int n = this.readShort() & 0xFFFF;
        int n2 = this.readShort() & 0xFFFF;
        return (n << 16) + (n2 << 0);
    }

    long readLong() throws IOException {
        long l = (long)this.readInteger() & 0xFFFFFFFFL;
        long l2 = (long)this.readInteger() & 0xFFFFFFFFL;
        return (l << 32) + (l2 << 0);
    }

    byte[] readBytes(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        if (this.readPos == 0L || this.readPos == this.readSize) {
            this.readSize = this.con.receive(this.readBuffer);
            this.readPos = 0L;
        } else if (this.readPos < 0L || this.readPos > this.readSize) {
            throw new IndexOutOfBoundsException();
        }
        while ((long)(byArray.length - n3) > this.readSize - this.readPos) {
            n2 = (int)(this.readSize - this.readPos);
            System.arraycopy(this.readBuffer, (int)this.readPos, byArray, n3, n2);
            this.readSize = this.con.receive(this.readBuffer);
            this.readPos = 0L;
        }
        n2 = byArray.length - n3;
        System.arraycopy(this.readBuffer, (int)this.readPos, byArray, n3, n2);
        this.readPos += (long)n2;
        return byArray;
    }
}

