/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.extension.modules;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.extension.ExtensionModuleManager;
import com.sun.kvem.extension.modules.SimpleExtension;
import com.sun.kvem.preferences.EditableProperty;
import com.sun.kvem.preferences.NumberProperty;
import com.sun.kvem.preferences.SimplePhoneNumberProperty;
import com.sun.kvem.preferences.SliderProperty;
import com.sun.kvem.util.ResourceLabel;
import com.sun.kvem.util.TableLayout;
import com.sun.kvem.util.ToolkitResources;
import com.sun.kvem.wma.WMAConsole;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class WMAExtension
extends SimpleExtension {
    private static final Debug debug = Debug.create((Class)WMAExtension.class);
    private static EditableProperty[] properties = null;

    public WMAExtension(ExtensionModuleManager extensionModuleManager) {
        super(extensionModuleManager);
        this.addUtility(ToolkitResources.getString((String)"WMA_OPEN_CONSOLE"), "runConsole", ToolkitResources.getString((String)"WMA_CONSOLE_SHORTCUT"));
    }

    public String getName() {
        return "WMA Extension";
    }

    public String getLabel() {
        return ToolkitResources.getString((String)"WMA_EXT_LABEL");
    }

    protected String getBorderTitle() {
        return ToolkitResources.getString((String)"WMA_BORDER_TITLE");
    }

    public int getMnemonic() {
        return ToolkitResources.getString((String)"WMA_EXT_LABEL_SHORTCUT").charAt(0);
    }

    public String getDescription() {
        return "Send WMA messages";
    }

    protected synchronized EditableProperty[] createPropertyEditors(Properties properties) {
        if (WMAExtension.properties == null) {
            WMAExtension.properties = new EditableProperty[]{new SimplePhoneNumberProperty(properties, "", "wma.client.phoneNumber", 16), new SimplePhoneNumberProperty(properties, "", "wma.server.firstAssignedPhoneNumber", 16), new SliderProperty(properties, ToolkitResources.getString((String)"WMA_EXT_SERVER_PCT_PACKET_LOSS"), "wma.server.percentFragmentLoss"), new NumberProperty(properties, ToolkitResources.getString((String)"WMA_EXT_SERVER_DELIVERY_DELAY"), "wma.server.deliveryDelayMS", 9, 0, Integer.MAX_VALUE)};
        }
        return WMAExtension.properties;
    }

    protected void createGUI(Container container, EditableProperty[] editablePropertyArray) {
        JPanel jPanel = new JPanel();
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setColumnWidth(0, 0);
        tableLayout.setColumnWidth(1, 1);
        tableLayout.setInsets(new Insets(0, 2, 0, 2));
        tableLayout.setRowInsets(0, new Insets(0, 2, 12, 2));
        tableLayout.setRowInsets(1, new Insets(0, 2, 12, 2));
        tableLayout.setRowInsets(2, new Insets(0, 2, 12, 2));
        jPanel.setLayout((LayoutManager)tableLayout);
        jPanel.add((Component)new ResourceLabel("WMA_EXT_CLIENT_PHONE_NUMBER"));
        jPanel.add(editablePropertyArray[0].createUI());
        jPanel.add((Component)new ResourceLabel("WMA_EXT_SERVER_FIRST_PHONE_NUMBER"));
        jPanel.add(editablePropertyArray[1].createUI());
        container.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        final JSlider jSlider = (JSlider)((SliderProperty)editablePropertyArray[2]).getComponent();
        jSlider.setMajorTickSpacing(20);
        jSlider.setMinorTickSpacing(5);
        jSlider.setLabelTable(jSlider.createStandardLabels(20));
        jSlider.setPaintLabels(true);
        jSlider.setPaintTicks(true);
        jSlider.setSnapToTicks(true);
        jSlider.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 39: 
                    case 227: {
                        jSlider.setValue(jSlider.getValue() + 5);
                        break;
                    }
                    case 37: 
                    case 226: {
                        jSlider.setValue(jSlider.getValue() - 5);
                        break;
                    }
                }
            }
        });
        jPanel2.add(editablePropertyArray[2].createUI());
        jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
        JComponent jComponent = (JComponent)editablePropertyArray[3].createUI();
        Dimension dimension = jComponent.getPreferredSize();
        jComponent.setMaximumSize(new Dimension(Integer.MAX_VALUE, dimension.height));
        jPanel2.add(jComponent);
        container.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(Box.createRigidArea(new Dimension(0, 150)));
        JLabel jLabel = new JLabel(ToolkitResources.getString((String)"CHANGES_TEXT"));
        jPanel3.add(jLabel);
        container.add((Component)jPanel3, "South");
    }

    public void runConsole() {
        debug.println(3, "Running the WMA Console");
        try {
            WMAConsole wMAConsole = new WMAConsole();
            wMAConsole.run();
        }
        catch (Exception exception) {
            debug.exception(1, (Throwable)exception);
            Debug.warning((String)exception.toString());
        }
        catch (Error error) {
            debug.exception(1, (Throwable)error);
            Debug.warning((String)error.toString());
        }
    }
}

