/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.extension.modules;

import com.sun.kvem.extension.DataNotValidException;
import com.sun.kvem.extension.ExtensionModuleManager;
import com.sun.kvem.extension.modules.SimpleExtension;
import com.sun.kvem.preferences.EditableProperty;
import com.sun.kvem.preferences.NumberProperty;
import com.sun.kvem.preferences.StringProperty;
import com.sun.kvem.util.ResourceLabel;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class StorageExtension
extends SimpleExtension {
    public StorageExtension(ExtensionModuleManager extensionModuleManager) {
        super(extensionModuleManager);
    }

    public String getName() {
        return "Storage Extension";
    }

    public String getLabel() {
        return ToolkitResources.getString((String)"STORAGE_LABEL");
    }

    public int getMnemonic() {
        return ToolkitResources.getString((String)"STORAGE_LABEL_SHORTCUT").charAt(0);
    }

    public String getDescription() {
        return "Enables configuration of the MIDP storage options";
    }

    protected EditableProperty[] createPropertyEditors(Properties properties) {
        EditableProperty[] editablePropertyArray = new EditableProperty[]{new StringProperty(properties, ToolkitResources.getString((String)"STORAGE_ROOT"), "storage.root"), new NumberProperty(properties, ToolkitResources.getString((String)"STORAGE_SIZE"), "storage.size", 8, 0, Integer.MAX_VALUE), new NumberProperty(properties, ToolkitResources.getString((String)"HEAP_SIZE"), "heap.size", 5, 32, 65536)};
        return editablePropertyArray;
    }

    protected void createGUI(Container container, EditableProperty[] editablePropertyArray) {
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(editablePropertyArray[1].createUI());
        jPanel.add((Component)new ResourceLabel("KB"));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(editablePropertyArray[2].createUI());
        jPanel2.add((Component)new ResourceLabel("KB"));
        box.add(editablePropertyArray[0].createUI());
        box.add(jPanel);
        box.add(jPanel2);
        container.add((Component)box, "North");
    }

    protected void validate(EditableProperty[] editablePropertyArray) throws DataNotValidException {
        String string = editablePropertyArray[0].getValue();
        if (string == null || string.trim().equals("")) {
            return;
        }
        JComponent jComponent = editablePropertyArray[0].getComponent();
        File file = new File(string);
        if (file.isAbsolute()) {
            throw new DataNotValidException((Component)jComponent, ToolkitResources.getString((String)"NON_RELATIVE_STORAGE"));
        }
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            throw new DataNotValidException((Component)jComponent, ToolkitResources.getString((String)"FORBIDDEN_CHAR_STORAGE"));
        }
        catch (SecurityException securityException) {
            throw new DataNotValidException((Component)jComponent, ToolkitResources.getString((String)"NO_PERMISSION_STORAGE"));
        }
        while (string.endsWith("\\")) {
            editablePropertyArray[0].setValue(string.substring(0, string.length() - 1));
            string = editablePropertyArray[0].getValue();
        }
    }
}

