/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.extension.modules;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.extension.ExtensionModuleManager;
import com.sun.kvem.extension.modules.SimpleExtension;
import com.sun.kvem.preferences.ChoiceProperty;
import com.sun.kvem.preferences.EditableProperty;
import com.sun.kvem.security.MECertToolbar;
import com.sun.kvem.security.Policy;
import com.sun.kvem.security.SEKeyTool;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Component;
import java.awt.Container;
import java.util.Properties;
import javax.swing.Box;

public class SecurityExtension
extends SimpleExtension {
    private static final Debug debug = Debug.create((Class)SecurityExtension.class);

    public SecurityExtension(ExtensionModuleManager extensionModuleManager) {
        super(extensionModuleManager);
        this.addUtility(ToolkitResources.getString((String)"SECTOOL.SIGN_JAR"), "sign", ToolkitResources.getString((String)"SECTOOL.SIGN_JAR_SHORTCUT"));
        this.addUtility(ToolkitResources.getString((String)"MECERT.BUTTON"), "meCert", ToolkitResources.getString((String)"MECERT.TOOL_SHORTCUT"));
    }

    public String getName() {
        return "Security Tool Extension";
    }

    public String getLabel() {
        return ToolkitResources.getString((String)"SECTOOL.LABEL");
    }

    protected String getBorderTitle() {
        return ToolkitResources.getString((String)"SECTOOL.BORDER_TITLE");
    }

    public int getMnemonic() {
        return ToolkitResources.getString((String)"SECTOOL.TITLE_SHORTCUT").charAt(0);
    }

    public String getDescription() {
        return ToolkitResources.getString((String)"SECTOOL.RUN");
    }

    protected EditableProperty[] createPropertyEditors(Properties properties) {
        EditableProperty[] editablePropertyArray = new EditableProperty[]{new ChoiceProperty(properties, ToolkitResources.getString((String)"SECURITY_DOMAIN"), "security.domain", Policy.defaultPolicy().domainNames())};
        return editablePropertyArray;
    }

    protected void createGUI(Container container, EditableProperty[] editablePropertyArray) {
        Box box = Box.createVerticalBox();
        box.add(editablePropertyArray[0].createUI());
        container.add((Component)box, "North");
    }

    public void sign() {
        debug.println(3, "Running the SE key tool");
        try {
            SEKeyTool sEKeyTool = new SEKeyTool();
            new Thread((Runnable)sEKeyTool).start();
        }
        catch (Exception exception) {
            debug.exception(1, (Throwable)exception);
            Debug.warning((String)exception.toString());
        }
        catch (Error error) {
            debug.exception(1, (Throwable)error);
            Debug.warning((String)error.toString());
        }
    }

    public void meCert() {
        debug.println(3, "Running the Security Tool");
        try {
            MECertToolbar mECertToolbar = new MECertToolbar();
            new Thread((Runnable)mECertToolbar).start();
        }
        catch (Exception exception) {
            debug.exception(1, (Throwable)exception);
            Debug.warning((String)exception.toString());
        }
        catch (Error error) {
            debug.exception(1, (Throwable)error);
            Debug.warning((String)error.toString());
        }
    }
}

