/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.extension.modules;

import com.sun.kvem.preferences.EditableProperty;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RefreshProperties
extends EditableProperty
implements ActionListener {
    private ButtonGroup bgroup;
    private JSlider slider;
    private JLabel label;
    private JLabel mainLabel;
    private String labelText;
    private Box b;
    private int frameRate;
    private int[] displayRefreshRateRange = new int[2];
    private String refreshMode;
    private String[] refreshModeList = new String[]{"default", "immidiate", "periodic"};
    private JRadioButton[] buttonList = new JRadioButton[this.refreshModeList.length];

    public RefreshProperties(Properties properties, String string, String string2) {
        super(properties, string, string2);
        this.bgroup = new ButtonGroup();
        this.slider = new JSlider();
        this.labelText = ToolkitResources.getString((String)"PERFORMANCE_EXT.REFRESH_RATE");
        this.label = new JLabel(this.labelText);
        this.mainLabel = new JLabel(string);
        FontMetrics fontMetrics = this.label.getFontMetrics(this.label.getFont());
        this.label.setPreferredSize(new Dimension(fontMetrics.stringWidth(this.labelText + "00"), fontMetrics.getHeight()));
        this.label.setLabelFor(this.slider);
        this.slider.addChangeListener(new ChangeListener(){
            private Object[] valArray = new Object[1];

            public void stateChanged(ChangeEvent changeEvent) {
                String string = Integer.toString(RefreshProperties.this.slider.getValue());
                this.valArray[0] = string;
                RefreshProperties.this.label.setText(MessageFormat.format(RefreshProperties.this.labelText, this.valArray));
                RefreshProperties.this.slider.setToolTipText(string);
            }
        });
    }

    public Component createUI() {
        Box box = Box.createHorizontalBox();
        this.b = Box.createVerticalBox();
        this.slider.setMinimum(this.displayRefreshRateRange[0]);
        this.slider.setMaximum(this.displayRefreshRateRange[1]);
        this.slider.setMajorTickSpacing(10);
        this.slider.setMinorTickSpacing(2);
        this.slider.setLabelTable(this.slider.createStandardLabels(this.displayRefreshRateRange[1] - this.displayRefreshRateRange[0], this.displayRefreshRateRange[0]));
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setValue(this.frameRate);
        this.slider.setEnabled(false);
        this.label.setEnabled(false);
        box.add(Box.createRigidArea(new Dimension(5, 0)));
        box.add(this.mainLabel);
        box.add(Box.createHorizontalStrut(5));
        JRadioButton jRadioButton = new JRadioButton(ToolkitResources.getString((String)"PERFORMANCE_EXT.REFRESH_DB"));
        jRadioButton.setActionCommand(this.refreshModeList[0]);
        jRadioButton.addActionListener(this);
        box.add(jRadioButton);
        this.bgroup.add(jRadioButton);
        this.buttonList[0] = jRadioButton;
        jRadioButton = new JRadioButton(ToolkitResources.getString((String)"PERFORMANCE_EXT.REFRESH_IMM"));
        jRadioButton.setActionCommand(this.refreshModeList[1]);
        jRadioButton.addActionListener(this);
        box.add(jRadioButton);
        this.bgroup.add(jRadioButton);
        this.buttonList[1] = jRadioButton;
        jRadioButton = new JRadioButton(ToolkitResources.getString((String)"PERFORMANCE_EXT.REFRESH_PER"));
        jRadioButton.setActionCommand(this.refreshModeList[2]);
        jRadioButton.addActionListener(this);
        this.bgroup.add(jRadioButton);
        this.buttonList[2] = jRadioButton;
        box.add(jRadioButton);
        jRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                RefreshProperties.this.slider.setEnabled(bl);
                RefreshProperties.this.label.setEnabled(bl);
            }
        });
        this.setValue(this.refreshMode);
        box.add(Box.createHorizontalGlue());
        this.b.add(box);
        box = Box.createHorizontalBox();
        box.add(this.slider);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.label);
        box.add(Box.createHorizontalGlue());
        this.b.add(box);
        return this.b;
    }

    public void setValue(String string) {
        int n;
        for (n = 0; n < this.refreshModeList.length && !this.refreshModeList[n].equals(string); ++n) {
        }
        if (n >= this.refreshModeList.length) {
            n = 0;
        }
        this.buttonList[n].setSelected(true);
    }

    public String getValue() {
        return this.refreshMode;
    }

    public void setVisible(boolean bl) {
        this.b.setVisible(bl);
    }

    public boolean isDirty() {
        return true;
    }

    public boolean updatePreferences() {
        Properties properties = this.getPreferences();
        properties.setProperty("screen.refresh.mode", this.refreshMode);
        properties.setProperty("screen.refresh.rate", String.valueOf(this.slider.getValue()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setState(String string, String string2, String string3) {
        this.refreshMode = string;
        try {
            this.displayRefreshRateRange[0] = Integer.parseInt(string3.substring(0, string3.indexOf(44)).trim());
        }
        catch (Exception exception) {
            this.displayRefreshRateRange[0] = 1;
        }
        try {
            this.displayRefreshRateRange[1] = Integer.parseInt(string3.substring(string3.indexOf(44) + 1, string3.length()).trim());
        }
        catch (Exception exception) {
            this.displayRefreshRateRange[1] = 30;
        }
        if (string2 == null) return;
        try {
            try {
                this.frameRate = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.frameRate = this.displayRefreshRateRange[1];
                Object var6_8 = null;
                if (this.frameRate >= this.displayRefreshRateRange[0]) {
                    if (this.frameRate <= this.displayRefreshRateRange[1]) return;
                }
                this.frameRate = this.displayRefreshRateRange[1];
                return;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (this.frameRate >= this.displayRefreshRateRange[0]) {
                if (this.frameRate <= this.displayRefreshRateRange[1]) throw throwable;
            }
            this.frameRate = this.displayRefreshRateRange[1];
            throw throwable;
        }
        if (this.frameRate >= this.displayRefreshRateRange[0]) {
            if (this.frameRate <= this.displayRefreshRateRange[1]) return;
        }
        this.frameRate = this.displayRefreshRateRange[1];
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.refreshMode = actionEvent.getActionCommand();
    }
}

