/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.extension.modules;

import com.sun.kvem.Screen;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.extension.EmulatorEvent;
import com.sun.kvem.extension.EmulatorListener;
import com.sun.kvem.extension.ExtensionModuleManager;
import com.sun.kvem.extension.modules.SimpleExtension;
import com.sun.kvem.preferences.BooleanProperty;
import com.sun.kvem.preferences.EditableProperty;
import com.sun.kvem.preferences.InvisibleProperty;
import com.sun.kvem.profiler.ProfView;
import com.sun.kvem.util.SmartFileChooser;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.util.Properties;
import javax.swing.SwingUtilities;

public class ProfileExtension
extends SimpleExtension {
    public ProfileExtension(ExtensionModuleManager extensionModuleManager) {
        super(extensionModuleManager);
        extensionModuleManager.addEmulatorListener((EmulatorListener)new ProfilerListener());
        this.addUtility(ToolkitResources.getString((String)"PROFILER_EXT.OPEN_SESSION"), "viewFile", ToolkitResources.getString((String)"PROFILER_EXT.OPEN_SESSION_SHORTCUT"));
    }

    public String getName() {
        return ToolkitResources.getString((String)"PROFILER_EXT.NAME");
    }

    public String getLabel() {
        return ToolkitResources.getString((String)"PROFILER_EXT.LABEL");
    }

    public int getMnemonic() {
        return ToolkitResources.getString((String)"PROFILER_EXT.LABEL_SHORTCUT").charAt(0);
    }

    public String getDescription() {
        return "Enables configuration of the MIDP profiling options";
    }

    public void viewFile() {
        File file = new File(ToolkitDirs.SESSION);
        SmartFileChooser smartFileChooser = new SmartFileChooser(null, file);
        smartFileChooser.setAcceptAllFileFilterUsed(false);
        smartFileChooser.addExtFilter("prf", ToolkitResources.getString((String)"PROFILER_FILE_FILTER_DESC"));
        int n = smartFileChooser.showOpenDialog(null);
        if (n == 0) {
            String string = smartFileChooser.getSelectedFile().toString();
            if (string.equals("")) {
                throw new RuntimeException("The profiler output file is not specified");
            }
            boolean bl = Boolean.valueOf(this.getProperties().getProperty("kvem.profiler.showsystem"));
            ProfView profView = new ProfView(bl);
            profView.startFromExtension(string);
        }
    }

    protected EditableProperty[] createPropertyEditors(Properties properties) {
        BooleanProperty booleanProperty = new BooleanProperty(properties, ToolkitResources.getString((String)"PROFILER_EXT.ENABLE"), "kvem.profiler.enable");
        BooleanProperty booleanProperty2 = new BooleanProperty(properties, ToolkitResources.getString((String)"PROFILER_EXT.SHOW_SYSTEM"), "kvem.profiler.showsystem");
        booleanProperty.addDisableDependent((EditableProperty)booleanProperty2);
        InvisibleProperty invisibleProperty = new InvisibleProperty(properties, "kvem.profiler.outfile");
        InvisibleProperty invisibleProperty2 = new InvisibleProperty(properties, "jammode");
        EditableProperty[] editablePropertyArray = new EditableProperty[]{booleanProperty, booleanProperty2, invisibleProperty, invisibleProperty2};
        return editablePropertyArray;
    }

    protected void createGUI(Container container, EditableProperty[] editablePropertyArray) {
        container.add(editablePropertyArray[0].createUI(), "North");
        container.add(editablePropertyArray[1].createUI(), "South");
    }

    private Properties getProperties() {
        return this.properties;
    }

    protected Frame findDeviceFrame() {
        return (Frame)SwingUtilities.windowForComponent(Screen.getInstance().getComponent());
    }

    private class ProfilerListener
    implements EmulatorListener {
        ProfView viewer;

        private ProfilerListener() {
        }

        public void sessionStarted(EmulatorEvent emulatorEvent) {
        }

        public void sessionEnded(EmulatorEvent emulatorEvent) {
        }

        public void executionStarted(EmulatorEvent emulatorEvent) {
            boolean bl;
            boolean bl2 = Boolean.valueOf(ProfileExtension.this.getProperties().getProperty("kvem.profiler.enable"));
            boolean bl3 = Boolean.valueOf(ProfileExtension.this.getProperties().getProperty("kvem.profiler.showsystem"));
            boolean bl4 = bl = !ProfileExtension.this.getProperties().getProperty("jammode").equals("");
            if (!bl && bl2) {
                this.viewer = new ProfView(bl3, ProfileExtension.this.findDeviceFrame().getTitle());
                this.viewer.register();
            }
        }

        public void executionEnded(EmulatorEvent emulatorEvent) {
            if (this.viewer != null) {
                String string = ProfileExtension.this.getProperties().getProperty("kvem.profiler.outfile");
                if (string != null && !string.equals("")) {
                    this.viewer.start(string);
                } else {
                    this.viewer.deregister();
                }
            }
        }

        public void midletStarted(EmulatorEvent emulatorEvent) {
        }

        public void midletEnded(EmulatorEvent emulatorEvent) {
        }
    }
}

