/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.extension.modules;

import com.sun.kvem.Device;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.extension.ExtensionModuleManager;
import com.sun.kvem.extension.modules.RefreshProperties;
import com.sun.kvem.extension.modules.SimpleExtension;
import com.sun.kvem.preferences.BooleanProperty;
import com.sun.kvem.preferences.ChoiceProperty;
import com.sun.kvem.preferences.EditableProperty;
import com.sun.kvem.preferences.InvisibleProperty;
import com.sun.kvem.preferences.SliderProperty;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Container;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JSeparator;
import javax.swing.JSlider;

public class PerformanceExtension
extends SimpleExtension {
    private BooleanProperty vmSpeedEn;
    private BooleanProperty netSpeedEn;
    private SliderProperty graphLatency = null;
    private SliderProperty vmSpeed;
    private RefreshProperties refreshProp;
    private ChoiceProperty netSpeed;
    private int[] vmSpeedRange = new int[2];
    private static final String[] nonEditableProp = new String[]{"screen.maxGraphicsLatency", "screen.refresh.rateRange", "screen.refresh.rate", "vmspeed.range"};
    private static final Debug debug = Debug.create((Class)PerformanceExtension.class);

    public PerformanceExtension(ExtensionModuleManager extensionModuleManager) {
        super(extensionModuleManager);
    }

    public String getName() {
        return "Performance Emulation Extension";
    }

    public String getLabel() {
        return ToolkitResources.getString((String)"PERFORMANCE_EXT.LABEL");
    }

    public int getMnemonic() {
        return ToolkitResources.getString((String)"PERFORMANCE_EXT.LABEL_SHORTCUT").charAt(0);
    }

    public String getDescription() {
        return ToolkitResources.getString((String)"PERFORMANCE_EXT.DESC");
    }

    protected EditableProperty[] createPropertyEditors(Properties properties) {
        if (this.graphLatency == null) {
            this.graphLatency = new SliderProperty(properties, ToolkitResources.getString((String)"PERFORMANCE_EXT.GRAPHICS_LATENCY"), "screen.graphicsLatency");
            this.vmSpeedEn = new BooleanProperty(properties, ToolkitResources.getString((String)"PERFORMANCE_EXT.VM_SPEED_ENABLE"), "vmspeed.enableEmulation");
            this.vmSpeed = new SliderProperty(properties, ToolkitResources.getString((String)"PERFORMANCE_EXT.VM_SPEED"), "vmspeed.bytecodespermilli");
            this.vmSpeedEn.addDisableDependent((EditableProperty)this.vmSpeed);
            this.netSpeedEn = new BooleanProperty(properties, ToolkitResources.getString((String)"PERFORMANCE_EXT.NETWORK_SPEED_ENABLE"), "netspeed.enableSpeedEmulation");
            this.refreshProp = new RefreshProperties(properties, ToolkitResources.getString((String)"PERFORMANCE_EXT.REFRESH_MODE"), "screen.refresh.mode");
            this.netSpeed = new ChoiceProperty(properties, ToolkitResources.getString((String)"PERFORMANCE_EXT.NETWORK_BPS"), "netspeed.bitpersecond", Device.netSpeedList, 4);
            this.netSpeedEn.addDisableDependent((EditableProperty)this.netSpeed);
        }
        EditableProperty[] editablePropertyArray = new EditableProperty[]{this.graphLatency, this.refreshProp, this.vmSpeedEn, this.vmSpeed, this.netSpeedEn, this.netSpeed, new InvisibleProperty(properties, "screen.refresh.rate")};
        return editablePropertyArray;
    }

    protected void createGUI(Container container, EditableProperty[] editablePropertyArray) {
        container.setLayout(new BoxLayout(container, 1));
        debug.println(1, "Editors: {0}", (Object)editablePropertyArray);
        final JSlider jSlider = (JSlider)((SliderProperty)editablePropertyArray[0]).getComponent();
        try {
            jSlider.setMaximum(Integer.parseInt(this.properties.getProperty("screen.maxGraphicsLatency", "50")));
        }
        catch (NumberFormatException numberFormatException) {
            jSlider.setMaximum(50);
        }
        jSlider.setMajorTickSpacing(20);
        jSlider.setMinorTickSpacing(5);
        jSlider.setLabelTable(jSlider.createStandardLabels(20));
        jSlider.setPaintLabels(true);
        jSlider.setPaintTicks(true);
        jSlider.setSnapToTicks(true);
        jSlider.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 39: 
                    case 227: {
                        jSlider.setValue(jSlider.getValue() + 5);
                        break;
                    }
                    case 37: 
                    case 226: {
                        jSlider.setValue(jSlider.getValue() - 5);
                        break;
                    }
                }
            }
        });
        container.add(Box.createVerticalStrut(15));
        container.add(editablePropertyArray[0].createUI());
        container.add(Box.createVerticalStrut(15));
        ((RefreshProperties)editablePropertyArray[1]).setState(this.properties.getProperty("screen.refresh.mode", "default"), this.properties.getProperty("screen.refresh.rate"), this.properties.getProperty("screen.refresh.rateRange", "1,30"));
        container.add(editablePropertyArray[1].createUI());
        container.add(Box.createVerticalStrut(15));
        container.add(new JSeparator());
        container.add(Box.createVerticalStrut(15));
        container.add(editablePropertyArray[2].createUI());
        JSlider jSlider2 = (JSlider)((SliderProperty)editablePropertyArray[3]).getComponent();
        String string = this.properties.getProperty("vmspeed.range", "10,100");
        try {
            this.vmSpeedRange[0] = Integer.parseInt(string.substring(0, string.indexOf(44)).trim());
        }
        catch (Exception exception) {
            this.vmSpeedRange[0] = 10;
        }
        try {
            this.vmSpeedRange[1] = Integer.parseInt(string.substring(string.indexOf(44) + 1, string.length()).trim());
        }
        catch (Exception exception) {
            this.vmSpeedRange[1] = 100;
        }
        jSlider2.setMinimum(this.vmSpeedRange[0]);
        jSlider2.setMaximum(this.vmSpeedRange[1]);
        int n = this.vmSpeedRange[1] - this.vmSpeedRange[0];
        jSlider2.setMinorTickSpacing(n / 10);
        jSlider2.setLabelTable(jSlider2.createStandardLabels(n, this.vmSpeedRange[0]));
        jSlider2.setPaintLabels(true);
        jSlider2.setPaintTicks(true);
        editablePropertyArray[3].setValue(this.properties.getProperty("vmspeed.bytecodespermilli", String.valueOf(this.vmSpeedRange[1])));
        container.add(editablePropertyArray[3].createUI());
        container.add(Box.createVerticalStrut(15));
        container.add(new JSeparator());
        container.add(Box.createVerticalStrut(15));
        container.add(editablePropertyArray[4].createUI());
        container.add(editablePropertyArray[5].createUI());
        container.add(Box.createVerticalStrut(20));
    }

    public void setProperties(Properties properties) {
        super.setProperties(properties);
        for (int i = 0; i < nonEditableProp.length; ++i) {
            String string = properties.getProperty(nonEditableProp[i]);
            if (string == null) continue;
            this.properties.put(nonEditableProp[i], string);
        }
    }
}

