/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.extension.modules;

import com.sun.kvem.Screen;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.extension.EmulatorEvent;
import com.sun.kvem.extension.EmulatorListener;
import com.sun.kvem.extension.ExtensionModuleManager;
import com.sun.kvem.extension.modules.SimpleExtension;
import com.sun.kvem.netmon.gui.NetMonFrame;
import com.sun.kvem.preferences.BooleanProperty;
import com.sun.kvem.preferences.EditableProperty;
import com.sun.kvem.preferences.InvisibleProperty;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Container;
import java.awt.Frame;
import java.util.Properties;
import javax.swing.SwingUtilities;

public class NetmonExtension
extends SimpleExtension {
    public static final String PROP_PREF = "kvem.netmon.";
    public static final String NETMON_ENABLED = "kvem.netmon.enable";
    static final Debug debug = Debug.create((Class)NetmonExtension.class);
    NetmonEventListener emuListener = new NetmonEventListener(this);
    NetMonFrame netmonFrame;
    boolean autoClose = false;
    ExtensionModuleManager extMgr;

    public NetmonExtension(ExtensionModuleManager extensionModuleManager) {
        super(extensionModuleManager);
        this.extMgr = extensionModuleManager;
        extensionModuleManager.addEmulatorListener((EmulatorListener)this.emuListener);
        this.addUtility(ToolkitResources.getString((String)"NETMON_OPEN_SESSION"), "openOffline", ToolkitResources.getString((String)"NETMON_OPEN_SESSION_SHORTCUT"));
    }

    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.autoClose = Boolean.valueOf(properties.getProperty("kvem.netmon.autoclose", "false"));
    }

    public String getName() {
        return ToolkitResources.getString((String)"NETMON_EXT_NAME");
    }

    public String getLabel() {
        return ToolkitResources.getString((String)"NETMON_LABEL");
    }

    public int getMnemonic() {
        return ToolkitResources.getString((String)"NETMON_LABEL_SHORTCUT").charAt(0);
    }

    public String getDescription() {
        return ToolkitResources.getString((String)"NETMON_DESCIPTION");
    }

    public void openOffline() {
        this.netmonFrame = new NetMonFrame(this.properties, false);
        if (!this.netmonFrame.openLoadDialog()) {
            this.netmonFrame.dispose();
        }
    }

    protected EditableProperty[] createPropertyEditors(Properties properties) {
        try {
            EditableProperty[] editablePropertyArray = new EditableProperty[]{new BooleanProperty(properties, ToolkitResources.getString((String)"NETMON_CHECKBOX_ENABLE_TITLE"), NETMON_ENABLED), new InvisibleProperty(properties, "jammode")};
            return editablePropertyArray;
        }
        catch (RuntimeException runtimeException) {
            debug.exception(1, (Throwable)runtimeException);
            throw runtimeException;
        }
    }

    protected void createGUI(Container container, EditableProperty[] editablePropertyArray) {
        container.add(editablePropertyArray[0].createUI(), "North");
    }

    private Properties getProperties() {
        return this.properties;
    }

    protected Frame findDeviceFrame() {
        return (Frame)SwingUtilities.windowForComponent(Screen.getInstance().getComponent());
    }

    private class NetmonEventListener
    implements EmulatorListener {
        NetmonExtension ext;

        public NetmonEventListener(NetmonExtension netmonExtension2) {
            this.ext = netmonExtension2;
        }

        public void sessionStarted(EmulatorEvent emulatorEvent) {
            String string = NetmonExtension.this.getProperties().getProperty("jammode");
            boolean bl = !string.equals("list") && !string.equals("storageNames") && !string.equals("remove");
            boolean bl2 = Boolean.valueOf(NetmonExtension.this.getProperties().getProperty(NetmonExtension.NETMON_ENABLED));
            if (bl && bl2) {
                this.ext.netmonFrame = new NetMonFrame(this.ext.getProperties(), true);
                this.ext.netmonFrame.setVisible(true);
            }
        }

        public void sessionEnded(EmulatorEvent emulatorEvent) {
        }

        public void executionStarted(EmulatorEvent emulatorEvent) {
            boolean bl = Boolean.valueOf(NetmonExtension.this.getProperties().getProperty(NetmonExtension.NETMON_ENABLED));
            if (bl && this.ext.netmonFrame != null) {
                Frame frame = this.ext.findDeviceFrame();
                this.ext.netmonFrame.setDeviceFrame(frame);
            }
        }

        public void executionEnded(EmulatorEvent emulatorEvent) {
            boolean bl = Boolean.valueOf(NetmonExtension.this.getProperties().getProperty(NetmonExtension.NETMON_ENABLED));
            if (this.ext != null && bl && this.ext.netmonFrame != null) {
                if (this.ext.autoClose) {
                    this.ext.netmonFrame.clearAll();
                    this.ext.netmonFrame.setVisible(false);
                    this.ext.netmonFrame.dispose();
                } else {
                    this.ext.netmonFrame.stop();
                }
                this.ext.extMgr.removeEmulatorListener((EmulatorListener)this);
            }
        }

        public void midletStarted(EmulatorEvent emulatorEvent) {
        }

        public void midletEnded(EmulatorEvent emulatorEvent) {
        }
    }
}

