/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.extension.modules;

import com.sun.kvem.Screen;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.extension.EmulatorEvent;
import com.sun.kvem.extension.EmulatorListener;
import com.sun.kvem.extension.ExtensionModuleManager;
import com.sun.kvem.extension.modules.SimpleExtension;
import com.sun.kvem.memorymon.MemoryListener;
import com.sun.kvem.memorymon.MemoryMonitor;
import com.sun.kvem.preferences.BooleanProperty;
import com.sun.kvem.preferences.EditableProperty;
import com.sun.kvem.preferences.InvisibleProperty;
import com.sun.kvem.util.SmartFileChooser;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class MemoryExtension
extends SimpleExtension {
    private File currentFile = null;
    private File defaultDir = new File(ToolkitDirs.SESSION);
    public static final String CMD_OPEN = "open";

    public MemoryExtension(ExtensionModuleManager extensionModuleManager) {
        super(extensionModuleManager);
        extensionModuleManager.addEmulatorListener((EmulatorListener)new MemoryExtensionListener());
        this.addUtility(ToolkitResources.getString((String)"MEMORY_EXT.OPEN_SESSION"), "viewFile", ToolkitResources.getString((String)"MEMORY_EXT.OPEN_SESSION_SHORTCUT"));
    }

    public String getName() {
        return ToolkitResources.getString((String)"MEMORY_EXT.NAME");
    }

    public String getLabel() {
        return ToolkitResources.getString((String)"MEMORY_EXT.LABEL");
    }

    public int getMnemonic() {
        return ToolkitResources.getString((String)"MEMORY_EXT.LABEL_SHORTCUT").charAt(0);
    }

    public String getDescription() {
        return ToolkitResources.getString((String)"MEMORY_EXT.DESC");
    }

    public void viewFile() {
        SmartFileChooser smartFileChooser = new SmartFileChooser(this.currentFile, this.defaultDir);
        smartFileChooser.setAcceptAllFileFilterUsed(false);
        smartFileChooser.addExtFilter(MemoryMonitor.MEMORY_SESSION_FILE_EXT, ToolkitResources.getString((String)"MEMORY_FILE_FILTER_DESC"));
        int n = smartFileChooser.showOpenDialog(null);
        if (n == 0) {
            File file = smartFileChooser.getSelectedFile();
            try {
                new MemoryMonitor(file);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog((Component)smartFileChooser, ToolkitResources.getString((String)"CORRUPTED_FILE"), ToolkitResources.getString((String)"NETMON_ERROR_TITLE"), 0);
            }
        }
    }

    protected EditableProperty[] createPropertyEditors(Properties properties) {
        BooleanProperty booleanProperty = new BooleanProperty(properties, ToolkitResources.getString((String)"MEMORY_EXT.ENABLE"), "kvem.memory.monitor.enable");
        InvisibleProperty invisibleProperty = new InvisibleProperty(properties, "jammode");
        EditableProperty[] editablePropertyArray = null;
        editablePropertyArray = new EditableProperty[]{booleanProperty, invisibleProperty};
        return editablePropertyArray;
    }

    protected void createGUI(Container container, EditableProperty[] editablePropertyArray) {
        Box box = Box.createVerticalBox();
        for (int i = 0; i < editablePropertyArray.length - 1; ++i) {
            box.add(editablePropertyArray[i].createUI());
        }
        container.add((Component)box, "Center");
    }

    private Properties getProperties() {
        return this.properties;
    }

    protected Frame findDeviceFrame() {
        return (Frame)SwingUtilities.windowForComponent(Screen.getInstance().getComponent());
    }

    private class MemoryExtensionListener
    implements EmulatorListener {
        private MemoryExtensionListener() {
        }

        public void sessionStarted(EmulatorEvent emulatorEvent) {
        }

        public void sessionEnded(EmulatorEvent emulatorEvent) {
        }

        public void executionStarted(EmulatorEvent emulatorEvent) {
            boolean bl = Boolean.valueOf(MemoryExtension.this.getProperties().getProperty("kvem.memory.monitor.enable"));
            if (bl) {
                MemoryListener.setAssociatedEmuTitle(MemoryExtension.this.findDeviceFrame().getTitle());
            }
        }

        public void executionEnded(EmulatorEvent emulatorEvent) {
            boolean bl = !MemoryExtension.this.getProperties().getProperty("jammode").equals("");
            boolean bl2 = Boolean.valueOf(MemoryExtension.this.getProperties().getProperty("kvem.memory.monitor.enable"));
            if (!bl && bl2) {
                MemoryListener.stopListening();
            }
        }

        public void midletStarted(EmulatorEvent emulatorEvent) {
        }

        public void midletEnded(EmulatorEvent emulatorEvent) {
        }
    }
}

