/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.extension.modules;

import com.sun.kvem.extension.ExtensionModuleManager;
import com.sun.kvem.extension.modules.SimpleExtension;
import com.sun.kvem.preferences.BooleanProperty;
import com.sun.kvem.preferences.EditableProperty;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class MMediaExtension
extends SimpleExtension {
    public MMediaExtension(ExtensionModuleManager extensionModuleManager) {
        super(extensionModuleManager);
    }

    public String getName() {
        return "Multi Media Extension";
    }

    public String getLabel() {
        return ToolkitResources.getString((String)"MMAPI_EXT_LABEL");
    }

    public int getMnemonic() {
        return ToolkitResources.getString((String)"MMAPI_EXT_LABEL_SHORTCUT").charAt(0);
    }

    public String getDescription() {
        return "Enables configuration of Multi Media parameters";
    }

    protected EditableProperty[] createPropertyEditors(Properties properties) {
        EditableProperty[] editablePropertyArray = new EditableProperty[]{new BooleanProperty(properties, ToolkitResources.getString((String)"WAV_AUDIO"), "mm.format.wav"), new BooleanProperty(properties, ToolkitResources.getString((String)"MIDI"), "mm.format.midi"), new BooleanProperty(properties, ToolkitResources.getString((String)"VIDEO"), "mm.format.video"), new BooleanProperty(properties, ToolkitResources.getString((String)"AUDIO_MIXING"), "mm.control.mixing"), new BooleanProperty(properties, ToolkitResources.getString((String)"AUDIO_CAPTURE"), "mm.control.capture"), new BooleanProperty(properties, ToolkitResources.getString((String)"AUDIO_RECORD"), "mm.control.record"), new BooleanProperty(properties, ToolkitResources.getString((String)"MIDI_TONES"), "mm.control.midi")};
        return editablePropertyArray;
    }

    protected void createGUI(Container container, EditableProperty[] editablePropertyArray) {
        try {
            Box box = Box.createVerticalBox();
            box.add(this.createFormatPanel(editablePropertyArray));
            box.add(Box.createVerticalStrut(16));
            box.add(this.createFeaturesPanel(editablePropertyArray));
            container.add((Component)box, "North");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void updateValue(EditableProperty editableProperty) {
        editableProperty.setValue(editableProperty.getPreferences().getProperty(editableProperty.getKey()));
    }

    public JPanel createFormatPanel(EditableProperty[] editablePropertyArray) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(ToolkitResources.getString((String)"MM_FORMATS_LABEL")));
        jPanel.setLayout(new GridLayout(1, 3));
        for (int i = 0; i < 3; ++i) {
            jPanel.add(editablePropertyArray[i].createUI());
        }
        return jPanel;
    }

    public JPanel createFeaturesPanel(EditableProperty[] editablePropertyArray) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(ToolkitResources.getString((String)"MM_FEATURES_LABEL")));
        jPanel.setLayout(new GridLayout(2, 2));
        for (int i = 3; i < editablePropertyArray.length; ++i) {
            jPanel.add(editablePropertyArray[i].createUI());
        }
        return jPanel;
    }
}

