/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.extension.modules;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.extension.ExtensionModuleManager;
import com.sun.kvem.extension.modules.SimpleExtension;
import com.sun.kvem.preferences.EditableProperty;
import com.sun.kvem.util.ToolkitResources;
import com.sun.kvem.util.WindowUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.io.File;
import java.io.FileFilter;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class DatabaseExtension
extends SimpleExtension {
    private static final Debug debug = Debug.create((Class)DatabaseExtension.class);
    private static CleanProgressIndicator cleanIndicator;
    private static CleaningThread cleaner;
    private JPanel panel;
    public File dbDir = new File(ToolkitDirs.APPDB);

    public DatabaseExtension(ExtensionModuleManager extensionModuleManager) {
        super(extensionModuleManager);
        this.addUtility(ToolkitResources.getString((String)"CLEAN_DATABASE"), "clean", ToolkitResources.getString((String)"CLEAN_DATABASE_SHORTCUT"));
    }

    public String getName() {
        return "Database Extension";
    }

    public String getLabel() {
        return ToolkitResources.getString((String)"DATABASE_LABEL");
    }

    public int getMnemonic() {
        return ToolkitResources.getString((String)"DATABASE_LABEL_SHORTCUT").charAt(0);
    }

    public String getDescription() {
        return "Enables resetting of the MIDP persisent storage";
    }

    protected EditableProperty[] createPropertyEditors(Properties properties) {
        return null;
    }

    protected void createGUI(Container container, EditableProperty[] editablePropertyArray) {
    }

    public void clean() {
        try {
            if (this.dbDir.isDirectory()) {
                debug.println(3, "Cleaning Database ...");
                this.removeDBFiles();
            }
        }
        catch (Exception exception) {
            JFrame jFrame = new JFrame();
            String string = ToolkitResources.getString((String)"CLEAN_DATABASE_FAILED");
            String string2 = ToolkitResources.getString((String)"CLEAN_DATABASE");
            JOptionPane.showMessageDialog(jFrame, string, string2, 0);
            jFrame.dispose();
        }
    }

    private void removeDBFiles() {
        debug.println(3, "Entering directory: {0} ... ", (Object)this.dbDir);
        cleanIndicator = new CleanProgressIndicator();
        cleaner = new CleaningThread();
        cleanIndicator.pack();
        WindowUtils.center((Window)cleanIndicator, (Window)WindowUtils.getAncestorWindow((Container)this.panel));
        cleaner.start();
        cleanIndicator.setVisible(true);
    }

    public Component getUtilitiesGUI() {
        this.panel = (JPanel)super.getUtilitiesGUI();
        return this.panel;
    }

    private static class DBFileFilter
    implements FileFilter {
        private DBFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.isFile() && file.getName().toLowerCase().endsWith(".db");
        }
    }

    private class CleanProgressIndicator
    extends JDialog {
        private JProgressBar progress = new JProgressBar(0, 100);
        private JLabel stage = new JLabel(ToolkitResources.getString((String)"INITIALIZING"));

        public CleanProgressIndicator() {
            this.setModal(true);
            this.setDefaultCloseOperation(0);
            this.setTitle(ToolkitResources.format((String)"CLEANING", (Object)DatabaseExtension.this.dbDir));
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.progress.setValue(0);
            this.getContentPane().add(this.stage);
            this.getContentPane().add(this.progress);
            this.pack();
        }

        public void update(String string, int n) {
            this.stage.setText(string);
            this.progress.setValue(n);
        }
    }

    private class CleaningThread
    extends Thread {
        int rc;

        private void removeDBFiles(File file) {
            int n;
            File[] fileArray = file.listFiles(new DBFileFilter());
            for (n = 0; n < fileArray.length; ++n) {
                if (!fileArray[n].isDirectory()) continue;
                debug.println(3, "Entering into ... " + fileArray[n]);
                this.removeDBFiles(fileArray[n]);
            }
            n = 10;
            for (int i = 0; i < fileArray.length; ++i) {
                cleanIndicator.update(ToolkitResources.getString((String)"DELETE_DIR") + file.getName(), n += 90 / fileArray.length);
                if (!fileArray[i].isFile()) continue;
                debug.println(3, "Deleting ... " + fileArray[i]);
                fileArray[i].delete();
            }
        }

        public void run() {
            CleaningThread.yield();
            this.removeDBFiles(DatabaseExtension.this.dbDir);
            cleanIndicator.dispose();
        }
    }
}

