/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.extension.modules;

import com.sun.kvem.extension.ExtensionModuleManager;
import com.sun.kvem.extension.modules.SimpleExtension;
import com.sun.kvem.preferences.BooleanProperty;
import com.sun.kvem.preferences.ChoiceProperty;
import com.sun.kvem.preferences.EditableProperty;
import com.sun.kvem.preferences.NumberProperty;
import com.sun.kvem.preferences.StringProperty;
import com.sun.kvem.util.ResourceLabel;
import com.sun.kvem.util.TableLayout;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

final class BluetoothExtension
extends SimpleExtension {
    private static final String[] encriptChoice = new String[]{"off", "on", "force"};
    private static final String[] authChoice = new String[]{"on", "force"};
    private ResourceLabel[] labels = null;

    public BluetoothExtension(ExtensionModuleManager extensionModuleManager) {
        super(extensionModuleManager);
    }

    public String getName() {
        return ToolkitResources.getString((String)"BLUETOOTH_EXT.NAME");
    }

    public String getLabel() {
        return ToolkitResources.getString((String)"BLUETOOTH_EXT.LABEL");
    }

    public int getMnemonic() {
        return ToolkitResources.getString((String)"BLUETOOTH_EXT.SHORTCUT").charAt(0);
    }

    public String getDescription() {
        return ToolkitResources.getString((String)"BLUETOOTH_EXT.DESCRIPTION");
    }

    protected EditableProperty[] createPropertyEditors(Properties properties) {
        EditableProperty[] editablePropertyArray = new EditableProperty[]{new NumberProperty(properties, "", "bluetooth.device.discovery.timeout", 10, 0, Integer.MAX_VALUE), new NumberProperty(properties, "", "bluetooth.l2cap.receiveMTU.max", 10, 48, Integer.MAX_VALUE), new NumberProperty(properties, "", "bluetooth.sd.trans.max", 10, 1, Integer.MAX_VALUE), new NumberProperty(properties, "", "bluetooth.sd.attr.retrievable.max", 10, 1, Integer.MAX_VALUE), new BooleanProperty(properties, ToolkitResources.getString((String)"BLUETOOTH_EXT.BLUETOOTH_ENABLE"), "bluetooth.enable"), new BooleanProperty(properties, ToolkitResources.getString((String)"BLUETOOTH_EXT.DEVICE_DISCOVERY_ENABLE"), "bluetooth.device.discovery.enable"), new StringProperty(properties, "", "bluetooth.device.friendlyName"), new ChoiceProperty(properties, "", "bluetooth.device.encryption", encriptChoice), new ChoiceProperty(properties, "", "bluetooth.device.authorization", authChoice), new ChoiceProperty(properties, "", "bluetooth.device.authentication", authChoice)};
        return editablePropertyArray;
    }

    private void createLabels() {
        this.labels = new ResourceLabel[]{new ResourceLabel("BLUETOOTH_EXT.DEVICE_DISCOVERY_TIMEOUT"), new ResourceLabel("BLUETOOTH_EXT.DEVICE_DISCOVERY_TIMEOUT_UNIT"), new ResourceLabel("BLUETOOTH_EXT.RECEIVE_MTU_MAX"), new ResourceLabel("BLUETOOTH_EXT.SD_TRANS_MAX"), new ResourceLabel("BLUETOOTH_EXT.SD_ATTR_MAX"), new ResourceLabel("BLUETOOTH_EXT.DEVICE_FRIENDLY_NAME"), new ResourceLabel("BLUETOOTH_EXT.ENCRYPTION"), new ResourceLabel("BLUETOOTH_EXT.AUTHORIZATION"), new ResourceLabel("BLUETOOTH_EXT.AUTHENTCATION")};
    }

    protected void createGUI(Container container, EditableProperty[] editablePropertyArray) {
        Container container2 = new Container();
        container2.setLayout(new BoxLayout(container2, 1));
        this.createLabels();
        this.setDisableDependent(editablePropertyArray);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(ToolkitResources.getString((String)"BLUETOOTH_EXT.INTERNAL_PROPERTIES"), this.createInternalPropertiesGUI(editablePropertyArray));
        jTabbedPane.add(ToolkitResources.getString((String)"BLUETOOTH_EXT.SYSTEM_PROPERTIES"), this.createSystemPropertiesGUI(editablePropertyArray));
        jTabbedPane.add(ToolkitResources.getString((String)"BLUETOOTH_EXT.BCC_PROPERTIES"), this.createBCCPropertiesGUI(editablePropertyArray));
        container2.add(jTabbedPane);
        container.add((Component)container2, "North");
    }

    private Container createInternalPropertiesGUI(EditableProperty[] editablePropertyArray) {
        Container container = new Container();
        TableLayout tableLayout = new TableLayout(3);
        tableLayout.setColumnWidth(0, 0);
        tableLayout.setColumnAlignment(0, 3);
        tableLayout.setColumnWidth(1, 1);
        tableLayout.setColumnWidth(2, 0);
        tableLayout.setInsets(new Insets(0, 2, 0, 2));
        tableLayout.setRowInsets(0, new Insets(0, 2, 12, 2));
        container.setLayout((LayoutManager)tableLayout);
        container.add((Component)this.labels[0]);
        container.add(editablePropertyArray[0].createUI());
        container.add((Component)this.labels[1]);
        return container;
    }

    private Container createSystemPropertiesGUI(EditableProperty[] editablePropertyArray) {
        Container container = new Container();
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setColumnWidth(0, 0);
        tableLayout.setColumnAlignment(0, 3);
        tableLayout.setColumnWidth(1, 1);
        tableLayout.setInsets(new Insets(0, 2, 0, 2));
        tableLayout.setRowInsets(0, new Insets(0, 2, 12, 2));
        tableLayout.setRowInsets(1, new Insets(0, 2, 12, 2));
        tableLayout.setRowInsets(2, new Insets(0, 2, 12, 2));
        container.setLayout((LayoutManager)tableLayout);
        container.add((Component)this.labels[2]);
        container.add(editablePropertyArray[1].createUI());
        container.add((Component)this.labels[3]);
        container.add(editablePropertyArray[2].createUI());
        container.add((Component)this.labels[4]);
        container.add(editablePropertyArray[3].createUI());
        return container;
    }

    private Container createBCCPropertiesGUI(EditableProperty[] editablePropertyArray) {
        Container container = new Container();
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setColumnWidth(0, 0);
        tableLayout.setColumnAlignment(0, 3);
        tableLayout.setColumnWidth(1, 1);
        tableLayout.setInsets(new Insets(0, 2, 12, 2));
        tableLayout.setRowInsets(0, new Insets(0, 2, 0, 2));
        tableLayout.setRowInsets(1, new Insets(0, 2, 0, 2));
        container.setLayout((LayoutManager)tableLayout);
        container.add(new JLabel(""));
        container.add(editablePropertyArray[4].createUI());
        container.add(new JLabel(""));
        container.add(editablePropertyArray[5].createUI());
        container.add((Component)this.labels[5]);
        container.add(editablePropertyArray[6].createUI());
        container.add((Component)this.labels[6]);
        container.add(editablePropertyArray[7].createUI());
        container.add((Component)this.labels[7]);
        container.add(editablePropertyArray[8].createUI());
        container.add((Component)this.labels[8]);
        container.add(editablePropertyArray[9].createUI());
        return container;
    }

    private void setDisableDependent(EditableProperty[] editablePropertyArray) {
        int n;
        for (n = 0; n <= 3; ++n) {
            ((BooleanProperty)editablePropertyArray[4]).addDisableDependent(editablePropertyArray[n]);
        }
        for (n = 5; n <= 9; ++n) {
            ((BooleanProperty)editablePropertyArray[4]).addDisableDependent(editablePropertyArray[n]);
        }
        for (n = 0; n <= 8; ++n) {
            ((BooleanProperty)editablePropertyArray[4]).addDisableDependent((Component)this.labels[n]);
        }
    }
}

