/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.extension.modules;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.PropertiesFile;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.extension.DataNotValidException;
import com.sun.kvem.extension.ExtensionModule;
import com.sun.kvem.extension.ExtensionModuleConfigurationGUI;
import com.sun.kvem.extension.ExtensionModuleManager;
import com.sun.kvem.preferences.BooleanProperty;
import com.sun.kvem.preferences.EditableProperty;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JComponent;

public class APIExtension
extends ExtensionModule {
    private static final Debug debug = Debug.create((Class)APIExtension.class);
    private static final String DELIM = ";";
    private static String[] apiNames;
    private static Properties apiProp;
    private EditableProperty[] propertyEditors;
    protected final Properties properties = new Properties();

    public APIExtension(ExtensionModuleManager extensionModuleManager) {
        super(extensionModuleManager);
        debug.println(3, "Constructor");
        this.createPropertyEditors();
    }

    public String getDescription() {
        return ToolkitResources.getString((String)"API_EXT_DESC");
    }

    public String getLabel() {
        return ToolkitResources.getString((String)"API_EXT_LABEL");
    }

    public int getMnemonic() {
        return ToolkitResources.getString((String)"API_EXT_LABEL_SHORTCUT").charAt(0);
    }

    public String getName() {
        return ToolkitResources.getString((String)"API_EXT_NAME");
    }

    public Component getUtilitiesGUI() {
        return null;
    }

    public void setProperties(Properties properties) {
        debug.println(3, "setProperties>>{0}", (Object)properties);
        this.initAPIProperties(properties);
        for (int i = 0; i < this.propertyEditors.length; ++i) {
            this.propertyEditors[i].initializeComponent();
        }
    }

    public void getProperties(Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        debug.println(3, "getProperties(1)>>{0}", (Object)apiProp);
        for (int i = 0; i < this.propertyEditors.length; ++i) {
            String string = this.propertyEditors[i].getKey();
            if (((BooleanProperty)this.propertyEditors[i]).getBoolean()) continue;
            stringBuffer.append(string);
            stringBuffer.append(DELIM);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        properties.setProperty("kvem.api.exclude", stringBuffer.toString());
        debug.println(3, "getProperties(2)>>{0}", (Object)properties);
    }

    private void createPropertyEditors() {
        try {
            PropertiesFile propertiesFile = new PropertiesFile(new File(ToolkitDirs.API + "api.properties"));
            Properties properties = propertiesFile.getProperties();
            apiNames = new String[properties.size()];
            Enumeration<Object> enumeration = properties.keys();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                String string;
                APIExtension.apiNames[n] = (String)enumeration.nextElement();
                if (n != 0 && apiNames[n].startsWith("cldcapi")) {
                    string = apiNames[0];
                    APIExtension.apiNames[0] = apiNames[n];
                    APIExtension.apiNames[n] = string;
                }
                if (n != 1 && apiNames[n].startsWith("midpapi")) {
                    string = apiNames[1];
                    APIExtension.apiNames[1] = apiNames[n];
                    APIExtension.apiNames[n] = string;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            apiNames = new String[0];
        }
        apiProp = new Properties();
        this.propertyEditors = new EditableProperty[apiNames.length];
        debug.println(1, "apiProp = {0}", (Object)apiProp);
        for (int i = 0; i < apiNames.length; ++i) {
            this.propertyEditors[i] = new BooleanProperty(apiProp, ToolkitResources.getString((String)apiNames[i].toUpperCase()), apiNames[i]);
            this.propertyEditors[i].initializeComponent();
        }
        debug.println(1, "editors = {0}", (Object)this.propertyEditors);
    }

    protected void createGUI(Container container, EditableProperty[] editablePropertyArray) {
        debug.println(1, "createGUI>>editors = {0}", (Object)editablePropertyArray);
        Box box = Box.createVerticalBox();
        for (int i = 0; i < editablePropertyArray.length; ++i) {
            box.add(editablePropertyArray[i].createUI());
        }
        editablePropertyArray[0].setEnabled(false);
        container.add((Component)box, "North");
    }

    private void initAPIProperties(Properties properties) {
        String string = properties.getProperty("kvem.api.exclude");
        debug.println(1, "api exclude list = {0}", (Object)string);
        for (int i = 0; i < apiNames.length; ++i) {
            apiProp.setProperty(apiNames[i], "true");
        }
        debug.println(1, "api properties = {0}", (Object)apiProp);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
            while (stringTokenizer.hasMoreTokens()) {
                apiProp.put(stringTokenizer.nextToken(), "false");
            }
        }
    }

    public ExtensionModuleConfigurationGUI getConfigurationGUI() {
        debug.println(3, "getConfigurationGUI");
        if (apiNames.length == 0) {
            return null;
        }
        ConfigurationGUI configurationGUI = new ConfigurationGUI();
        this.createGUI((Container)((Object)configurationGUI), this.propertyEditors);
        return configurationGUI;
    }

    static class ZipFilter
    implements FilenameFilter {
        ZipFilter() {
        }

        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".zip");
        }
    }

    class ConfigurationGUI
    extends ExtensionModuleConfigurationGUI {
        public ConfigurationGUI() {
            super((ExtensionModule)APIExtension.this);
            this.setLayout(new BorderLayout());
        }

        public void setProperties(Properties properties) {
            for (int i = 0; i < APIExtension.this.propertyEditors.length; ++i) {
                APIExtension.this.propertyEditors[i].initializeComponent();
            }
        }

        public void commitProperties() {
            for (int i = 0; i < APIExtension.this.propertyEditors.length; ++i) {
                APIExtension.this.propertyEditors[i].updatePreferences();
            }
        }

        public void validateData() throws DataNotValidException {
            for (int i = 0; i < APIExtension.this.propertyEditors.length; ++i) {
                if (APIExtension.this.propertyEditors[i].isValid()) continue;
                JComponent jComponent = APIExtension.this.propertyEditors[i].getComponent();
                String string = APIExtension.this.propertyEditors[i].getErrorMessage();
                throw new DataNotValidException((Component)jComponent, string);
            }
        }
    }
}

