/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.comcon.share;

import com.sun.kvem.comcon.share.ClientHandler;
import com.sun.kvem.comcon.share.Controller;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.ToolkitDirs;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;

final class Server
implements Runnable {
    static final String STAT_FILE_NAME = ToolkitDirs.LIB + "comcon-server.port";
    static final int SERVER_STARTUP_DELAY = 5000;
    private static final Debug debug = Debug.create((Class)Server.class);
    private static HashMap clientHandlers = null;
    private static HashMap controllers = new HashMap();
    private static int free_address = 0;
    private static ServerSocket serverSocket = null;

    Server() {
    }

    public static synchronized void launch() throws Exception {
        if (clientHandlers != null) {
            throw new IOException("Attempt to start the Server twice.");
        }
        serverSocket = new ServerSocket(0);
        int n = serverSocket.getLocalPort();
        debug.println(3, "serverPort {0}", n);
        Thread thread = new Thread((Runnable)new Server(), "Communication Controller Server");
        thread.setDaemon(true);
        thread.start();
        debug.println(4, "accepting thread is started");
        File file = new File(STAT_FILE_NAME);
        file.delete();
        file.createNewFile();
        file.deleteOnExit();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(Integer.toString(n));
        fileWriter.write("\n");
        fileWriter.close();
        debug.println(4, "statFile is written");
        clientHandlers = new HashMap();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    debug.println(3, "accepting new client...");
                    new ClientHandler(serverSocket.accept());
                    debug.println(3, "client is accepted");
                }
            }
            catch (Throwable throwable) {
                debug.println(4, "Exception: {0}", (Object)throwable);
                continue;
            }
            break;
        }
    }

    static synchronized String registerClient(ClientHandler clientHandler) {
        debug.println(3, "registering client...");
        String string = Integer.toString(free_address++);
        clientHandlers.put(string, clientHandler);
        debug.println(3, "Successfully registered client {0}", (Object)string);
        return string;
    }

    static synchronized void unregisterClient(String string) {
        if (string == null) {
            return;
        }
        debug.println(3, "Unregistering client: {0}", (Object)string);
        ClientHandler clientHandler = (ClientHandler)clientHandlers.remove(string);
        debug.println(3, "Unregistering client: handler={0}", (Object)clientHandler);
        if (clientHandler == null) {
            return;
        }
        clientHandler.destroy(false);
        debug.println(3, "Unregistering client: handler is destroyed.");
        Server.unregisterFromControllers(string);
    }

    static synchronized void unregisterSpecial(String string) {
        debug.println(3, "unregisterSpecial client: {0}", (Object)string);
        Server.unregisterFromControllers(string);
    }

    static synchronized Controller getController(String string) {
        Controller controller = (Controller)controllers.get(string);
        if (controller == null) {
            try {
                controller = (Controller)Class.forName(string).newInstance();
                controllers.put(string, controller);
            }
            catch (Throwable throwable) {
                Debug.warning((String)("Can't create controller: " + string + ": " + throwable));
            }
        }
        return controller;
    }

    private static void unregisterFromControllers(String string) {
        Object[] objectArray = controllers.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Controller controller = (Controller)controllers.get(objectArray[i]);
            try {
                controller.destroyClient(string);
                continue;
            }
            catch (Throwable throwable) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Error in Controller.destroyClient: ");
                stringBuffer.append("\tcontroller=").append(objectArray[i]);
                stringBuffer.append("\taddress=").append(string);
                stringBuffer.append(": ").append(throwable.toString());
                Debug.warning((String)stringBuffer.toString());
            }
        }
    }
}

