/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.comcon.share;

import com.sun.kvem.comcon.share.Controller;
import com.sun.kvem.comcon.share.Server;
import com.sun.kvem.comcon.share.Utils;
import com.sun.kvem.environment.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class ClientHandler
implements Runnable {
    private static Debug debug = Debug.create((Class)ClientHandler.class);
    private Socket clientSocket;
    private InputStream input;
    private OutputStream output;
    private String address;
    private boolean isClosed = false;

    ClientHandler(Socket socket) throws Exception {
        this.debugPrint("<init>");
        this.clientSocket = socket;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        Thread thread = new Thread((Runnable)this, "Client Handler [?]");
        thread.setDaemon(true);
        thread.start();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ClientHandler");
        stringBuffer.append("(").append(this.address).append(")");
        return stringBuffer.toString();
    }

    public void run() {
        try {
            String string = Utils.readLine(this.input);
            this.debugPrint("run: 1st str = " + string);
            this.debugPrint("run: processPingPongCase");
            if (!this.processPingPongCase(string)) {
                this.debugPrint("run: negotiateAddress");
                if (this.negotiateAddress(string)) {
                    this.debugPrint("run: processCommand");
                    this.processCommand();
                }
            }
        }
        catch (Exception exception) {
            this.debugPrint("run caught " + exception);
            debug.exception(3, (Throwable)exception);
        }
        this.destroy(true);
        this.debugPrint("The control handler work is done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy(boolean bl) {
        ClientHandler clientHandler = this;
        synchronized (clientHandler) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        if (bl) {
            Server.unregisterClient(this.address);
        }
        try {
            this.input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.output.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.clientSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processCommand() throws IOException {
        this.debugPrint("Process the command...");
        while (true) {
            this.debugPrint("Waiting for client's command...");
            String string = Utils.readLine(this.input);
            if (string.equals("BYE-SERVER")) {
                this.debugPrint("Client has sent good-bye command...");
                throw new IOException("Client disconnected");
            }
            if (string.equals("UNREGISTER-SPECIAL")) {
                this.debugPrint("Client request unregister from controllers...");
                Server.unregisterSpecial(this.address);
                this.output.write("OK\n".getBytes("ISO-8859-1"));
                this.output.flush();
                continue;
            }
            this.debugPrint("Controller: " + string);
            Controller controller = Server.getController(string);
            byte[] byArray = null;
            if (controller != null) {
                int n = Utils.readInt(this.input);
                byte[] byArray2 = new byte[n];
                Utils.readArray(byArray2, this.input);
                try {
                    byArray = controller.processCommand(this.address, byArray2);
                }
                catch (Throwable throwable) {
                    Debug.warning((String)("Exception in controller.processCommand: " + string + ": " + throwable));
                }
            } else {
                Debug.warning((String)("Unexpected controller: " + string));
            }
            if (byArray == null) {
                byArray = "HUH?".getBytes("ISO-8859-1");
            }
            Utils.writeInt(this.output, byArray.length);
            this.output.write(byArray);
            this.output.flush();
        }
    }

    private boolean processPingPongCase(String string) throws Exception {
        if (!string.equals("PingComConServer")) {
            return false;
        }
        this.debugPrint("Got a ping.");
        this.output.write("pong\n".getBytes("ISO-8859-1"));
        this.output.flush();
        this.debugPrint("pong is sent.");
        return true;
    }

    private boolean negotiateAddress(String string) throws Exception {
        boolean bl = true;
        this.debugPrint("negotiateAddress: address: " + string);
        Object var3_3 = null;
        if (string.equals("unspecified")) {
            string = Server.registerClient(this);
            Thread.currentThread().setName("Client Handler [" + string + "]");
        } else {
            Debug.warning((String)("Unexpected key for address: " + string));
            string = "HUH?";
            bl = false;
        }
        this.address = string;
        this.debugPrint("negotiateAddress: sending to client: " + string);
        this.output.write(string.getBytes("ISO-8859-1"));
        this.output.write("\n".getBytes("ISO-8859-1"));
        this.output.flush();
        return bl;
    }

    private void debugPrint(String string) {
        debug.println(3, "(" + this.address + "): " + string);
    }
}

