/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.comcon.share;

import com.sun.kvem.comcon.share.Client;
import com.sun.kvem.comcon.share.Server;
import com.sun.kvem.comcon.share.Utils;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.util.ToolkitResources;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

final class ClientConnector {
    private static final Debug debug = Debug.create((Class)ClientConnector.class);
    private static final int SERVER_IS_DEAD = 0;
    private static final int SERVER_IS_ALIVE = 1;
    private static final int SERVER_ALREADY_LAUNCHING = 2;
    private static final InetAddress serverHost;
    private static File fileLock;
    private boolean weLaunchedServer;
    private Socket controlSocket;
    private InputStream controlIn;
    private OutputStream controlOut;
    private Client parent;
    private boolean isClosed;

    ClientConnector(Client client) {
        this.parent = client;
    }

    static synchronized boolean ensureServerIsPresent() {
        int n = ClientConnector.getServerStatus();
        boolean bl = false;
        int n2 = 0;
        if (n == 1) {
            return false;
        }
        File file = new File(Server.STAT_FILE_NAME);
        debug.println(3, "ensureServerIsPresent: step1");
        if (n == 0) {
            debug.println(3, "step2: Launching the server...");
            try {
                Server.launch();
                debug.println(3, "step3: called Server.launch");
                bl = true;
                n2 = 1;
            }
            catch (Exception exception) {
                debug.exception(1, (Throwable)exception);
                exception.printStackTrace();
                System.err.println(ToolkitResources.getString((String)"COMCON_INIT_FAILED"));
                return false;
            }
        }
        if (n == 2) {
            try {
                ClientConnector.pingServer();
            }
            catch (IOException iOException) {
                debug.exception(4, (Throwable)iOException);
                debug.println(2, "Waiting for Server to activate...");
                n2 = 2;
            }
        }
        debug.println(3, "step4: needToWait=" + n2);
        if (n2 == 0) {
            return bl;
        }
        boolean bl2 = false;
        int n3 = 100;
        for (int i = 0; i < 5000; i += n3) {
            try {
                Thread.sleep(n3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!file.exists()) continue;
            bl2 = true;
            break;
        }
        debug.println(3, "step5: foundStatFile=" + bl2);
        if (n2 == 1) {
            if (bl2) {
                try {
                    Thread.sleep(n3);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                Thread.dumpStack();
                System.err.println(ToolkitResources.getString((String)"COMCON_INIT_FAILED"));
            }
            ClientConnector.releaseInterprocessLock();
        }
        debug.println(3, "ensureServerIsPresent: done: weLaunched=" + bl);
        return bl;
    }

    String connect() throws IOException {
        String string = null;
        debug.println(3, "connect: called...");
        long l = System.currentTimeMillis();
        try {
            this.weLaunchedServer = ClientConnector.ensureServerIsPresent();
            long l2 = System.currentTimeMillis();
            debug.println(3, "connect: ensureServerIsPresent time=" + (l2 - l));
            debug.println(1, "connect: weLaunchedServer = " + this.weLaunchedServer);
            int n = ClientConnector.getServerPort();
            debug.println(3, "connect: getServerPort() time=" + (System.currentTimeMillis() - l2));
            l2 = System.currentTimeMillis();
            this.controlSocket = new Socket(serverHost, n);
            this.controlIn = this.controlSocket.getInputStream();
            this.controlOut = this.controlSocket.getOutputStream();
            l2 = System.currentTimeMillis();
            debug.println(3, "Sending request for address...");
            this.controlOut.write("unspecified\n".getBytes("ISO-8859-1"));
            this.controlOut.flush();
            debug.println(3, "Reading address response...");
            string = Utils.readLine(this.controlIn);
            debug.println(3, "Response: " + string + "; time=" + (System.currentTimeMillis() - l2));
        }
        catch (IOException iOException) {
            debug.println(2, "releaseInterprocessLock in case of exception.");
            ClientConnector.releaseInterprocessLock();
            throw iOException;
        }
        debug.println(3, "connect: ensureServerIsPresent time=" + (System.currentTimeMillis() - l));
        return string;
    }

    void unregisterSpecial(String string) throws IOException {
        debug.println(3, "send UNREGISTER-SPECIAL request");
        this.controlOut.write("UNREGISTER-SPECIAL\n".getBytes("ISO-8859-1"));
        this.controlOut.flush();
        String string2 = Utils.readLine(this.controlIn);
        debug.println(3, "Response: " + string2);
        if (!string2.equals("OK")) {
            throw new IOException("Can't unregister client: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        ClientConnector clientConnector = this;
        synchronized (clientConnector) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        try {
            debug.println(3, "Saying good-bye...");
            this.controlOut.write("BYE-SERVER\n".getBytes("ISO-8859-1"));
            this.controlOut.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.controlSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.controlIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.controlOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean getWeLaunchedServer() {
        return this.weLaunchedServer;
    }

    synchronized byte[] processCommand(String string, byte[] byArray) throws IOException {
        this.controlOut.write(string.getBytes("ISO-8859-1"));
        this.controlOut.write("\n".getBytes("ISO-8859-1"));
        Utils.writeInt(this.controlOut, byArray.length);
        this.controlOut.write(byArray);
        this.controlOut.flush();
        int n = Utils.readInt(this.controlIn);
        byte[] byArray2 = new byte[n];
        Utils.readArray(byArray2, this.controlIn);
        debug.println(3, "Got response for {0}", (Object)string);
        return byArray2;
    }

    private static void pingServer() throws IOException {
        debug.println(3, "Pinging Server...");
        int n = ClientConnector.getServerPort();
        Socket socket = new Socket(serverHost, n);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        debug.println(3, "Sending ping now...");
        outputStream.write("PingComConServer\n".getBytes("ISO-8859-1"));
        outputStream.flush();
        debug.println(3, "ping is sent... getting response...");
        String string = Utils.readLine(inputStream);
        debug.println(3, "pong is got: " + string);
        inputStream.close();
        outputStream.close();
        socket.close();
        debug.println(4, "Got response: \"" + string + '\"');
        if (!string.equals("pong")) {
            throw new IOException("Not a Communication Controller Server.");
        }
    }

    private static int getServerStatus() {
        Object object;
        int n = 2;
        boolean bl = false;
        try {
            object = Server.STAT_FILE_NAME + ".lock";
            fileLock = new File((String)object);
            bl = fileLock.createNewFile();
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
        }
        if (!bl) {
            debug.println(2, "Server status is " + n);
            return n;
        }
        fileLock.deleteOnExit();
        debug.println(3, "Successfully created lockfile.");
        object = new File(Server.STAT_FILE_NAME);
        if (((File)object).canRead()) {
            try {
                ClientConnector.pingServer();
                ClientConnector.releaseInterprocessLock();
                n = 1;
            }
            catch (IOException iOException) {
                n = 0;
            }
        } else {
            n = 0;
        }
        debug.println(2, "Server status is " + n);
        return n;
    }

    private static int getServerPort() throws IOException {
        debug.println(2, "Reading server port from status file...");
        FileInputStream fileInputStream = new FileInputStream(Server.STAT_FILE_NAME);
        String string = Utils.readLine(fileInputStream);
        ((InputStream)fileInputStream).close();
        return Integer.parseInt(string);
    }

    private static void releaseInterprocessLock() {
        debug.println(3, "Cleaning up interprocess lock...");
        if (!fileLock.delete()) {
            Debug.error((String)("Can't remove a lock file: " + fileLock));
        }
        fileLock = null;
    }

    static {
        fileLock = null;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("ClientConnector: localhost has no IP address: " + unknownHostException);
        }
        serverHost = inetAddress;
    }
}

