/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.comcon.share;

import com.sun.kvem.comcon.share.ClientConnector;
import com.sun.kvem.environment.Debug;
import java.io.IOException;

public final class Client {
    private static final Debug debug = Debug.create((Class)Client.class);
    private static Client instance = null;
    private String address = "unspecified";
    private ClientConnector connector = new ClientConnector(this);

    private Client() {
    }

    public static synchronized Client getInstance() throws IOException {
        if (instance != null) {
            return instance;
        }
        instance = new Client();
        Client.instance.address = Client.instance.connector.connect();
        return instance;
    }

    public static boolean ensureServerIsPresent() {
        return ClientConnector.ensureServerIsPresent();
    }

    public synchronized byte[] processCommand(String string, byte[] byArray) throws IOException {
        if (this.connector == null) {
            throw new IOException("Client is not connected.");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid controller name: " + string);
        }
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Invalid command data");
        }
        byte[] byArray2 = null;
        try {
            byArray2 = this.connector.processCommand(string, byArray);
        }
        catch (IOException iOException) {
            this.disconnect();
            iOException.fillInStackTrace();
            throw iOException;
        }
        return byArray2;
    }

    public static boolean getWeLaunchedServer() {
        if (instance == null || Client.instance.connector == null) {
            return false;
        }
        return Client.instance.connector.getWeLaunchedServer();
    }

    public synchronized void disconnect() {
        if (this.connector == null) {
            return;
        }
        debug.println(3, "disconnecting client: address={0}", (Object)this.address);
        this.connector.disconnect();
        this.connector = null;
    }

    public synchronized void unregisterSpecial() throws IOException {
        if (this.connector == null) {
            throw new IOException("Client is not connected.");
        }
        debug.println(3, "unregisterSpecial: address={0}", (Object)this.address);
        try {
            this.connector.unregisterSpecial(this.address);
        }
        catch (IOException iOException) {
            this.disconnect();
            iOException.fillInStackTrace();
            throw iOException;
        }
    }
}

