/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.comcon.jsr082;

import com.sun.kvem.comcon.share.Client;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.PropertiesFile;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.util.ToolkitResources;
import java.io.File;
import java.io.IOException;

public final class JSR082Bridge {
    private static final Debug debug = Debug.create((Class)JSR082Bridge.class);
    private static Client client = null;
    private static final int IRDAOBEX_CLIENT = 1;
    private static final int BLUETOOTH_CLIENT = 2;
    private static final int DEVICE_INTERNAL_PROPERTIES = 17;
    private static final int DEVICE_SYSTEM_PROPERTIES = 18;
    private static final String[] irdaProps = new String[]{"irdaobex.packetLength", "irdaobex.discoveryTimeout"};
    private static final String[] btInternalProps = new String[]{"bluetooth.device.discovery.timeout", "bluetooth.enable", "bluetooth.device.discovery.enable", "bluetooth.device.friendlyName", "bluetooth.device.encryption", "bluetooth.device.authorization", "bluetooth.device.authentication", "bluetooth.device.address", "bluetooth.device.classRecord", "bluetooth.device.discoverable"};
    private static final String[] btSystemProps = new String[]{"bluetooth.l2cap.receiveMTU.max", "bluetooth.connected.devices.max", "bluetooth.sd.trans.max", "bluetooth.sd.attr.retrievable.max", "bluetooth.api.version", "bluetooth.master.switch", "bluetooth.connected.inquiry.scan", "bluetooth.connected.page.scan", "bluetooth.connected.inquiry", "bluetooth.connected.page"};
    private static PropertiesFile propsFile;

    public static boolean initializeJSR082Support() {
        Object object;
        boolean bl = true;
        long l = System.currentTimeMillis();
        debug.println(1, "initializeJSR082Support: client={0}", (Object)client);
        if (client != null) {
            Debug.warning((String)"The attempt to initialize JSR082Bridge again.");
            return false;
        }
        try {
            client = Client.getInstance();
        }
        catch (Exception exception) {
            debug.exception(1, (Throwable)exception);
            client = null;
            System.err.println(ToolkitResources.getString((String)"JSR082_INIT_FAILED"));
            bl = false;
        }
        try {
            object = new File(ToolkitDirs.LIB, "emulator.properties");
            propsFile = new PropertiesFile((File)object);
        }
        catch (IOException iOException) {
            Debug.warning((String)"Couldn't read emulator.properties");
            debug.exception(1, (Throwable)iOException);
            client = null;
            System.err.println(ToolkitResources.getString((String)"JSR082_INIT_FAILED"));
            bl = false;
        }
        if (propsFile != null) {
            propsFile.setProperty("bluetooth.device.address", "unspecified");
            propsFile.setProperty("bluetooth.device.classRecord", "204");
            propsFile.setProperty("bluetooth.device.discoverable", "0");
            object = "bluetooth.device.friendlyName";
            String string = propsFile.getProperty((String)object);
            if (string != null && string.trim().length() == 0) {
                propsFile.setProperty((String)object, "-u-n-d-e-f-i-n-e-d-");
            }
            propsFile.setProperty("bluetooth.api.version", "1.0");
            propsFile.setProperty("bluetooth.master.switch", "false");
            propsFile.setProperty("bluetooth.connected.inquiry", "false");
            propsFile.setProperty("bluetooth.connected.inquiry.scan", "false");
            propsFile.setProperty("bluetooth.connected.page", "false");
            propsFile.setProperty("bluetooth.connected.page.scan", "false");
        }
        debug.println(1, "initializeJSR082Support: time={0}", (int)(System.currentTimeMillis() - l));
        return bl;
    }

    public static void tearDownJSR082Support() {
        debug.println(1, "tearDownJSR082Support: client={0}", (Object)client);
        if (client == null) {
            Debug.warning((String)"The attempt to finalize unexisting client.");
            return;
        }
        client.disconnect();
        debug.println(1, "tearDownJSR082Support done");
        client = null;
    }

    public static boolean notifyJ2MERestarted() {
        boolean bl = false;
        debug.println(1, "notifyJ2MERestarted: client={0}", (Object)client);
        if (client == null) {
            Debug.warning((String)"Client is not initialized...");
            return false;
        }
        try {
            client.unregisterSpecial();
            bl = true;
        }
        catch (IOException iOException) {
            client = null;
        }
        debug.println(1, "notifyJ2MERestarted done: " + bl);
        return bl;
    }

    public static String processCommand(int n, String string) {
        if (client == null) {
            return null;
        }
        String string2 = null;
        switch (n) {
            case 1: {
                string2 = "com.sun.kvem.comcon.jsr082.IRDAOBEXController";
                break;
            }
            case 2: {
                string2 = "com.sun.kvem.comcon.jsr082.BTL2CAPController";
                break;
            }
            default: {
                Debug.warning((String)("Unsupported device type: " + n));
                return null;
            }
        }
        try {
            byte[] byArray = string.getBytes("ISO-8859-1");
            byte[] byArray2 = client.processCommand(string2, byArray);
            String string3 = new String(byArray2, "ISO-8859-1");
            return string3;
        }
        catch (IOException iOException) {
            client = null;
            return null;
        }
    }

    public static String getDeviceInfo(int n, int n2) {
        if (client == null) {
            return null;
        }
        switch (n2) {
            case 17: {
                if (n == 1) {
                    return JSR082Bridge.makePropertiesString(irdaProps);
                }
                if (n == 2) {
                    return JSR082Bridge.makePropertiesString(btInternalProps);
                }
                Debug.warning((String)("Unsupported device type: " + n));
                break;
            }
            case 18: {
                if (n == 1) {
                    Debug.warning((String)"Request for system properties for irdaobex");
                    break;
                }
                if (n == 2) {
                    return JSR082Bridge.makePropertiesString(btSystemProps);
                }
                Debug.warning((String)("Unsupported device type: " + n));
                break;
            }
            default: {
                Debug.warning((String)("Unsupported info type: " + n2));
            }
        }
        return null;
    }

    private static String makePropertiesString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = propsFile.getProperty(stringArray[i]);
            if (string == null) {
                System.err.println("Unexpected error: property is undefined: " + stringArray[i]);
                return null;
            }
            debug.println(3, stringArray[i] + "=" + string + ";");
            stringBuffer.append(stringArray[i]).append("\n");
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }
}

