/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.comcon.jsr082;

import com.sun.kvem.comcon.share.Controller;
import com.sun.kvem.comcon.share.Utils;
import com.sun.kvem.environment.Debug;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public final class IRDAOBEXController
implements Controller {
    private static Debug debug = Debug.create((Class)IRDAOBEXController.class);
    private static boolean isAlreadyCreated = false;
    private static final HashMap devices = new HashMap();
    private static final HashMap internal2irda = new HashMap();
    private static final ArrayList generatedAddresses = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRDAOBEXController() {
        Class clazz = IRDAOBEXController.class;
        synchronized (clazz) {
            if (isAlreadyCreated) {
                throw new IllegalStateException("Already created.");
            }
            isAlreadyCreated = true;
        }
    }

    public synchronized byte[] processCommand(String string, byte[] byArray) {
        String string2;
        debug.println(3, "process IrDA specific command for address: {0}", (Object)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < byArray.length; i += string2.length() + 1) {
            string2 = null;
            try {
                string2 = Utils.readLine(byArray, i);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            arrayList.add(string2);
        }
        string2 = (String)arrayList.remove(0);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        String string3 = null;
        try {
            string3 = this.dispatchCommand(string, string2, stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            debug.exception(3, (Throwable)illegalArgumentException);
        }
        byte[] byArray2 = null;
        if (string3 != null) {
            try {
                byArray2 = string3.getBytes("ISO-8859-1");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray2;
    }

    public synchronized void destroyClient(String string) {
        String string2 = (String)internal2irda.remove(string);
        debug.println(3, "destroyClient:");
        debug.println(3, "\tinternal_address: {0}", (Object)string);
        debug.println(3, "\taddress: {0}", (Object)string2);
        if (string2 == null) {
            return;
        }
        devices.remove(string2);
    }

    private String dispatchCommand(String string, String string2, String[] stringArray) {
        debug.println(3, "processCommand: {0}", (Object)string2);
        debug.println(3, "\targs.length={0}", stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            debug.println(3, "\targs[{0}]= " + stringArray[i], i);
        }
        try {
            if (string2.equals("getIrDADevicesAddresses")) {
                return IRDAOBEXController.getIrDADevicesAddresses(stringArray);
            }
            if (string2.equals("getIrDAConnection")) {
                return IRDAOBEXController.getIrDAConnection(stringArray);
            }
            if (string2.equals("registerIrDAService")) {
                return IRDAOBEXController.registerIrDAService(stringArray);
            }
            if (string2.equals("unregisterIrDAService")) {
                return IRDAOBEXController.unregisterIrDAService(stringArray);
            }
            if (string2.equals("registerIrDADevice")) {
                return IRDAOBEXController.registerIrDADevice(string, stringArray);
            }
            debug.println(3, "Wrong command: {0}", (Object)string2);
            throw new IllegalArgumentException("Wrong command: " + string2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        debug.println(3, "Wrong args for command: {0}", (Object)string2);
        StringBuffer stringBuffer = new StringBuffer("args.length=" + stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("; args[").append(i).append("]=").append(stringArray[i]);
        }
        throw new IllegalArgumentException("Wrong args for " + string2 + ": " + stringBuffer.toString());
    }

    private static String registerIrDADevice(String string, String[] stringArray) {
        if (stringArray.length != 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string2 = stringArray[0];
        if (!string2.equals("unspecified")) {
            throw new IllegalArgumentException();
        }
        string2 = IRDAOBEXController.generateIrDAAddress();
        internal2irda.put(string, string2);
        return string2;
    }

    private static String registerIrDAService(String[] stringArray) {
        if (stringArray.length != 4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        String string2 = stringArray[2];
        int n2 = Integer.parseInt(stringArray[3]);
        debug.println(3, "registerIrDAService:");
        debug.println(3, "\taddress: {0}", (Object)string);
        debug.println(3, "\thintbits: {0}", (Object)Integer.toHexString(n));
        debug.println(3, "\tias: {0}", (Object)string2);
        debug.println(3, "\tport: {0}", (Object)Integer.toHexString(n2));
        IRDAOBEXDevice iRDAOBEXDevice = (IRDAOBEXDevice)devices.get(string);
        if (iRDAOBEXDevice == null) {
            iRDAOBEXDevice = new IRDAOBEXDevice(string);
            debug.println(3, "new device: {0}", (Object)string);
            devices.put(string, iRDAOBEXDevice);
        } else {
            debug.println(3, "registered: {0}", (Object)string);
        }
        iRDAOBEXDevice.addConnection(n, string2, n2);
        return "OK";
    }

    private static String unregisterIrDAService(String[] stringArray) {
        if (stringArray.length != 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        debug.println(3, "unregisterIrDAService:");
        debug.println(3, "\taddress: {0}", (Object)string);
        debug.println(3, "\tport: {0}", (Object)Integer.toHexString(n));
        IRDAOBEXDevice iRDAOBEXDevice = (IRDAOBEXDevice)devices.get(string);
        if (iRDAOBEXDevice == null) {
            debug.println(1, "unregistered: {0}", (Object)string);
            return "HUH?";
        }
        iRDAOBEXDevice.removeConnection(n);
        if (!iRDAOBEXDevice.hasConnections()) {
            devices.remove(string);
        }
        return "OK";
    }

    private static String getIrDADevicesAddresses(String[] stringArray) {
        if (stringArray.length != 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        StringBuffer stringBuffer = new StringBuffer();
        IRDAOBEXDevice[] iRDAOBEXDeviceArray = new IRDAOBEXDevice[devices.size()];
        devices.values().toArray(iRDAOBEXDeviceArray);
        debug.println(3, "getIrDADevicesAddresses:");
        debug.println(3, "\tdevices.size()={0}", devices.size());
        for (int i = 0; i < iRDAOBEXDeviceArray.length; ++i) {
            if (iRDAOBEXDeviceArray[i].address.equals(string)) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(iRDAOBEXDeviceArray[i].address);
        }
        debug.println(3, "\tres={0}", (Object)stringBuffer);
        return stringBuffer.toString();
    }

    private static String getIrDAConnection(String[] stringArray) {
        if (stringArray.length != 3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        String string2 = stringArray[2];
        IRDAOBEXDevice iRDAOBEXDevice = (IRDAOBEXDevice)devices.get(string);
        if (iRDAOBEXDevice == null) {
            debug.println(1, "unregistered: {0}", (Object)string);
            return "";
        }
        return iRDAOBEXDevice.getConnection(n, string2);
    }

    private static synchronized String generateIrDAAddress() {
        long l = 0xFFFFFFFFL;
        String string = null;
        do {
            long l2;
            if ((l2 = Math.round(Math.random() * (double)l)) == 0L || l2 == l) continue;
            string = Long.toHexString(l2);
            while (string.length() < 2) {
                string = "0" + string;
            }
        } while (generatedAddresses.contains(string));
        generatedAddresses.add(string);
        debug.println(3, "generated address: {0}", (Object)string);
        return string;
    }

    static class IRDAOBEXDevice {
        String address;
        int hintbits;
        ArrayList portStorage = new ArrayList();
        ArrayList hintbitsStorage = new ArrayList();
        ArrayList iasStorage = new ArrayList();

        IRDAOBEXDevice(String string) {
            this.address = string;
            this.hintbits = 512;
            debug.println(3, "created: {0}", (Object)this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("IRDAOBEXDevice");
            stringBuffer.append("(").append(this.address).append(")");
            stringBuffer.append("[").append(Integer.toString(this.hintbits, 16)).append("]");
            stringBuffer.append(": connNum=").append(Integer.toString(this.portStorage.size()));
            return stringBuffer.toString();
        }

        void addConnection(int n, String string, int n2) {
            debug.println(3, "addConnection: {0}", (Object)this);
            debug.println(3, "\thintbits: {0}", (Object)Integer.toHexString(n));
            debug.println(3, "\tias: {0}", (Object)string);
            debug.println(3, "\tport: {0}", (Object)Integer.toHexString(n2));
            this.portStorage.add(new Integer(n2));
            this.hintbitsStorage.add(new Integer(n &= 0x7F7F7F7F));
            String[] stringArray = string.split(",");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(this.transformIAS(stringArray[i]));
            }
            this.iasStorage.add(arrayList);
            this.hintbits |= n;
        }

        void removeConnection(int n) {
            debug.println(3, "removeConnection: {0}", (Object)this);
            debug.println(3, "\tport: {0}", (Object)Integer.toHexString(n));
            int n2 = this.portStorage.indexOf(new Integer(n));
            if (n2 == -1) {
                debug.println(1, "unregistered: {0}", n);
                return;
            }
            this.portStorage.remove(n2);
            this.iasStorage.remove(n2);
            this.hintbitsStorage.remove(n2);
            this.hintbits = 512;
            for (int i = 0; i < this.hintbitsStorage.size(); ++i) {
                this.hintbits |= ((Integer)this.hintbitsStorage.get(i)).intValue();
            }
        }

        String getConnection(int n, String string) {
            int n2;
            debug.println(3, "getConnection: {0}", (Object)this);
            debug.println(3, "\thintbits: {0}", (Object)Integer.toHexString(n));
            debug.println(3, "\tias: {0}", (Object)string);
            boolean bl = ((n &= 0x7F7F7F7F) & ~this.hintbits) == 0;
            debug.println(3, "\thintbits matched=" + bl);
            if (!bl) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = string.split(",");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray[n2] = this.transformIAS(stringArray[n2]);
            }
            for (n2 = 0; n2 < this.iasStorage.size(); ++n2) {
                ArrayList arrayList = (ArrayList)this.iasStorage.get(n2);
                if (!this.compareIAS(stringArray, arrayList)) continue;
                Integer n3 = (Integer)this.portStorage.get(n2);
                stringBuffer.append(n3.toString()).append(',');
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            return stringBuffer.toString();
        }

        boolean hasConnections() {
            return this.iasStorage.size() != 0;
        }

        private boolean compareIAS(String[] stringArray, ArrayList arrayList) {
            debug.println(4, "compareIAS");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() == 0) continue;
                boolean bl = arrayList.contains(stringArray[i]);
                debug.println(4, "\ttest: {0}", (Object)stringArray[i]);
                debug.println(4, "\tres : " + bl);
                if (!bl) continue;
                return true;
            }
            return false;
        }

        private String transformIAS(String string) {
            try {
                byte[] byArray = string.getBytes("ISO-8859-1");
                int n = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] != 37) continue;
                    ++n;
                }
                if (n == 0) {
                    return string;
                }
                byte[] byArray2 = new byte[byArray.length - 2 * n];
                int n2 = 0;
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray[n2] == 37) {
                        byArray2[i] = (byte)(this.parseHexByte(byArray[n2 + 1]) << 4);
                        int n3 = i;
                        byArray2[n3] = (byte)(byArray2[n3] | this.parseHexByte(byArray[n2 + 2]));
                        n2 += 3;
                        continue;
                    }
                    byArray2[i] = byArray[n2];
                    ++n2;
                }
                return new String(byArray2, "ISO-8859-1");
            }
            catch (Throwable throwable) {
                debug;
                Debug.warning((String)("Unexpected error: " + throwable));
                throwable.printStackTrace();
                return "";
            }
        }

        private byte parseHexByte(byte by) {
            if (by >= 48 && by <= 57) {
                return (byte)(by - 48);
            }
            if (by >= 65 && by <= 70) {
                return (byte)(by - 65 + 10);
            }
            if (by >= 97 && by <= 102) {
                return (byte)(by - 97 + 10);
            }
            debug;
            Debug.warning((String)("Unexpected byte in parseHexByte: " + by));
            return 0;
        }
    }
}

