/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.comcon.jsr082;

import com.sun.kvem.comcon.share.Controller;
import com.sun.kvem.comcon.share.Utils;
import com.sun.kvem.environment.Debug;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public final class BTL2CAPController
implements Controller {
    private static Debug debug = Debug.create((Class)BTL2CAPController.class);
    private static boolean isAlreadyCreated = false;
    private static final HashMap devices = new HashMap();
    private static final HashMap internal2bt = new HashMap();
    private static final ArrayList addressesUnderUse = new ArrayList();
    private static String firstAddress = "0123456789AF";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BTL2CAPController() {
        Class clazz = BTL2CAPController.class;
        synchronized (clazz) {
            if (isAlreadyCreated) {
                throw new IllegalStateException("Already created.");
            }
            isAlreadyCreated = true;
        }
    }

    public synchronized byte[] processCommand(String string, byte[] byArray) {
        String string2;
        debug.println(3, "========================================");
        debug.println(3, "process Bluetooth specific command for internal address: {0}", (Object)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < byArray.length; i += string2.length() + 1) {
            string2 = null;
            try {
                string2 = Utils.readLine(byArray, i);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            arrayList.add(string2);
        }
        string2 = (String)arrayList.remove(0);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        String string3 = null;
        try {
            string3 = this.dispatchCommand(string, string2, stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            debug.exception(3, (Throwable)illegalArgumentException);
        }
        byte[] byArray2 = null;
        if (string3 != null) {
            try {
                byArray2 = string3.getBytes("ISO-8859-1");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray2;
    }

    public synchronized void destroyClient(String string) {
        String string2 = (String)internal2bt.remove(string);
        debug.println(3, "========================================");
        debug.println(3, "destroyClient:");
        debug.println(3, "\tinternal_address: {0}", (Object)string);
        debug.println(3, "\taddress: {0}", (Object)string2);
        if (string2 == null) {
            return;
        }
        devices.remove(string2);
    }

    private String dispatchCommand(String string, String string2, String[] stringArray) {
        debug.println(3, "processCommand: {0}", (Object)string2);
        debug.println(3, "\targs.length={0}", stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            debug.println(3, "\targs[{0}]= " + stringArray[i], i);
        }
        try {
            if (string2.equals("registerBTDevice")) {
                return BTL2CAPController.registerBTDevice(string, stringArray);
            }
            if (string2.equals("updateDeviceClass")) {
                return BTL2CAPController.updateDeviceClass(stringArray);
            }
            if (string2.equals("getFriendlyName")) {
                return BTL2CAPController.getFriendlyName(stringArray);
            }
            if (string2.equals("discoverBTDevices")) {
                return BTL2CAPController.discoverBTDevices(string, stringArray);
            }
            if (string2.equals("setBTDeviceAccessCode")) {
                return BTL2CAPController.setBTDeviceAccessCode(stringArray);
            }
            if (string2.equals("registerBTL2CAPNotifier")) {
                return BTL2CAPController.registerBTL2CAPNotifier(stringArray);
            }
            if (string2.equals("unregisterBTL2CAPNotifier")) {
                return BTL2CAPController.unregisterBTL2CAPNotifier(stringArray);
            }
            if (string2.equals("getBTL2CAPNotifierPort")) {
                return BTL2CAPController.getBTL2CAPNotifierPort(stringArray);
            }
            if (string2.equals("registerBTSPPNotifier")) {
                return BTL2CAPController.registerBTSPPNotifier(stringArray);
            }
            if (string2.equals("unregisterBTSPPNotifier")) {
                return BTL2CAPController.unregisterBTSPPNotifier(stringArray);
            }
            if (string2.equals("getBTSPPNotifierPort")) {
                return BTL2CAPController.getBTSPPNotifierPort(stringArray);
            }
            if (string2.equals("registerSecurityListener")) {
                return BTL2CAPController.registerSecurityListener(stringArray);
            }
            if (string2.equals("getSecurityListenerPort")) {
                return BTL2CAPController.getSecurityListenerPort(stringArray);
            }
            debug.println(3, "Wrong command: {0}", (Object)string2);
            throw new IllegalArgumentException("Wrong command: " + string2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        debug.println(3, "Wrong args for command: {0}", (Object)string2);
        StringBuffer stringBuffer = new StringBuffer("args.length=" + stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("; args[").append(i).append("]=").append(stringArray[i]);
        }
        throw new IllegalArgumentException("Wrong args for " + string2 + ": " + stringBuffer.toString());
    }

    private static String registerBTDevice(String string, String[] stringArray) {
        String string2;
        if (stringArray.length != 3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string3 = stringArray[0].toLowerCase();
        int n = Integer.parseInt(stringArray[1]);
        String string4 = stringArray[2];
        if (string3.equals("unspecified")) {
            string2 = string3 = BTL2CAPController.generateBTAddress();
        } else {
            addressesUnderUse.add(string3);
            string2 = "OK";
        }
        BTL2CAPDevice bTL2CAPDevice = (BTL2CAPDevice)devices.get(string3);
        if (bTL2CAPDevice == null) {
            bTL2CAPDevice = new BTL2CAPDevice(string3, n, string4);
            debug.println(3, "new device: {0}", (Object)string3);
            devices.put(string3, bTL2CAPDevice);
        } else {
            Debug.warning((String)("Already registered: " + string3));
        }
        internal2bt.put(string, string3);
        return string2;
    }

    private static String updateDeviceClass(String[] stringArray) {
        if (stringArray.length != 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        debug.println(3, "updateDeviceClass:");
        debug.println(3, "\taddress: {0}", (Object)string);
        debug.println(3, "\tdeviceClass: 0x{0}", (Object)Integer.toHexString(n));
        BTL2CAPDevice bTL2CAPDevice = (BTL2CAPDevice)devices.get(string);
        if (bTL2CAPDevice == null) {
            String string2 = "Unregistered device: " + string;
            Debug.warning((String)string2);
            throw new IllegalArgumentException(string2);
        }
        bTL2CAPDevice.deviceClass = n;
        return "OK";
    }

    private static String getFriendlyName(String[] stringArray) {
        if (stringArray.length != 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        debug.println(3, "getFriendlyName:");
        debug.println(3, "\tremote address: {0}", (Object)string);
        BTL2CAPDevice bTL2CAPDevice = (BTL2CAPDevice)devices.get(string);
        if (bTL2CAPDevice == null) {
            debug.println(1, "unregistered: {0}", (Object)string);
            return "";
        }
        return bTL2CAPDevice.friendlyName;
    }

    private static String registerBTL2CAPNotifier(String[] stringArray) {
        if (stringArray.length != 3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        debug.println(3, "registerBTL2CAPNotifier:");
        debug.println(3, "\taddress: {0}", (Object)string);
        debug.println(3, "\tpsm: 0x{0}", (Object)Integer.toHexString(n));
        debug.println(3, "\tport: 0x{0}", (Object)Integer.toHexString(n2));
        BTL2CAPDevice bTL2CAPDevice = (BTL2CAPDevice)devices.get(string);
        if (bTL2CAPDevice == null) {
            String string2 = "Unregistered device: " + string;
            Debug.warning((String)string2);
            throw new IllegalArgumentException(string2);
        }
        bTL2CAPDevice.addL2CAPConnection(n, n2);
        return "OK";
    }

    private static String unregisterBTL2CAPNotifier(String[] stringArray) {
        if (stringArray.length != 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        debug.println(3, "unregisterBTL2CAPNotifier:");
        debug.println(3, "\taddress: {0}", (Object)string);
        debug.println(3, "\tport: 0x{0}", (Object)Integer.toHexString(n));
        BTL2CAPDevice bTL2CAPDevice = (BTL2CAPDevice)devices.get(string);
        if (bTL2CAPDevice == null) {
            String string2 = "Unregistered device: " + string;
            Debug.warning((String)string2);
            throw new IllegalArgumentException(string2);
        }
        bTL2CAPDevice.removeL2CAPConnection(n);
        return "OK";
    }

    private static String getBTL2CAPNotifierPort(String[] stringArray) {
        if (stringArray.length != 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        BTL2CAPDevice bTL2CAPDevice = (BTL2CAPDevice)devices.get(string);
        if (bTL2CAPDevice == null) {
            debug.println(1, "unregistered: {0}", (Object)string);
            return "";
        }
        return bTL2CAPDevice.getL2CAPConnection(n);
    }

    private static String registerBTSPPNotifier(String[] stringArray) {
        if (stringArray.length != 3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        debug.println(3, "registerBTSPPNotifier:");
        debug.println(3, "\taddress: {0}", (Object)string);
        debug.println(3, "\tpsm: 0x{0}", (Object)Integer.toHexString(n));
        debug.println(3, "\tport: 0x{0}", (Object)Integer.toHexString(n2));
        BTL2CAPDevice bTL2CAPDevice = (BTL2CAPDevice)devices.get(string);
        if (bTL2CAPDevice == null) {
            String string2 = "Unregistered device: " + string;
            Debug.warning((String)string2);
            throw new IllegalArgumentException(string2);
        }
        bTL2CAPDevice.addSPPConnection(n, n2);
        return "OK";
    }

    private static String unregisterBTSPPNotifier(String[] stringArray) {
        if (stringArray.length != 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        debug.println(3, "unregisterBTSPPNotifier:");
        debug.println(3, "\taddress: {0}", (Object)string);
        debug.println(3, "\tport: 0x{0}", (Object)Integer.toHexString(n));
        BTL2CAPDevice bTL2CAPDevice = (BTL2CAPDevice)devices.get(string);
        if (bTL2CAPDevice == null) {
            String string2 = "Unregistered device: " + string;
            Debug.warning((String)string2);
            throw new IllegalArgumentException(string2);
        }
        bTL2CAPDevice.removeSPPConnection(n);
        return "OK";
    }

    private static String getBTSPPNotifierPort(String[] stringArray) {
        if (stringArray.length != 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        BTL2CAPDevice bTL2CAPDevice = (BTL2CAPDevice)devices.get(string);
        if (bTL2CAPDevice == null) {
            debug.println(1, "unregistered: {0}", (Object)string);
            return "";
        }
        return bTL2CAPDevice.getSPPConnection(n);
    }

    private static String registerSecurityListener(String[] stringArray) {
        if (stringArray.length != 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        debug.println(3, "registerSecurityListener:");
        debug.println(3, "\taddress: {0}", (Object)string);
        debug.println(3, "\tport: 0x{0}", (Object)Integer.toHexString(n));
        BTL2CAPDevice bTL2CAPDevice = (BTL2CAPDevice)devices.get(string);
        if (bTL2CAPDevice == null) {
            String string2 = "Unregistered device: " + string;
            Debug.warning((String)string2);
            throw new IllegalArgumentException(string2);
        }
        bTL2CAPDevice.setSecurityListener(n);
        return "OK";
    }

    private static String getSecurityListenerPort(String[] stringArray) {
        if (stringArray.length != 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        BTL2CAPDevice bTL2CAPDevice = (BTL2CAPDevice)devices.get(string);
        if (bTL2CAPDevice == null) {
            debug.println(1, "unregistered: {0}", (Object)string);
            return "";
        }
        return bTL2CAPDevice.getSecurityListener();
    }

    private static String discoverBTDevices(String string, String[] stringArray) {
        if (stringArray.length != 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = Integer.parseInt(stringArray[0]);
        StringBuffer stringBuffer = new StringBuffer();
        BTL2CAPDevice[] bTL2CAPDeviceArray = new BTL2CAPDevice[devices.size()];
        devices.values().toArray(bTL2CAPDeviceArray);
        debug.println(3, "discoverBTDevices:");
        debug.println(3, "\taccessCode = 0x{0}", (Object)Integer.toHexString(n));
        debug.println(3, "\tdevices.size()={0}", devices.size());
        String string2 = (String)internal2bt.get(string);
        for (int i = 0; i < bTL2CAPDeviceArray.length; ++i) {
            if (bTL2CAPDeviceArray[i].address.equals(string2) || bTL2CAPDeviceArray[i].deviceMode != n) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(bTL2CAPDeviceArray[i].address);
            stringBuffer.append(':');
            stringBuffer.append(Integer.toString(bTL2CAPDeviceArray[i].deviceClass));
        }
        debug.println(3, "\tres={0}", (Object)stringBuffer);
        return stringBuffer.toString();
    }

    private static String setBTDeviceAccessCode(String[] stringArray) {
        if (stringArray.length != 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        debug.println(3, "setBTDeviceAccessCode:");
        debug.println(3, "\taddress: {0}", (Object)string);
        debug.println(3, "\taccessCode: 0x{0}", (Object)Integer.toHexString(n));
        BTL2CAPDevice bTL2CAPDevice = (BTL2CAPDevice)devices.get(string);
        if (bTL2CAPDevice == null) {
            String string2 = "Unregistered device: " + string;
            Debug.warning((String)string2);
            throw new IllegalArgumentException(string2);
        }
        bTL2CAPDevice.deviceMode = n;
        return "OK";
    }

    private static synchronized String generateBTAddress() {
        if (firstAddress != null) {
            addressesUnderUse.add(firstAddress);
            String string = firstAddress;
            firstAddress = null;
            return string;
        }
        long l = 0xFFFFFFFFL;
        String string = null;
        do {
            long l2;
            if ((l2 = Math.round(Math.random() * (double)l)) == 0L || l2 == l) continue;
            string = Long.toHexString(l2);
            string = string.toUpperCase();
            while (string.length() < 12) {
                string = "0" + string;
            }
        } while (addressesUnderUse.contains(string));
        addressesUnderUse.add(string);
        debug.println(3, "generated address: {0}", (Object)string);
        return string;
    }

    static class BTL2CAPDevice {
        String address;
        String friendlyName;
        int deviceMode;
        int deviceClass;
        ArrayList l2cap_portStorage = new ArrayList();
        ArrayList l2cap_psmStorage = new ArrayList();
        ArrayList spp_portStorage = new ArrayList();
        ArrayList spp_cidStorage = new ArrayList();
        int securityListener = 0;

        BTL2CAPDevice(String string, int n, String string2) {
            this.address = string;
            this.deviceClass = n;
            this.friendlyName = string2;
            this.deviceMode = 0;
            debug.println(3, "created: {0}", (Object)this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("BTL2CAPDevice");
            stringBuffer.append("[address=").append(this.address).append(", ");
            stringBuffer.append("name=").append(this.friendlyName);
            stringBuffer.append(", ");
            stringBuffer.append("class=0x").append(Integer.toString(this.deviceClass, 16));
            stringBuffer.append(", ");
            stringBuffer.append("mode=0x").append(Integer.toString(this.deviceMode, 16));
            stringBuffer.append(", ");
            stringBuffer.append("l2cap conn num=").append(Integer.toString(this.l2cap_portStorage.size()));
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        void addL2CAPConnection(int n, int n2) {
            debug.println(3, "addL2CAPConnection: {0}", (Object)this);
            debug.println(3, "\tpsm : 0x{0}", (Object)Integer.toHexString(n));
            debug.println(3, "\tport: 0x{0}", (Object)Integer.toHexString(n2));
            this.l2cap_psmStorage.add(new Integer(n));
            this.l2cap_portStorage.add(new Integer(n2));
        }

        void removeL2CAPConnection(int n) {
            debug.println(3, "removeL2CAPConnection: {0}", (Object)this);
            debug.println(3, "\tport: 0x{0}", (Object)Integer.toHexString(n));
            int n2 = this.l2cap_portStorage.indexOf(new Integer(n));
            if (n2 == -1) {
                debug.println(1, "unregistered: {0}", n);
                return;
            }
            this.l2cap_portStorage.remove(n2);
            this.l2cap_psmStorage.remove(n2);
        }

        String getL2CAPConnection(int n) {
            debug.println(3, "getL2CAPConnection: {0}", (Object)this);
            debug.println(3, "\tpsm: 0x{0}", (Object)Integer.toHexString(n));
            int n2 = this.l2cap_psmStorage.indexOf(new Integer(n));
            if (n2 == -1) {
                debug.println(1, "psm not found: {0}", n);
                return "";
            }
            return ((Integer)this.l2cap_portStorage.get(n2)).toString();
        }

        void addSPPConnection(int n, int n2) {
            debug.println(3, "addSPPConnection: {0}", (Object)this);
            debug.println(3, "\tcid : 0x{0}", (Object)Integer.toHexString(n));
            debug.println(3, "\tport: 0x{0}", (Object)Integer.toHexString(n2));
            this.spp_cidStorage.add(new Integer(n));
            this.spp_portStorage.add(new Integer(n2));
        }

        void removeSPPConnection(int n) {
            debug.println(3, "removeSPPConnection: {0}", (Object)this);
            debug.println(3, "\tport: 0x{0}", (Object)Integer.toHexString(n));
            int n2 = this.spp_portStorage.indexOf(new Integer(n));
            if (n2 == -1) {
                debug.println(1, "unregistered: {0}", n);
                return;
            }
            this.spp_portStorage.remove(n2);
            this.spp_cidStorage.remove(n2);
        }

        String getSPPConnection(int n) {
            debug.println(3, "getSPPConnection: {0}", (Object)this);
            debug.println(3, "\tcid: 0x{0}", (Object)Integer.toHexString(n));
            int n2 = this.spp_cidStorage.indexOf(new Integer(n));
            if (n2 == -1) {
                debug.println(1, "cid not found: {0}", n);
                return "";
            }
            return ((Integer)this.spp_portStorage.get(n2)).toString();
        }

        void setSecurityListener(int n) {
            debug.println(3, "setSecurityListener: {0}", (Object)this);
            debug.println(3, "\tport: 0x{0}", (Object)Integer.toHexString(n));
            this.securityListener = n;
        }

        String getSecurityListener() {
            debug.println(3, "getSecurityListener: {0}", (Object)this);
            return Integer.toString(this.securityListener);
        }
    }
}

