/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.cldc.i18n.j2me;

import com.sun.kvem.Device;
import com.sun.kvem.environment.Debug;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ConverterBridge {
    private static Map encoders = new HashMap();
    private static Map decoders = new HashMap();
    private static Map encodingBuffers = new HashMap();
    private static Map decodingBuffers = new HashMap();
    private static ThreadLocal byteBufferLocal = new ThreadLocal();
    private static ThreadLocal charBufferLocal = new ThreadLocal();
    private static final Integer UNIQUE_ID = new Integer(-1);
    private static Set supportedSet = null;
    public static final int BYTE_TO_CHAR = 0;
    public static final int CHAR_TO_BYTE = 1;
    private static final Debug debug = Debug.create((Class)ConverterBridge.class);

    private static ByteBuffer getByteBuffer(int n) {
        ByteBuffer byteBuffer = (ByteBuffer)byteBufferLocal.get();
        if (byteBuffer == null || byteBuffer.capacity() < n) {
            byteBuffer = ByteBuffer.allocate(n);
            byteBufferLocal.set(byteBuffer);
        } else {
            byteBuffer.clear();
        }
        return byteBuffer;
    }

    private static CharBuffer getCharBuffer(int n) {
        CharBuffer charBuffer = (CharBuffer)charBufferLocal.get();
        if (charBuffer == null || charBuffer.capacity() < n) {
            charBuffer = CharBuffer.allocate(n);
            charBufferLocal.set(charBuffer);
        } else {
            charBuffer.clear();
        }
        return charBuffer;
    }

    private static CharsetDecoder getDecoder(String string, Integer n) {
        CharsetDecoder charsetDecoder = (CharsetDecoder)decoders.get(n);
        if (charsetDecoder == null) {
            Charset charset = Charset.forName(string);
            charsetDecoder = charset.newDecoder();
            CharsetEncoder charsetEncoder = charset.newEncoder();
            charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            if (!n.equals(UNIQUE_ID)) {
                decoders.put(n, charsetDecoder);
            }
            int n2 = (int)Math.ceil(charsetEncoder.maxBytesPerChar());
            decodingBuffers.put(n, ByteBuffer.allocate(n2));
        }
        return charsetDecoder;
    }

    public static CharBuffer byteToCharArray(ByteBuffer byteBuffer, String string, Integer n) {
        Object object;
        if (debug.level(4)) {
            debug.println(4, "id {0}, decoding {1}", (Object)n, (Object)string);
            debug.println(4, "{0} bytes in input", byteBuffer.remaining());
            try {
                object = new String(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining(), string);
                debug.println(4, "Input: {0}", object);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                debug.exception(4, (Throwable)unsupportedEncodingException);
            }
        }
        object = ConverterBridge.getDecoder(string, n);
        ByteBuffer byteBuffer2 = (ByteBuffer)decodingBuffers.get(n);
        CharBuffer charBuffer = ConverterBridge.getCharBuffer(byteBuffer.remaining());
        byteBuffer2.flip();
        debug.println(4, "Decoding buffer: {0}", (Object)byteBuffer2);
        debug.println(4, "Input buffer: {0}", (Object)byteBuffer);
        ByteBuffer byteBuffer3 = ConverterBridge.getByteBuffer(byteBuffer2.remaining() + byteBuffer.remaining());
        byteBuffer3.put(byteBuffer2);
        byteBuffer3.put(byteBuffer);
        byteBuffer2.clear();
        byteBuffer3.flip();
        debug.println(4, "data to decode: {0}", (Object)byteBuffer3);
        boolean bl = false;
        while (!bl) {
            CoderResult coderResult = ((CharsetDecoder)object).decode(byteBuffer3, charBuffer, n.equals(UNIQUE_ID));
            if (coderResult == CoderResult.OVERFLOW) {
                CharBuffer charBuffer2 = ConverterBridge.getCharBuffer(charBuffer.capacity() * 2);
                charBuffer.flip();
                charBuffer2.put(charBuffer);
                charBuffer = charBuffer2;
                debug.println(4, "New output buffer: position={0}, capacity={1}", charBuffer.position(), charBuffer.capacity());
                continue;
            }
            bl = true;
            if (byteBuffer3.remaining() <= 0) continue;
            if (byteBuffer2.capacity() < byteBuffer3.remaining()) {
                byteBuffer2 = ByteBuffer.allocate(byteBuffer3.remaining());
                decodingBuffers.put(n, byteBuffer2);
            }
            byteBuffer2.put(byteBuffer3);
        }
        charBuffer.flip();
        if (debug.level(4)) {
            debug.println(4, "{0} bytes in output", charBuffer.remaining());
            debug.println(4, "Output: {0}", (Object)charBuffer);
        }
        return charBuffer;
    }

    public static void openDecodingStream(Integer n, String string) {
        debug.println(4, "Opening stream for id {0}, decoding {1}", (Object)n, (Object)string);
        ConverterBridge.getDecoder(string, n);
    }

    public static void closeDecodingStream(Integer n) {
        debug.println(4, "Discarding encoder {0}", (Object)n);
        decoders.remove(n);
        decodingBuffers.remove(n);
    }

    public static void closeEncodingStream(Integer n) {
        debug.println(4, "Discarding decoder {0}", (Object)n);
        encoders.remove(n);
        encodingBuffers.remove(n);
    }

    public static int readCharFromStream(Integer n, byte by) {
        Buffer buffer;
        debug.println(4, "Id = {0}, byte = {1}", (Object)n, (int)by);
        CharsetDecoder charsetDecoder = ConverterBridge.getDecoder(null, n);
        Buffer buffer2 = (ByteBuffer)decodingBuffers.get(n);
        if (buffer2.remaining() == 0) {
            debug.println(4, "Expanding decodingBuffer for id {0}", (Object)n);
            buffer = ByteBuffer.allocate(buffer2.capacity() * 2);
            ((ByteBuffer)buffer).put((ByteBuffer)buffer2);
            decodingBuffers.put(n, buffer);
            buffer2 = buffer;
        }
        buffer = ConverterBridge.getCharBuffer(1);
        ((CharBuffer)buffer).limit(1);
        ((ByteBuffer)buffer2).put(by);
        ((ByteBuffer)buffer2).flip();
        charsetDecoder.decode((ByteBuffer)buffer2, (CharBuffer)buffer, false);
        debug.println(4, "decodingBuffer: {0}", (Object)buffer2);
        ((ByteBuffer)buffer2).compact();
        int n2 = buffer.position() == 0 ? -1 : (int)((CharBuffer)buffer).get(0);
        debug.println(4, "Returning {0}", n2);
        return n2;
    }

    public static int sizeOfByteArray(ByteBuffer byteBuffer, String string) {
        CharBuffer charBuffer = ConverterBridge.byteToCharArray(byteBuffer, string, UNIQUE_ID);
        return charBuffer == null ? 0 : charBuffer.remaining();
    }

    public static ByteBuffer charToByteArray(CharBuffer charBuffer, String string, Integer n) {
        CharsetEncoder charsetEncoder;
        if (debug.level(4)) {
            debug.println(4, "id {0}, encoding {1}", (Object)n, (Object)string);
            debug.println(4, "{0} chars in input", charBuffer.remaining());
            debug.println(4, "Input: {0}", (Object)charBuffer);
        }
        if ((charsetEncoder = (CharsetEncoder)encoders.get(n)) == null) {
            debug.println(4, "Creating a new encoder");
            charsetEncoder = Charset.forName(string).newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            if (!n.equals(UNIQUE_ID)) {
                encoders.put(n, charsetEncoder);
            }
        }
        Buffer buffer = (CharBuffer)encodingBuffers.get(n);
        ByteBuffer byteBuffer = ConverterBridge.getByteBuffer(charBuffer.remaining());
        boolean bl = false;
        while (!bl) {
            Buffer buffer2;
            CoderResult coderResult;
            if (buffer != null) {
                charsetEncoder.encode((CharBuffer)buffer, byteBuffer, false);
                buffer.compact();
            }
            try {
                coderResult = charsetEncoder.encode(charBuffer, byteBuffer, n.equals(UNIQUE_ID));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                coderResult = null;
            }
            if (coderResult == CoderResult.OVERFLOW) {
                buffer2 = ConverterBridge.getByteBuffer(byteBuffer.capacity() * 2);
                byteBuffer.flip();
                ((ByteBuffer)buffer2).put(byteBuffer);
                byteBuffer = buffer2;
                if (!n.equals(UNIQUE_ID)) continue;
                debug.println(4, "Resetting encoder");
                charsetEncoder.reset();
                continue;
            }
            bl = true;
            if (charBuffer.remaining() != 0) {
                if (buffer == null) {
                    buffer = CharBuffer.allocate(Math.min(16, charBuffer.remaining()));
                    encodingBuffers.put(n, buffer);
                } else if (buffer.remaining() < charBuffer.remaining()) {
                    buffer2 = CharBuffer.allocate(buffer.capacity() * 2);
                    ((CharBuffer)buffer2).put((CharBuffer)buffer);
                    buffer = buffer2;
                    encodingBuffers.put(n, buffer);
                }
                buffer.put(charBuffer);
                buffer.flip();
                continue;
            }
            if (buffer == null) continue;
            buffer.clear();
        }
        byteBuffer.flip();
        if (debug.level(4)) {
            debug.println(4, "{0} bytes in output", byteBuffer.remaining());
            try {
                String string2 = new String(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining(), string);
                debug.println(4, "Output: {0}", (Object)string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                debug.exception(4, (Throwable)unsupportedEncodingException);
            }
        }
        return byteBuffer;
    }

    public static int sizeOfCharArray(CharBuffer charBuffer, String string) {
        ByteBuffer byteBuffer = ConverterBridge.charToByteArray(charBuffer, string, UNIQUE_ID);
        return byteBuffer.remaining();
    }

    public static int getMinimumBytes(Integer n, int n2) {
        float f = ConverterBridge.getDecoder(null, n).maxCharsPerByte();
        return (int)Math.ceil((double)f * (double)n2);
    }

    public static int checkEncoding(int n, String string) {
        if (!ConverterBridge.isSupportedByDevice(string) || !ConverterBridge.isSupportedByJ2SE(n, string)) {
            return -1;
        }
        switch (n) {
            case 1: {
                return (int)Math.ceil(Charset.forName(string).newDecoder().maxCharsPerByte());
            }
            case 0: {
                return (int)Math.ceil(Charset.forName(string).newEncoder().maxBytesPerChar());
            }
        }
        throw new IllegalArgumentException("Illegal type: " + n);
    }

    private static boolean isSupportedByDevice(String string) {
        if (supportedSet == null) {
            ConverterBridge.loadSupportedSet();
        }
        return supportedSet.size() == 0 || supportedSet.contains(string.toUpperCase());
    }

    private static boolean isSupportedByJ2SE(int n, String string) {
        try {
            switch (n) {
                case 0: {
                    Charset.forName(string);
                    return true;
                }
                case 1: {
                    return Charset.forName(string).canEncode();
                }
            }
            throw new IllegalArgumentException("Illegal type: " + n);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return false;
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return false;
        }
    }

    private static void loadSupportedSet() {
        supportedSet = new HashSet();
        String string = Device.getProperty("microedition.encoding.supported");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                supportedSet.add(string2.toUpperCase());
            }
        }
        if (supportedSet.size() > 0) {
            supportedSet.add("ISO8859-1");
            debug.println(2, "Supported encodings: {0}", (Object)supportedSet);
        } else {
            debug.println(2, "All of the encodings are supported");
        }
    }
}

