/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.bluetooth;

public class UUID {
    long highBits;
    long lowBits;
    private static final long BASE_UUID_HIGHT = 4096L;
    private static final long BASE_UUID_LOW = -9223371485494954757L;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public UUID(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("The 'uuidValue' is out of [0, 2^32 - 1] range: " + l);
        }
        this.highBits = l << 32 | 0x1000L;
        this.lowBits = -9223371485494954757L;
    }

    public UUID(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Specified 'uuidValue' is null");
        }
        if (string.length() == 0 || bl && string.length() > 8 || string.length() > 32) {
            throw new IllegalArgumentException("Invalid length of specified 'uuidValue': " + string.length());
        }
        if (string.indexOf(45) != -1) {
            throw new NumberFormatException("The '-' character is not allowed: " + string);
        }
        if (bl) {
            long l = Long.parseLong(string, 16);
            this.highBits = l << 32 | 0x1000L;
            this.lowBits = -9223371485494954757L;
            return;
        }
        this.highBits = 0L;
        if (string.length() < 16) {
            this.lowBits = Long.parseLong(string, 16);
            return;
        }
        int n = string.length();
        this.lowBits = Long.parseLong(string.substring(n - 8), 16);
        this.lowBits |= Long.parseLong(string.substring(n - 16, n - 8), 16) << 32;
        if (n == 16) {
            return;
        }
        if (n <= 24) {
            this.highBits = Long.parseLong(string.substring(0, n - 16), 16);
        } else {
            this.highBits = Long.parseLong(string.substring(n - 24, n - 16), 16);
            this.highBits |= Long.parseLong(string.substring(0, n - 24), 16) << 32;
        }
    }

    public String toString() {
        int n;
        int[] nArray = new int[]{(int)(this.lowBits & 0xFFFFFFFFL), (int)(this.lowBits >>> 32 & 0xFFFFFFFFL), (int)(this.highBits & 0xFFFFFFFFL), (int)(this.highBits >>> 32 & 0xFFFFFFFFL)};
        int n2 = 32;
        char[] cArray = new char[n2];
        int n3 = 4;
        int n4 = 16;
        int n5 = 15;
        int n6 = -1;
        for (n = 3; n >= 0; --n) {
            if (nArray[n] == 0) continue;
            n6 = n - 1;
            break;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0 && n6 < n && n != 0) continue;
            if (n6 >= n) {
                for (int i = 0; i < 8; ++i) {
                    cArray[--n2] = digits[nArray[n] & n5];
                    int n7 = n;
                    nArray[n7] = nArray[n7] >>> n3;
                }
                continue;
            }
            do {
                cArray[--n2] = digits[nArray[n] & n5];
                int n8 = n;
                nArray[n8] = nArray[n8] >>> n3;
            } while (nArray[n] != 0);
        }
        return new String(cArray, n2, 32 - n2);
    }

    public boolean equals(Object object) {
        return object instanceof UUID && this.lowBits == ((UUID)object).lowBits && this.highBits == ((UUID)object).highBits;
    }

    public int hashCode() {
        return (int)(this.highBits ^ this.highBits >> 32 ^ this.lowBits ^ this.lowBits >> 32);
    }
}

