/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.bluetooth;

import com.sun.kvem.bluetooth.BluetoothStateException;
import com.sun.kvem.bluetooth.LocalDevice;
import com.sun.kvem.jsr082.bluetooth.RemoteDeviceImpl;
import java.io.IOException;
import javax.microedition.io.Connection;

public class RemoteDevice {
    private long l_address;
    private String s_address;

    protected RemoteDevice(String string) {
        if (string == null) {
            throw new NullPointerException("null address");
        }
        String string2 = "Malformed address: " + string;
        if (string.length() != 12) {
            throw new IllegalArgumentException(string2);
        }
        if (string.startsWith("-")) {
            throw new IllegalArgumentException(string2);
        }
        try {
            this.l_address = Long.parseLong(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string2);
        }
        string = string.toUpperCase();
        try {
            String string3 = LocalDevice.getLocalDevice().getBluetoothAddress();
            if (string.equals(string3)) {
                throw new IllegalArgumentException("can't use the local address.");
            }
        }
        catch (BluetoothStateException bluetoothStateException) {
            throw new RuntimeException("Can't initialize bluetooth support");
        }
        this.s_address = string;
    }

    public boolean isTrustedDevice() {
        throw new RuntimeException("Not Implemented! Used to compile Code");
    }

    public String getFriendlyName(boolean bl) throws IOException {
        return null;
    }

    public final String getBluetoothAddress() {
        return this.s_address;
    }

    public boolean equals(Object object) {
        return object instanceof RemoteDevice && this.l_address == ((RemoteDevice)object).l_address;
    }

    public int hashCode() {
        return (int)(this.l_address >>> 24 ^ this.l_address & 0xFFFFFFL);
    }

    public static RemoteDevice getRemoteDevice(Connection connection) throws IOException {
        return RemoteDeviceImpl.getRemoteDevice(connection);
    }

    public boolean authenticate() throws IOException {
        throw new RuntimeException("Not Implemented! Used to compile Code");
    }

    public boolean authorize(Connection connection) throws IOException {
        throw new RuntimeException("Not Implemented! Used to compile Code");
    }

    public boolean encrypt(Connection connection, boolean bl) throws IOException {
        throw new RuntimeException("Not Implemented! Used to compile Code");
    }

    public boolean isAuthenticated() {
        throw new RuntimeException("Not Implemented! Used to compile Code");
    }

    public boolean isAuthorized(Connection connection) throws IOException {
        throw new RuntimeException("Not Implemented! Used to compile Code");
    }

    public boolean isEncrypted() {
        throw new RuntimeException("Not Implemented! Used to compile Code");
    }
}

