/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.bluetooth;

import com.sun.kvem.bluetooth.BluetoothStateException;
import com.sun.kvem.bluetooth.DeviceClass;
import com.sun.kvem.bluetooth.DiscoveryAgent;
import com.sun.kvem.bluetooth.ServiceRecord;
import com.sun.kvem.bluetooth.ServiceRegistrationException;
import com.sun.kvem.jsr082.bluetooth.LocalDeviceImpl;
import javax.microedition.io.Connection;

public class LocalDevice {
    private static LocalDevice localDevice;
    private static LocalDeviceImpl localDeviceImpl;
    private DiscoveryAgent discoveryAgent;

    private LocalDevice() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalDevice getLocalDevice() throws BluetoothStateException {
        Class clazz = LocalDevice.class;
        synchronized (clazz) {
            if (localDevice == null) {
                try {
                    localDevice = new LocalDevice();
                    if (LocalDevice.localDevice.discoveryAgent == null) {
                        LocalDevice.localDevice.discoveryAgent = new DiscoveryAgent();
                    }
                    localDeviceImpl = new LocalDeviceImpl(localDevice);
                }
                catch (BluetoothStateException bluetoothStateException) {
                    localDevice = null;
                    throw bluetoothStateException;
                }
                catch (Throwable throwable) {
                    localDevice = null;
                    throw new BluetoothStateException(throwable.toString());
                }
            }
        }
        return localDevice;
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public String getFriendlyName() {
        return localDeviceImpl.getFriendlyName();
    }

    public DeviceClass getDeviceClass() {
        return localDeviceImpl.getDeviceClass();
    }

    public static String getProperty(String string) {
        return localDevice != null ? localDeviceImpl.getProperty(string) : null;
    }

    public int getDiscoverable() {
        return localDeviceImpl.getDiscoverable();
    }

    public String getBluetoothAddress() {
        return localDeviceImpl.getBluetoothAddress();
    }

    public boolean setDiscoverable(int n) throws BluetoothStateException {
        return localDeviceImpl.setDiscoverable(n);
    }

    public ServiceRecord getRecord(Connection connection) {
        return localDeviceImpl.getRecord(connection);
    }

    public void updateRecord(ServiceRecord serviceRecord) throws ServiceRegistrationException {
        localDeviceImpl.updateRecord(serviceRecord);
    }
}

